/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.stax;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamReader;
import junit.framework.Assert;

public class XMLStreamReaderComparator
extends Assert {
    private static final Map noPrefixValueMap = Collections.singletonMap("", null);
    private final XMLStreamReader expected;
    private final XMLStreamReader actual;
    private final LinkedList path = new LinkedList();
    private final Set prefixes = new HashSet();
    private final Set namespaceURIs = new HashSet();

    public XMLStreamReaderComparator(XMLStreamReader expected, XMLStreamReader actual) {
        this.expected = expected;
        this.actual = actual;
    }

    private String getLocation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("event type ");
        buffer.append(this.expected.getEventType());
        buffer.append("; location ");
        Iterator it = this.path.iterator();
        while (it.hasNext()) {
            buffer.append('/');
            buffer.append(it.next());
        }
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] invoke(String methodName, Class[] paramTypes, Object[] args) throws Exception {
        Throwable actualException;
        Object actualResult;
        Throwable expectedException;
        Object expectedResult;
        Method method = XMLStreamReader.class.getMethod(methodName, paramTypes);
        try {
            expectedResult = method.invoke((Object)this.expected, args);
            expectedException = null;
        }
        catch (InvocationTargetException ex) {
            expectedResult = null;
            expectedException = ex.getCause();
        }
        try {
            actualResult = method.invoke((Object)this.actual, args);
            actualException = null;
        }
        catch (InvocationTargetException ex) {
            actualResult = null;
            actualException = ex.getCause();
        }
        if (expectedException == null) {
            if (actualException == null) return new Object[]{expectedResult, actualResult};
            actualException.printStackTrace(System.out);
            XMLStreamReaderComparator.fail((String)("Method " + methodName + " threw unexpected exception " + actualException.getClass().getName() + " (" + this.getLocation() + ")"));
            return null;
        } else if (actualException == null) {
            XMLStreamReaderComparator.fail((String)("Expected " + methodName + " to throw " + expectedException.getClass().getName() + ", but the method retuned normally (" + this.getLocation() + ")"));
            return null;
        } else {
            XMLStreamReaderComparator.assertEquals(expectedException.getClass(), actualException.getClass());
        }
        return null;
    }

    private Object[] invoke(String methodName) throws Exception {
        return this.invoke(methodName, new Class[0], new Object[0]);
    }

    private Object assertSameResult(String methodName, Class[] paramTypes, Object[] args, Map valueMap) throws Exception {
        Object[] results = this.invoke(methodName, paramTypes, args);
        if (results != null) {
            Object expected = results[0];
            Object actual = results[1];
            if (valueMap != null) {
                if (valueMap.containsKey(expected)) {
                    expected = valueMap.get(expected);
                }
                if (valueMap.containsKey(actual)) {
                    actual = valueMap.get(actual);
                }
            }
            XMLStreamReaderComparator.assertEquals((String)("Return value of " + methodName + " for arguments " + Arrays.asList(args) + " (" + this.getLocation() + ")"), (Object)expected, (Object)actual);
            return results[0];
        }
        return null;
    }

    private Object assertSameResult(String methodName, Class[] paramTypes, Object[] args) throws Exception {
        return this.assertSameResult(methodName, paramTypes, args, null);
    }

    private Object assertSameResult(String methodName, Map valueMap) throws Exception {
        return this.assertSameResult(methodName, new Class[0], new Object[0], valueMap);
    }

    private Object assertSameResult(String methodName) throws Exception {
        return this.assertSameResult(methodName, null);
    }

    private Set toPrefixSet(Iterator it) {
        HashSet<String> set = new HashSet<String>();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            set.add(prefix == null ? "" : prefix);
        }
        return set;
    }

    private void compareNamespaceContexts(NamespaceContext expected, NamespaceContext actual) {
        for (String prefix : this.prefixes) {
            if (prefix == null) continue;
            XMLStreamReaderComparator.assertEquals((String)("Namespace URI for prefix '" + prefix + "' (" + this.getLocation() + ")"), (String)expected.getNamespaceURI(prefix), (String)actual.getNamespaceURI(prefix));
        }
        for (String namespaceURI : this.namespaceURIs) {
            if (namespaceURI == null || namespaceURI.length() <= 0) continue;
            XMLStreamReaderComparator.assertEquals((String)("Prefix for namespace URI '" + namespaceURI + "' (" + this.getLocation() + ")"), (String)expected.getPrefix(namespaceURI), (String)actual.getPrefix(namespaceURI));
            XMLStreamReaderComparator.assertEquals((String)("Prefixes for namespace URI '" + namespaceURI + "' (" + this.getLocation() + ")"), (Object)this.toPrefixSet(expected.getPrefixes(namespaceURI)), (Object)this.toPrefixSet(actual.getPrefixes(namespaceURI)));
        }
    }

    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
    }

    public void compare() throws Exception {
        while (true) {
            int expectedNextEvent;
            int eventType;
            if ((eventType = ((Integer)this.assertSameResult("getEventType")).intValue()) == 1) {
                this.path.addLast(this.expected.getName());
            }
            Integer attributeCount = (Integer)this.assertSameResult("getAttributeCount");
            for (int i = 0; i < (attributeCount == null ? 1 : attributeCount); ++i) {
                Class[] paramTypes = new Class[]{Integer.TYPE};
                Object[] args = new Object[]{new Integer(i)};
                this.assertSameResult("getAttributeLocalName", paramTypes, args);
                this.assertSameResult("getAttributeName", paramTypes, args);
                this.namespaceURIs.add(this.assertSameResult("getAttributeNamespace", paramTypes, args));
                this.prefixes.add(this.assertSameResult("getAttributePrefix", paramTypes, args, noPrefixValueMap));
                this.assertSameResult("getAttributeType", paramTypes, args);
                this.assertSameResult("getAttributeValue", paramTypes, args);
                this.assertSameResult("isAttributeSpecified", paramTypes, args);
            }
            this.assertSameResult("getLocalName");
            this.assertSameResult("getName");
            Integer namespaceCount = (Integer)this.assertSameResult("getNamespaceCount");
            if (namespaceCount != null) {
                HashMap<String, String> expectedNamespaces = new HashMap<String, String>();
                HashMap<String, String> actualNamespaces = new HashMap<String, String>();
                for (int i = 0; i < namespaceCount; ++i) {
                    String expectedPrefix = this.expected.getNamespacePrefix(i);
                    String expectedNamespaceURI = this.expected.getNamespaceURI(i);
                    if (expectedNamespaceURI != null && expectedNamespaceURI.length() == 0) {
                        expectedNamespaceURI = null;
                    }
                    String actualPrefix = this.actual.getNamespacePrefix(i);
                    String actualNamespaceURI = this.actual.getNamespaceURI(i);
                    if (actualNamespaceURI != null && actualNamespaceURI.length() == 0) {
                        actualNamespaceURI = null;
                    }
                    expectedNamespaces.put(expectedPrefix, expectedNamespaceURI);
                    actualNamespaces.put(actualPrefix, actualNamespaceURI);
                    this.prefixes.add(expectedPrefix);
                    this.namespaceURIs.add(expectedNamespaceURI);
                }
                XMLStreamReaderComparator.assertEquals(expectedNamespaces, actualNamespaces);
            }
            this.namespaceURIs.add(this.assertSameResult("getNamespaceURI"));
            this.assertSameResult("getPIData");
            this.assertSameResult("getPITarget");
            this.prefixes.add(this.assertSameResult("getPrefix"));
            this.assertSameResult("getText");
            Integer textLength = (Integer)this.assertSameResult("getTextLength");
            Object[] textStart = this.invoke("getTextStart");
            Object[] textCharacters = this.invoke("getTextCharacters");
            if (textLength != null) {
                XMLStreamReaderComparator.assertEquals((String)new String((char[])textCharacters[0], (int)((Integer)textStart[0]), (int)textLength), (String)new String((char[])textCharacters[1], (int)((Integer)textStart[1]), (int)textLength));
            }
            this.assertSameResult("hasName");
            this.assertSameResult("hasText");
            this.assertSameResult("isCharacters");
            this.assertSameResult("isEndElement");
            this.assertSameResult("isStartElement");
            this.assertSameResult("isWhiteSpace");
            if (eventType == 1 || eventType == 2) {
                for (String prefix : this.prefixes) {
                    if (prefix == null || prefix.equals("xml")) continue;
                    this.assertSameResult("getNamespaceURI", new Class[]{String.class}, new Object[]{prefix});
                }
            }
            this.compareNamespaceContexts(this.expected.getNamespaceContext(), this.actual.getNamespaceContext());
            if (eventType == 2) {
                this.path.removeLast();
            }
            try {
                expectedNextEvent = this.expected.next();
            }
            catch (IllegalStateException ex) {
                expectedNextEvent = -1;
            }
            catch (NoSuchElementException ex) {
                expectedNextEvent = -1;
            }
            if (expectedNextEvent == -1) {
                try {
                    this.actual.next();
                }
                catch (IllegalStateException ex) {
                    break;
                }
                catch (NoSuchElementException ex) {
                    break;
                }
                XMLStreamReaderComparator.fail((String)"Expected reader to throw IllegalStateException or NoSuchElementException");
                continue;
            }
            XMLStreamReaderComparator.assertEquals((int)expectedNextEvent, (int)this.actual.next());
        }
    }
}

