/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XMLAssertEx {
    private XMLAssertEx() {
    }

    private static Document parse(InputSource is, boolean expandEntityReferences) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(expandEntityReferences);
        Document document = factory.newDocumentBuilder().parse(is);
        XMLAssertEx.replaceEntityReferences(document);
        return document;
    }

    private static void replaceEntityReferences(Node node) {
        NodeList children = node.getChildNodes();
        int l = children.getLength();
        for (int i = 0; i < l; ++i) {
            Node child = children.item(i);
            if (child instanceof EntityReference) {
                Element replacement = node.getOwnerDocument().createElementNS(null, "entity-reference");
                replacement.setAttributeNS(null, "name", child.getNodeName());
                node.replaceChild(replacement, child);
                continue;
            }
            XMLAssertEx.replaceEntityReferences(child);
        }
    }

    public static void assertXMLIdentical(URL control, InputStream test, boolean entityReferencesExpanded) throws Exception {
        InputSource controlInputSource = new InputSource(control.toString());
        InputSource testInputSource = new InputSource(test);
        testInputSource.setSystemId(new URL(control, "dummy.xml").toString());
        XMLAssertEx.assertXMLIdentical(controlInputSource, testInputSource, entityReferencesExpanded);
    }

    public static void assertXMLIdentical(InputSource control, InputSource test, boolean entityReferencesExpanded) throws Exception {
        XMLAssert.assertXMLIdentical((Diff)XMLUnit.compareXML((Document)XMLAssertEx.parse(control, entityReferencesExpanded), (Document)XMLAssertEx.parse(test, false)), (boolean)true);
    }
}

