/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.activation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import javax.activation.DataSource;

public class RandomDataSource
implements DataSource {
    private final long seed;
    private final int rangeStart;
    private final int rangeEnd;
    private final long length;

    public RandomDataSource(long seed, int rangeStart, int rangeEnd, long length) {
        this.seed = seed;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.length = length;
    }

    public RandomDataSource(long seed, long length) {
        this(seed, 0, 256, length);
    }

    public RandomDataSource(long length) {
        this(System.currentTimeMillis(), length);
    }

    public String getName() {
        return null;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public InputStream getInputStream() throws IOException {
        final Random random = new Random(this.seed);
        return new InputStream(){
            private long position;

            public int read() throws IOException {
                if (this.position == RandomDataSource.this.length) {
                    return -1;
                }
                ++this.position;
                return random.nextInt(RandomDataSource.this.rangeEnd - RandomDataSource.this.rangeStart) + RandomDataSource.this.rangeStart;
            }
        };
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

