/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.conformance;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.stax2.DTDInfo;

public final class ConformanceTestFile {
    private static ConformanceTestFile[] instances;
    private final String resourceName;
    private final String shortName;
    private final boolean hasDTD;
    private final boolean hasExternalSubset;
    private final boolean hasInternalSubset;
    private final boolean hasEntityReferences;

    private ConformanceTestFile(String resourceName, String shortName, boolean hasDTD, boolean hasExternalSubset, boolean hasInternalSubset, boolean hasEntityReferences) {
        this.resourceName = resourceName;
        this.shortName = shortName;
        this.hasDTD = hasDTD;
        this.hasExternalSubset = hasExternalSubset;
        this.hasInternalSubset = hasInternalSubset;
        this.hasEntityReferences = hasEntityReferences;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean hasDTD() {
        return this.hasDTD;
    }

    public boolean hasExternalSubset() {
        return this.hasExternalSubset;
    }

    public boolean hasInternalSubset() {
        return this.hasInternalSubset;
    }

    public boolean hasEntityReferences() {
        return this.hasEntityReferences;
    }

    public InputStream getAsStream() {
        return ConformanceTestFile.class.getClassLoader().getResourceAsStream(this.resourceName);
    }

    public URL getUrl() {
        return ConformanceTestFile.class.getClassLoader().getResource(this.resourceName);
    }

    public static synchronized ConformanceTestFile[] getConformanceTestFiles() {
        if (instances == null) {
            try {
                String name;
                BufferedReader in = new BufferedReader(new InputStreamReader(ConformanceTestFile.class.getResourceAsStream("filelist")));
                ArrayList<ConformanceTestFile> result = new ArrayList<ConformanceTestFile>(10);
                WstxInputFactory inputFactory = new WstxInputFactory();
                inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
                while ((name = in.readLine()) != null) {
                    String resourceName = "org/apache/axiom/testutils/conformance/" + name;
                    boolean hasDTD = false;
                    boolean hasExternalSubset = false;
                    boolean hasInternalSubset = false;
                    boolean hasEntityReferences = false;
                    try {
                        XMLStreamReader reader = inputFactory.createXMLStreamReader(new StreamSource(ConformanceTestFile.class.getResource(name).toString()));
                        while (reader.hasNext()) {
                            switch (reader.next()) {
                                case 11: {
                                    hasDTD = true;
                                    hasInternalSubset = reader.getText().length() > 0;
                                    hasExternalSubset = ((DTDInfo)reader).getDTDSystemId() != null;
                                    break;
                                }
                                case 9: {
                                    hasEntityReferences = true;
                                }
                            }
                        }
                        reader.close();
                    }
                    catch (XMLStreamException ex) {
                        throw new Error("Unable to parse " + resourceName);
                    }
                    result.add(new ConformanceTestFile(resourceName, name, hasDTD, hasExternalSubset, hasInternalSubset, hasEntityReferences));
                }
                in.close();
                return result.toArray(new ConformanceTestFile[result.size()]);
            }
            catch (IOException ex) {
                throw new Error("Unable to load file list: " + ex.getMessage());
            }
        }
        return (ConformanceTestFile[])instances.clone();
    }
}

