/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;

public class ByteStreamComparator
extends OutputStream {
    private final InputStream in;
    private final byte[] compareBuffer = new byte[1024];
    private int position;

    public ByteStreamComparator(InputStream in) {
        this.in = in;
    }

    public void write(byte[] buffer, int off, int len) throws IOException {
        while (len > 0) {
            int c = this.in.read(this.compareBuffer, 0, Math.min(this.compareBuffer.length, len));
            if (c == -1) {
                Assert.fail((String)"The two streams have different lengths");
            }
            for (int i = 0; i < c; ++i) {
                if (buffer[off] != this.compareBuffer[i]) {
                    Assert.fail((String)("Byte mismatch at position " + this.position));
                }
                ++off;
                --len;
                ++this.position;
            }
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (this.in.read() != -1) {
            Assert.fail((String)"The two streams have different lengths");
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }
}

