/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class ExceptionInputStream
extends ProxyInputStream {
    private int remaining;

    public ExceptionInputStream(InputStream in) {
        this(in, Integer.MAX_VALUE);
    }

    public ExceptionInputStream(InputStream in, int maxBytes) {
        super(in);
        this.remaining = maxBytes;
    }

    public int read() throws IOException {
        if (this.remaining == 0) {
            throw new IOException("Maximum number of bytes read");
        }
        int b = super.read();
        if (b == -1) {
            throw new IOException("End of stream reached");
        }
        --this.remaining;
        return b;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining == 0) {
            throw new IOException("Maximum number of bytes read");
        }
        int c = super.read(b, off, Math.min(Math.max(1, this.remaining / 2), len));
        if (c == -1) {
            throw new IOException("End of stream reached");
        }
        this.remaining -= c;
        return c;
    }
}

