/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.stax;

import java.io.StringReader;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.InputSource;

public interface Normalizer {
    public static final Normalizer IDENTITY = new Normalizer(){

        public Object normalize(Object value) {
            return value;
        }
    };
    public static final Normalizer LOWER_CASE = new Normalizer(){

        public Object normalize(Object value) {
            return value == null ? null : ((String)value).toLowerCase(Locale.ENGLISH);
        }
    };
    public static final Normalizer DTD = new Normalizer(){

        public Object normalize(Object value) throws Exception {
            String content = (String)value;
            if (content == null || content.trim().length() == 0) {
                return null;
            }
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader("<!DOCTYPE root [" + content + "]><root/>"))).getDoctype().getInternalSubset();
        }
    };
    public static final Normalizer EMPTY_STRING_TO_NULL = new Normalizer(){

        public Object normalize(Object value) {
            return "".equals(value) ? null : value;
        }
    };

    public Object normalize(Object var1) throws Exception;
}

