/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.test;

import java.util.Comparator;
import java.util.List;
import org.jaxen.expr.AdditiveExpr;
import org.jaxen.expr.AllNodeStep;
import org.jaxen.expr.CommentNodeStep;
import org.jaxen.expr.EqualityExpr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.LogicalExpr;
import org.jaxen.expr.MultiplicativeExpr;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.PathExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.ProcessingInstructionNodeStep;
import org.jaxen.expr.RelationalExpr;
import org.jaxen.expr.TextNodeStep;
import org.jaxen.expr.UnaryExpr;
import org.jaxen.expr.UnionExpr;
import org.jaxen.expr.VariableReferenceExpr;

class ExprComparator
implements Comparator {
    public static final Comparator EXPR_COMPARATOR = new ExprComparator();
    private static final int TYPE_ADDITIVE_EXPR = 1;
    private static final int TYPE_ALL_NODE_STEP = 2;
    private static final int TYPE_COMMENT_NODE_STEP = 3;
    private static final int TYPE_EQUALITY_EXPR = 4;
    private static final int TYPE_FILTER_EXPR = 5;
    private static final int TYPE_FUNCTION_CALL_EXPR = 6;
    private static final int TYPE_LITERAL_EXPR = 7;
    private static final int TYPE_LOCATION_PATH = 8;
    private static final int TYPE_LOGICAL_EXP = 9;
    private static final int TYPE_MULTIPLICATIVE_EXPR = 10;
    private static final int TYPE_NAME_STEP = 11;
    private static final int TYPE_NUMBER_EXPR = 12;
    private static final int TYPE_PATH_EXPR = 13;
    private static final int TYPE_PREDICATE = 14;
    private static final int TYPE_PROCESSING_INSTRUCTION_NODE_STEP = 15;
    private static final int TYPE_RELATIONAL_EXPR = 16;
    private static final int TYPE_TEXT_NODE_STEP = 17;
    private static final int TYPE_UNARY_EXPR = 18;
    private static final int TYPE_UNION_EXPR = 19;
    private static final int TYPE_VARIABLE_REFERENCE_EXPR = 20;

    private ExprComparator() {
    }

    public int compare(Object o1, Object o2) {
        int cmp;
        block36: {
            int type2;
            int type1;
            block35: {
                type1 = this.getType(o1);
                if (type1 != (type2 = this.getType(o2))) break block35;
                switch (type1) {
                    case 1: {
                        AdditiveExpr additiveExpr1 = (AdditiveExpr)o1;
                        AdditiveExpr additiveExpr2 = (AdditiveExpr)o2;
                        cmp = additiveExpr1.getOperator().compareTo(additiveExpr2.getOperator());
                        if (cmp == 0 && (cmp = this.compare(additiveExpr1.getLHS(), additiveExpr2.getLHS())) == 0) {
                            cmp = this.compare(additiveExpr1.getRHS(), additiveExpr2.getRHS());
                        }
                        break block36;
                    }
                    case 2: {
                        AllNodeStep allNodeStep1 = (AllNodeStep)o1;
                        AllNodeStep allNodeStep2 = (AllNodeStep)o2;
                        cmp = allNodeStep1.getAxis() - allNodeStep2.getAxis();
                        if (cmp == 0) {
                            cmp = this.compareLists(allNodeStep1.getPredicates(), allNodeStep2.getPredicates());
                        }
                        break block36;
                    }
                    case 3: {
                        CommentNodeStep commentNodeStep1 = (CommentNodeStep)o1;
                        CommentNodeStep commentNodeStep2 = (CommentNodeStep)o2;
                        cmp = commentNodeStep1.getAxis() - commentNodeStep2.getAxis();
                        if (cmp == 0) {
                            cmp = this.compareLists(commentNodeStep1.getPredicates(), commentNodeStep2.getPredicates());
                        }
                        break block36;
                    }
                    case 4: {
                        EqualityExpr equalityExpr1 = (EqualityExpr)o1;
                        EqualityExpr equalityExpr2 = (EqualityExpr)o2;
                        cmp = equalityExpr1.getOperator().compareTo(equalityExpr2.getOperator());
                        if (cmp == 0 && (cmp = this.compare(equalityExpr1.getLHS(), equalityExpr1.getLHS())) == 0) {
                            cmp = this.compare(equalityExpr1.getRHS(), equalityExpr1.getRHS());
                        }
                        break block36;
                    }
                    case 5: {
                        throw new RuntimeException("Not yet implemented!");
                    }
                    case 6: {
                        FunctionCallExpr functionCallExpr1 = (FunctionCallExpr)o1;
                        FunctionCallExpr functionCallExpr2 = (FunctionCallExpr)o2;
                        cmp = this.compareStrings(functionCallExpr1.getPrefix(), functionCallExpr2.getPrefix());
                        if (cmp == 0 && (cmp = functionCallExpr1.getFunctionName().compareTo(functionCallExpr2.getFunctionName())) == 0) {
                            cmp = this.compareLists(functionCallExpr1.getParameters(), functionCallExpr2.getParameters());
                        }
                        break block36;
                    }
                    case 7: {
                        LiteralExpr literalExpr1 = (LiteralExpr)o1;
                        LiteralExpr literalExpr2 = (LiteralExpr)o2;
                        cmp = literalExpr1.getLiteral().compareTo(literalExpr2.getLiteral());
                        break block36;
                    }
                    case 8: {
                        LocationPath locationPath1 = (LocationPath)o1;
                        LocationPath locationPath2 = (LocationPath)o2;
                        cmp = locationPath1.isAbsolute() == locationPath2.isAbsolute() ? this.compareLists(locationPath1.getSteps(), locationPath2.getSteps()) : (locationPath1.isAbsolute() ? 1 : -1);
                        break block36;
                    }
                    case 9: {
                        LogicalExpr logicalExpr1 = (LogicalExpr)o1;
                        LogicalExpr logicalExpr2 = (LogicalExpr)o2;
                        cmp = logicalExpr1.getOperator().compareTo(logicalExpr2.getOperator());
                        if (cmp == 0 && (cmp = this.compare(logicalExpr1.getLHS(), logicalExpr2.getLHS())) == 0) {
                            cmp = this.compare(logicalExpr1.getRHS(), logicalExpr2.getRHS());
                        }
                        break block36;
                    }
                    case 10: {
                        MultiplicativeExpr multiplicativeExpr1 = (MultiplicativeExpr)o1;
                        MultiplicativeExpr multiplicativeExpr2 = (MultiplicativeExpr)o2;
                        cmp = multiplicativeExpr1.getOperator().compareTo(multiplicativeExpr2.getOperator());
                        if (cmp == 0 && (cmp = this.compare(multiplicativeExpr1.getLHS(), multiplicativeExpr2.getLHS())) == 0) {
                            cmp = this.compare(multiplicativeExpr1.getRHS(), multiplicativeExpr2.getRHS());
                        }
                        break block36;
                    }
                    case 11: {
                        NameStep nameStep1 = (NameStep)o1;
                        NameStep nameStep2 = (NameStep)o2;
                        cmp = nameStep1.getAxis() - nameStep2.getAxis();
                        if (cmp == 0 && (cmp = this.compareStrings(nameStep1.getPrefix(), nameStep2.getPrefix())) == 0 && (cmp = nameStep1.getLocalName().compareTo(nameStep2.getLocalName())) == 0) {
                            cmp = this.compareLists(nameStep1.getPredicates(), nameStep2.getPredicates());
                        }
                        break block36;
                    }
                    case 12: {
                        NumberExpr numberExpr1 = (NumberExpr)o1;
                        NumberExpr numberExpr2 = (NumberExpr)o2;
                        cmp = new Double(numberExpr1.getNumber().doubleValue()).compareTo(new Double(numberExpr2.getNumber().doubleValue()));
                        break block36;
                    }
                    case 13: {
                        PathExpr pathExpr1 = (PathExpr)o1;
                        PathExpr pathExpr2 = (PathExpr)o2;
                        cmp = this.compare(pathExpr1.getLocationPath(), pathExpr2.getLocationPath());
                        if (cmp == 0) {
                            cmp = this.compare(pathExpr1.getFilterExpr(), pathExpr2.getFilterExpr());
                        }
                        break block36;
                    }
                    case 14: {
                        Predicate predicate1 = (Predicate)o1;
                        Predicate predicate2 = (Predicate)o2;
                        cmp = this.compare(predicate1.getExpr(), predicate2.getExpr());
                        break block36;
                    }
                    case 15: {
                        ProcessingInstructionNodeStep processingInstructionNodeStep1 = (ProcessingInstructionNodeStep)o1;
                        ProcessingInstructionNodeStep processingInstructionNodeStep2 = (ProcessingInstructionNodeStep)o2;
                        cmp = processingInstructionNodeStep1.getAxis() - processingInstructionNodeStep2.getAxis();
                        if (cmp == 0 && (cmp = this.compareStrings(processingInstructionNodeStep1.getName(), processingInstructionNodeStep2.getName())) == 0) {
                            cmp = this.compareLists(processingInstructionNodeStep1.getPredicates(), processingInstructionNodeStep2.getPredicates());
                        }
                        break block36;
                    }
                    case 16: {
                        RelationalExpr relationalExpr1 = (RelationalExpr)o1;
                        RelationalExpr relationalExpr2 = (RelationalExpr)o2;
                        cmp = relationalExpr1.getOperator().compareTo(relationalExpr2.getOperator());
                        if (cmp == 0 && (cmp = this.compare(relationalExpr1.getLHS(), relationalExpr2.getLHS())) == 0) {
                            cmp = this.compare(relationalExpr1.getRHS(), relationalExpr2.getRHS());
                        }
                        break block36;
                    }
                    case 17: {
                        TextNodeStep textNodeStep1 = (TextNodeStep)o1;
                        TextNodeStep textNodeStep2 = (TextNodeStep)o2;
                        cmp = textNodeStep1.getAxis() - textNodeStep2.getAxis();
                        if (cmp == 0) {
                            cmp = this.compareLists(textNodeStep1.getPredicates(), textNodeStep2.getPredicates());
                        }
                        break block36;
                    }
                    case 18: {
                        UnaryExpr unaryExpr1 = (UnaryExpr)o1;
                        UnaryExpr unaryExpr2 = (UnaryExpr)o2;
                        cmp = this.compare(unaryExpr1.getExpr(), unaryExpr2.getExpr());
                        break block36;
                    }
                    case 19: {
                        throw new RuntimeException("Not yet implemented!");
                    }
                    case 20: {
                        VariableReferenceExpr variableReferenceExpr1 = (VariableReferenceExpr)o1;
                        VariableReferenceExpr variableReferenceExpr2 = (VariableReferenceExpr)o2;
                        cmp = this.compareStrings(variableReferenceExpr1.getPrefix(), variableReferenceExpr2.getPrefix());
                        if (cmp == 0) {
                            cmp = variableReferenceExpr1.getVariableName().compareTo(variableReferenceExpr2.getVariableName());
                        }
                        break block36;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled type: " + type1);
                    }
                }
            }
            cmp = type1 - type2;
        }
        return cmp;
    }

    private int compareStrings(String s1, String s2) {
        int cmp = s1 == s2 ? 0 : (s1 == null ? -1 : (s2 == null ? 1 : s1.compareTo(s2)));
        return cmp;
    }

    private int compareLists(List list1, List list2) {
        int cmp;
        if (list1 == list2) {
            cmp = 0;
        } else if (list1 == null) {
            cmp = -1;
        } else if (list2 == null) {
            cmp = 1;
        } else {
            cmp = list1.size() - list2.size();
            if (cmp == 0) {
                for (int i = 0; i < list1.size() && cmp == 0; ++i) {
                    cmp = this.compare(list1.get(i), list2.get(i));
                }
            }
        }
        return cmp;
    }

    private int getType(Object node) {
        if (node instanceof AdditiveExpr) {
            return 1;
        }
        if (node instanceof AllNodeStep) {
            return 2;
        }
        if (node instanceof CommentNodeStep) {
            return 3;
        }
        if (node instanceof EqualityExpr) {
            return 4;
        }
        if (node instanceof FilterExpr) {
            return 5;
        }
        if (node instanceof FunctionCallExpr) {
            return 6;
        }
        if (node instanceof LiteralExpr) {
            return 7;
        }
        if (node instanceof LocationPath) {
            return 8;
        }
        if (node instanceof LogicalExpr) {
            return 9;
        }
        if (node instanceof MultiplicativeExpr) {
            return 10;
        }
        if (node instanceof NameStep) {
            return 11;
        }
        if (node instanceof NumberExpr) {
            return 12;
        }
        if (node instanceof PathExpr) {
            return 13;
        }
        if (node instanceof Predicate) {
            return 14;
        }
        if (node instanceof ProcessingInstructionNodeStep) {
            return 15;
        }
        if (node instanceof RelationalExpr) {
            return 16;
        }
        if (node instanceof TextNodeStep) {
            return 17;
        }
        if (node instanceof UnaryExpr) {
            return 18;
        }
        if (node instanceof UnionExpr) {
            return 19;
        }
        if (node instanceof VariableReferenceExpr) {
            return 20;
        }
        throw new IllegalArgumentException("Unknown Jaxen AST node type: " + node);
    }
}

