/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common;

import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.util.CharacterDataAccumulator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;

public final class SAXResultContentHandler
implements XmlHandler {
    private final OMContainer root;
    private final OMFactory factory;
    private OMContainer target;
    private final CharacterDataAccumulator buffer = new CharacterDataAccumulator();
    private boolean buffering;
    private String piTarget;

    public SAXResultContentHandler(OMContainer root) {
        this.root = root;
        this.factory = root.getOMFactory();
    }

    private String stopBuffering() {
        String content = this.buffer.toString();
        this.buffer.clear();
        this.buffering = false;
        return content;
    }

    public void startDocument(String inputEncoding, String xmlVersion, String xmlEncoding, Boolean standalone) {
        this.target = this.root;
    }

    public void startFragment() throws StreamException {
        throw new UnsupportedOperationException();
    }

    public void completed() {
    }

    public void processDocumentTypeDeclaration(String rootName, String publicId, String systemId, String internalSubset) {
        if (this.target instanceof OMDocument) {
            this.factory.createOMDocType(this.target, rootName, publicId, systemId, internalSubset);
        }
    }

    public void startElement(String namespaceURI, String localName, String prefix) {
        this.target = this.factory.createOMElement(localName, this.factory.createOMNamespace(namespaceURI, prefix), this.target);
    }

    public void endElement() {
        this.target = ((OMNode)this.target).getParent();
    }

    public void processAttribute(String namespaceURI, String localName, String prefix, String value, String type, boolean specified) {
        OMNamespace ns;
        OMElement element = (OMElement)this.target;
        if (namespaceURI.length() > 0) {
            ns = element.findNamespace(namespaceURI, prefix);
            if (ns == null) {
                throw new OMException("Unbound namespace " + namespaceURI);
            }
        } else {
            ns = null;
        }
        OMAttribute attr = element.addAttribute(localName, value, ns);
        attr.setAttributeType(type);
    }

    public void processAttribute(String name, String value, String type, boolean specified) throws StreamException {
        throw new UnsupportedOperationException();
    }

    public void processNamespaceDeclaration(String prefix, String namespaceURI) {
        if (prefix.isEmpty()) {
            ((OMElement)this.target).declareDefaultNamespace(namespaceURI);
        } else {
            ((OMElement)this.target).declareNamespace(namespaceURI, prefix);
        }
    }

    public void attributesCompleted() {
    }

    public void processCharacterData(Object data, boolean ignorable) {
        if (this.buffering) {
            this.buffer.append(data);
        } else {
            this.factory.createOMText(this.target, data.toString(), ignorable ? 6 : 4);
        }
    }

    public void startCDATASection() throws StreamException {
        this.buffering = true;
    }

    public void endCDATASection() throws StreamException {
        this.factory.createOMText(this.target, this.stopBuffering(), 12);
    }

    public void startProcessingInstruction(String target) throws StreamException {
        this.buffering = true;
        this.piTarget = target;
    }

    public void endProcessingInstruction() throws StreamException {
        this.factory.createOMProcessingInstruction(this.target, this.piTarget, this.stopBuffering());
        this.piTarget = null;
    }

    public void startComment() throws StreamException {
        this.buffering = true;
    }

    public void endComment() throws StreamException {
        this.factory.createOMComment(this.target, this.stopBuffering());
    }

    public void processEntityReference(String name, String replacementText) {
        if (replacementText != null) {
            throw new UnsupportedOperationException();
        }
        this.factory.createOMEntityReference(this.target, name);
    }

    public boolean drain() throws StreamException {
        return true;
    }
}

