/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.mixin;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.ElementAction;
import org.apache.axiom.core.ElementMatcher;
import org.apache.axiom.core.Mappers;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.LiveNamespaceContext;
import org.apache.axiom.om.impl.common.NSUtil;
import org.apache.axiom.om.impl.common.NamespaceDeclarationMapper;
import org.apache.axiom.om.impl.common.NamespaceIterator;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.intf.AxiomAttribute;
import org.apache.axiom.om.impl.intf.AxiomChildNode;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomNamespaceDeclaration;
import org.apache.axiom.om.impl.intf.Sequence;
import org.apache.axiom.util.namespace.MapBasedNamespaceContext;
import org.apache.axiom.util.stax.XMLStreamIOException;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;
import org.apache.axiom.util.xml.NSUtils;
import org.apache.axiom.util.xml.QNameCache;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class AxiomElementMixin
implements AxiomElement {
    private static final OMNamespace XMLNS = new OMNamespaceImpl("http://www.w3.org/XML/1998/namespace", "xml");

    @Override
    public final void initName(String localName, OMNamespace ns, boolean generateNSDecl) {
        this.internalSetLocalName(localName);
        this.internalSetNamespace(generateNSDecl ? NSUtil.handleNamespace(this, ns, false, true) : ns);
    }

    @Override
    public final void beforeSetLocalName() {
        this.forceExpand();
    }

    public final int getType() {
        return 1;
    }

    public final void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.forceExpand();
        this.internalSetNamespace(namespace);
    }

    public final void setNamespace(OMNamespace namespace, boolean decl) {
        this.forceExpand();
        this.internalSetNamespace(NSUtil.handleNamespace(this, namespace, false, decl));
    }

    public final OMElement getFirstElement() {
        for (OMNode node = this.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            return (OMElement)node;
        }
        return null;
    }

    public final Iterator<OMElement> getChildElements() {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.ANY, null, null, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    public final Iterator<OMNamespace> getNamespacesInScope() {
        return new NamespaceIterator(this);
    }

    public NamespaceContext getNamespaceContext(boolean detached) {
        if (detached) {
            HashMap<String, String> namespaces = new HashMap<String, String>();
            Iterator<OMNamespace> it = this.getNamespacesInScope();
            while (it.hasNext()) {
                OMNamespace ns = it.next();
                namespaces.put(ns.getPrefix(), ns.getNamespaceURI());
            }
            return new MapBasedNamespaceContext(namespaces);
        }
        return new LiveNamespaceContext(this);
    }

    public final QName resolveQName(String qname) {
        int idx = qname.indexOf(58);
        if (idx == -1) {
            OMNamespace ns = this.getDefaultNamespace();
            return QNameCache.getQName((String)(ns == null ? "" : ns.getNamespaceURI()), (String)qname);
        }
        String prefix = qname.substring(0, idx);
        OMNamespace ns = this.findNamespace(null, prefix);
        return ns == null ? null : QNameCache.getQName((String)ns.getNamespaceURI(), (String)qname.substring(idx + 1), (String)prefix);
    }

    public final String getText() {
        try {
            return this.coreGetCharacterData(ElementAction.SKIP).toString();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final QName getTextAsQName() {
        String childText = this.getText().trim();
        return childText.length() == 0 ? null : this.resolveQName(childText);
    }

    public Reader getTextAsStream(boolean cache) {
        if (!(this instanceof OMSourcedElement || cache && !this.isComplete())) {
            OMNode child = this.getFirstOMChild();
            if (child == null) {
                return new StringReader("");
            }
            if (child.getNextOMSibling() == null) {
                return new StringReader(child instanceof OMText ? ((OMText)child).getText() : "");
            }
        }
        try {
            final XMLStreamReader reader = this.getXMLStreamReader(cache);
            if (reader.getEventType() == 7) {
                reader.next();
            }
            Reader stream = XMLStreamReaderUtils.getElementTextAsStream((XMLStreamReader)reader, (boolean)true);
            if (!cache) {
                stream = new FilterReader(stream){

                    @Override
                    public void close() throws IOException {
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException ex) {
                            throw new XMLStreamIOException(ex);
                        }
                    }
                };
            }
            return stream;
        }
        catch (XMLStreamException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    public void writeTextTo(Writer out, boolean cache) throws IOException {
        try {
            XMLStreamReader reader = this.getXMLStreamReader(cache);
            int depth = 0;
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 4: 
                    case 12: {
                        if (depth != 1) break;
                        out.write(reader.getText());
                        break;
                    }
                    case 1: {
                        ++depth;
                        break;
                    }
                    case 2: {
                        --depth;
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    public final void setText(String text) {
        try {
            this.coreSetCharacterData(text, AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final void setText(QName qname) {
        this.removeChildren();
        if (qname != null) {
            OMNamespace ns = this.handleNamespace(qname.getNamespaceURI(), qname.getPrefix());
            this.getOMFactory().createOMText((OMContainer)this, ns == null ? qname.getLocalPart() : ns.getPrefix() + ":" + qname.getLocalPart());
        }
    }

    public final void discard() {
        try {
            this.coreDiscard(true);
            this.detach();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public <T extends OMElement> void insertChild(Sequence sequence, int pos, T newChild, boolean allowReplace) {
        if (!sequence.item(pos).isInstance(newChild)) {
            throw new IllegalArgumentException();
        }
        Class<? extends OMElement> type = sequence.item(pos);
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (!(child instanceof OMElement)) continue;
            if (child == newChild) {
                return;
            }
            if (type.isInstance(child)) {
                if (!allowReplace) {
                    throw new OMException("The element already has a child of type " + type.getName());
                }
                child.insertSiblingAfter(newChild);
                child.detach();
                return;
            }
            boolean isAfter = false;
            for (int i = 0; i < pos; ++i) {
                if (!sequence.item(i).isInstance(child)) continue;
                isAfter = true;
                break;
            }
            if (isAfter) continue;
            child.insertSiblingBefore(newChild);
            return;
        }
        this.addChild((OMNode)newChild);
    }

    @Override
    public final OMNamespace handleNamespace(String namespaceURI, String prefix) {
        if (prefix.length() == 0 && namespaceURI.length() == 0) {
            OMNamespace namespace = this.getDefaultNamespace();
            if (namespace != null) {
                this.declareDefaultNamespace("");
            }
            return null;
        }
        OMNamespace namespace = this.findNamespace(namespaceURI, prefix);
        if (namespace == null) {
            namespace = this.declareNamespace(namespaceURI, prefix.length() > 0 ? prefix : null);
        }
        return namespace;
    }

    public final void internalAppendAttribute(OMAttribute attr) {
        this.coreSetAttribute(AxiomSemantics.ATTRIBUTE_MATCHER, (CoreAttribute)((AxiomAttribute)attr), AxiomSemantics.INSTANCE);
    }

    public final OMAttribute addAttribute(OMAttribute attr) {
        OMElement owner = attr.getOwner();
        if (owner != null) {
            if (owner == this) {
                return attr;
            }
            attr = this.getOMFactory().createOMAttribute(attr.getLocalName(), attr.getNamespace(), attr.getAttributeValue());
        }
        NSUtil.handleNamespace(this, attr.getNamespace(), true, true);
        this.internalAppendAttribute(attr);
        return attr;
    }

    public final OMAttribute addAttribute(String localName, String value, OMNamespace ns) {
        OMNamespace namespace = null;
        if (ns != null) {
            String namespaceURI = ns.getNamespaceURI();
            String prefix = ns.getPrefix();
            if ((namespaceURI.length() > 0 || prefix != null) && ((namespace = this.findNamespace(namespaceURI, prefix)) == null || prefix == null && namespace.getPrefix().length() == 0)) {
                namespace = new OMNamespaceImpl(namespaceURI, prefix != null ? prefix : NSUtils.generatePrefix((String)namespaceURI));
            }
        }
        return this.addAttribute(this.getOMFactory().createOMAttribute(localName, namespace, value));
    }

    public final Iterator<OMAttribute> getAllAttributes() {
        return this.coreGetAttributesByType(AxiomAttribute.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    public final OMAttribute getAttribute(QName qname) {
        return (AxiomAttribute)this.coreGetAttribute(AxiomSemantics.ATTRIBUTE_MATCHER, qname.getNamespaceURI(), qname.getLocalPart());
    }

    public final String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    @Override
    public final void _setAttributeValue(QName qname, String value) {
        OMAttribute attr = this.getAttribute(qname);
        if (attr != null) {
            attr.setAttributeValue(value);
        } else {
            this.addAttribute(qname.getLocalPart(), value, new OMNamespaceImpl(qname.getNamespaceURI(), qname.getLocalPart()));
        }
    }

    public final void removeAttribute(OMAttribute attr) {
        if (attr.getOwner() != this) {
            throw new OMException("The attribute is not owned by this element");
        }
        ((AxiomAttribute)attr).coreRemove(AxiomSemantics.INSTANCE);
    }

    @Override
    public final void addNamespaceDeclaration(OMNamespace ns) {
        AxiomNamespaceDeclaration decl = this.getNodeFactory().createNamespaceDeclaration();
        decl.setDeclaredNamespace(ns);
        this.coreSetAttribute(AxiomSemantics.NAMESPACE_DECLARATION_MATCHER, (CoreAttribute)decl, AxiomSemantics.INSTANCE);
    }

    public final Iterator<OMNamespace> getAllDeclaredNamespaces() {
        return this.coreGetAttributesByType(AxiomNamespaceDeclaration.class, NamespaceDeclarationMapper.INSTANCE, AxiomSemantics.INSTANCE);
    }

    public final OMNamespace declareNamespace(OMNamespace namespace) {
        String prefix = namespace.getPrefix();
        String namespaceURI = namespace.getNamespaceURI();
        if (prefix == null) {
            prefix = NSUtils.generatePrefix((String)namespaceURI);
            namespace = new OMNamespaceImpl(namespaceURI, prefix);
        }
        if (prefix.length() > 0 && namespaceURI.length() == 0) {
            throw new IllegalArgumentException("Cannot bind a prefix to the empty namespace name");
        }
        this.addNamespaceDeclaration(namespace);
        return namespace;
    }

    public final OMNamespace declareNamespace(String uri, String prefix) {
        return this.declareNamespace(new OMNamespaceImpl(uri, prefix));
    }

    public final OMNamespace declareDefaultNamespace(String uri) {
        OMNamespace elementNamespace = this.getNamespace();
        if (elementNamespace == null && uri.length() > 0 || elementNamespace != null && elementNamespace.getPrefix().length() == 0 && !elementNamespace.getNamespaceURI().equals(uri)) {
            throw new OMException("Attempt to add a namespace declaration that conflicts with the namespace information of the element");
        }
        OMNamespaceImpl namespace = new OMNamespaceImpl(uri == null ? "" : uri, "");
        this.addNamespaceDeclaration(namespace);
        return namespace;
    }

    public final void undeclarePrefix(String prefix) {
        this.addNamespaceDeclaration(new OMNamespaceImpl("", prefix));
    }

    public final OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace = this.findDeclaredNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        OMContainer parent = this.getParent();
        if (parent != null && parent instanceof OMElement && (namespace = ((OMElement)parent).findNamespace(uri, prefix)) != null && this.findDeclaredNamespace(null, namespace.getPrefix()) != null) {
            namespace = null;
        }
        return namespace;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            if (!(attr instanceof AxiomNamespaceDeclaration)) continue;
            OMNamespace namespace = ((AxiomNamespaceDeclaration)attr).getDeclaredNamespace();
            if (prefix != null && !prefix.equals(namespace.getPrefix()) || uri != null && !uri.equals(namespace.getNamespaceURI())) continue;
            return namespace;
        }
        if ((prefix == null || prefix.equals("xml")) && (uri == null || uri.equals("http://www.w3.org/XML/1998/namespace"))) {
            return XMLNS;
        }
        return null;
    }

    public final OMNamespace findNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            AxiomNamespaceDeclaration nsDecl;
            if (!(attr instanceof AxiomNamespaceDeclaration) || !(nsDecl = (AxiomNamespaceDeclaration)attr).coreGetDeclaredPrefix().equals(prefix)) continue;
            OMNamespace ns = nsDecl.getDeclaredNamespace();
            if (ns.getNamespaceURI().length() == 0) {
                return null;
            }
            return ns;
        }
        OMContainer parent = this.getParent();
        if (parent instanceof OMElement) {
            return ((OMElement)parent).findNamespaceURI(prefix);
        }
        return null;
    }

    public final OMNamespace getDefaultNamespace() {
        return this.findNamespaceURI("");
    }

    public final String toStringWithConsume() throws XMLStreamException {
        StringWriter sw = new StringWriter();
        this.serializeAndConsume(sw);
        return sw.toString();
    }

    public final String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.serialize(sw);
        }
        catch (XMLStreamException ex) {
            throw new OMException("Failed to serialize node", (Throwable)ex);
        }
        return sw.toString();
    }

    public final OMElement cloneOMElement() {
        return (OMElement)this.clone(null);
    }

    public final void buildWithAttachments() {
        if (this.getState() == 2) {
            this.build();
        }
        if (this.isExpanded()) {
            for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                child.buildWithAttachments();
            }
        }
    }

    @Override
    public void checkChild(OMNode child) {
    }

    public final void setNamespace(OMNamespace namespace) {
        this.setNamespace(namespace, true);
    }

    public final void setLineNumber(int lineNumber) {
    }

    public final int getLineNumber() {
        return 0;
    }

    @Override
    public final CoreElement getContextElement() {
        CoreParentNode parent = this.coreGetParent();
        return parent instanceof CoreElement ? (CoreElement)parent : null;
    }

    public Iterator<OMNode> getDescendants(boolean includeSelf) {
        return this.coreGetNodes(includeSelf ? Axis.DESCENDANTS_OR_SELF : Axis.DESCENDANTS, AxiomChildNode.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }
}

