/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.testing.multiton.Instances;
import org.apache.axiom.ts.soap.SOAPSampleSet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SimpleSOAPSample;
import org.apache.axiom.ts.xml.MessageContent;
import org.apache.axiom.ts.xml.XMLSample;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SOAPSample
extends XMLSample {
    public static final SOAPSample SOAP12_FAULT = new SimpleSOAPSample(SOAPSpec.SOAP12, "test-message/soap12/fault.xml", "soap12/fault.xml");
    private final SOAPSpec spec;

    SOAPSample(SOAPSpec spec, MessageContent content, String name) {
        super(content, name);
        this.spec = spec;
    }

    @Instances
    private static SOAPSample[] instances() {
        ArrayList<SOAPSample> instances = new ArrayList<SOAPSample>();
        for (SOAPSampleSet set : SOAPSample.getInstances(SOAPSampleSet.class)) {
            for (SOAPSpec spec : SOAPSample.getInstances(SOAPSpec.class)) {
                instances.add(set.getMessage(spec));
            }
        }
        return instances.toArray(new SOAPSample[instances.size()]);
    }

    public final SOAPSpec getSOAPSpec() {
        return this.spec;
    }

    public final Element getEnvelope() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            return factory.newDocumentBuilder().parse(this.getInputStream()).getDocumentElement();
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private Element getBody() {
        NodeList children = this.getEnvelope().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getLocalName().equals("Body")) continue;
            return (Element)child;
        }
        throw new Error("SOAP message has no body");
    }

    public final Element getPayload() {
        NodeList children = this.getBody().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public final InputSource getPayloadInputSource() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.getPayload()), new StreamResult(baos));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
        return new InputSource(new ByteArrayInputStream(baos.toByteArray()));
    }
}

