/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.ts.soap.BooleanLiteral;

public abstract class SOAPSpec
extends Multiton {
    public static final SOAPSpec SOAP11 = new SOAPSpec("soap11", "text/xml", "http://schemas.xmlsoap.org/soap/envelope/", new BooleanLiteral[]{BooleanLiteral.ONE, BooleanLiteral.ZERO}, new QName("faultcode"), null, null, new QName("faultstring"), null, null, new QName("faultactor"), new QName("detail"), "http://schemas.xmlsoap.org/soap/actor/next", new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client"), new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"), new String[]{"soap-1.1.xsd"}){

        @Override
        public SOAPSpec getAltSpec() {
            return SOAP12;
        }

        @Override
        public String getCanonicalRepresentation(boolean value) {
            return value ? "1" : "0";
        }
    };
    public static final SOAPSpec SOAP12 = new SOAPSpec("soap12", "application/soap+xml", "http://www.w3.org/2003/05/soap-envelope", new BooleanLiteral[]{BooleanLiteral.TRUE, BooleanLiteral.FALSE, BooleanLiteral.ONE, BooleanLiteral.ZERO}, new QName("http://www.w3.org/2003/05/soap-envelope", "Code"), new QName("http://www.w3.org/2003/05/soap-envelope", "Value"), new QName("http://www.w3.org/2003/05/soap-envelope", "Subcode"), new QName("http://www.w3.org/2003/05/soap-envelope", "Reason"), new QName("http://www.w3.org/2003/05/soap-envelope", "Text"), new QName("http://www.w3.org/2003/05/soap-envelope", "Node"), new QName("http://www.w3.org/2003/05/soap-envelope", "Role"), new QName("http://www.w3.org/2003/05/soap-envelope", "Detail"), "http://www.w3.org/2003/05/soap-envelope/role/next", new QName("http://www.w3.org/2003/05/soap-envelope", "Sender"), new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver"), new String[]{"xml.xsd", "soap-1.2.xsd"}){

        @Override
        public SOAPSpec getAltSpec() {
            return SOAP11;
        }

        @Override
        public String getCanonicalRepresentation(boolean value) {
            return String.valueOf(value);
        }
    };
    private final String name;
    private final String contentType;
    private final String envelopeNamespaceURI;
    private final BooleanLiteral[] booleanLiterals;
    private final QName envelopeQName;
    private final QName headerQName;
    private final QName bodyQName;
    private final QName faultQName;
    private final QName faultCodeQName;
    private final QName faultValueQName;
    private final QName faultSubCodeQName;
    private final QName faultReasonQName;
    private final QName faultTextQName;
    private final QName faultNodeQName;
    private final QName faultRoleQName;
    private final QName faultDetailQName;
    private final String nextRoleURI;
    private final QName senderFaultCode;
    private final QName receiverFaultCode;
    private final String[] schemaResources;
    private Schema schema;

    private SOAPSpec(String name, String contentType, String envelopeNamespaceURI, BooleanLiteral[] booleanLiterals, QName faultCodeQName, QName faultValueQName, QName faultSubCodeQName, QName faultReasonQName, QName faultTextQName, QName faultNodeQName, QName faultRoleQName, QName faultDetailQName, String nextRoleURI, QName senderFaultCode, QName receiverFaultCode, String[] schemaResources) {
        this.name = name;
        this.contentType = contentType;
        this.envelopeNamespaceURI = envelopeNamespaceURI;
        this.booleanLiterals = booleanLiterals;
        this.envelopeQName = new QName(envelopeNamespaceURI, "Envelope");
        this.headerQName = new QName(envelopeNamespaceURI, "Header");
        this.bodyQName = new QName(envelopeNamespaceURI, "Body");
        this.faultQName = new QName(envelopeNamespaceURI, "Fault");
        this.faultCodeQName = faultCodeQName;
        this.faultValueQName = faultValueQName;
        this.faultSubCodeQName = faultSubCodeQName;
        this.faultReasonQName = faultReasonQName;
        this.faultTextQName = faultTextQName;
        this.faultNodeQName = faultNodeQName;
        this.faultRoleQName = faultRoleQName;
        this.faultDetailQName = faultDetailQName;
        this.nextRoleURI = nextRoleURI;
        this.senderFaultCode = senderFaultCode;
        this.receiverFaultCode = receiverFaultCode;
        this.schemaResources = schemaResources;
    }

    public final String getName() {
        return this.name;
    }

    public abstract SOAPSpec getAltSpec();

    public final String getContentType() {
        return this.contentType;
    }

    public final String getEnvelopeNamespaceURI() {
        return this.envelopeNamespaceURI;
    }

    public final QName getEnvelopeQName() {
        return this.envelopeQName;
    }

    public final QName getHeaderQName() {
        return this.headerQName;
    }

    public final QName getBodyQName() {
        return this.bodyQName;
    }

    public final QName getFaultQName() {
        return this.faultQName;
    }

    public final QName getFaultCodeQName() {
        return this.faultCodeQName;
    }

    public final QName getFaultValueQName() {
        return this.faultValueQName;
    }

    public final QName getFaultSubCodeQName() {
        return this.faultSubCodeQName;
    }

    public final QName getFaultReasonQName() {
        return this.faultReasonQName;
    }

    public final QName getFaultTextQName() {
        return this.faultTextQName;
    }

    public final QName getFaultNodeQName() {
        return this.faultNodeQName;
    }

    public final QName getFaultRoleQName() {
        return this.faultRoleQName;
    }

    public final QName getFaultDetailQName() {
        return this.faultDetailQName;
    }

    public final BooleanLiteral[] getBooleanLiterals() {
        return (BooleanLiteral[])this.booleanLiterals.clone();
    }

    private static List getReps(BooleanLiteral[] literals) {
        ArrayList<String> result = new ArrayList<String>(literals.length);
        for (int i = 0; i < literals.length; ++i) {
            result.add(literals[i].getLexicalRepresentation());
        }
        return result;
    }

    public final String[] getInvalidBooleanLiterals() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(SOAPSpec.getReps(this.getAltSpec().booleanLiterals));
        List valid = SOAPSpec.getReps(this.booleanLiterals);
        result.removeAll(valid);
        result.add("invalid");
        if (valid.contains("true")) {
            result.add("TRUE");
        }
        return result.toArray(new String[result.size()]);
    }

    public abstract String getCanonicalRepresentation(boolean var1);

    public final String getNextRoleURI() {
        return this.nextRoleURI;
    }

    public final QName getSenderFaultCode() {
        return this.senderFaultCode;
    }

    public final QName getReceiverFaultCode() {
        return this.receiverFaultCode;
    }

    public final synchronized Schema getSchema() {
        if (this.schema == null) {
            Source[] sources = new Source[this.schemaResources.length];
            for (int i = 0; i < this.schemaResources.length; ++i) {
                sources[i] = new StreamSource(SOAPSpec.class.getResource("xsd/" + this.schemaResources[i]).toString());
            }
            try {
                this.schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(sources);
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }
        return this.schema;
    }
}

