/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.testing.multiton.Instances;
import org.apache.axiom.ts.xml.MessageContent;
import org.apache.axiom.ts.xml.MessageSample;
import org.apache.axiom.ts.xml.XMLSampleProperties;
import org.w3c.dom.Document;

public class XMLSample
extends MessageSample {
    public static final XMLSample SIMPLE = new XMLSample("simple.xml");
    public static final XMLSample LARGE = new XMLSample("large.xml");
    public static final XMLSample ENTITY_REFERENCE_NESTED = new XMLSample("entity-reference-nested.xml");
    public static final XMLSample DTD_FULL = new XMLSample("dtd-full.xml");
    private static final DocumentBuilder documentBuilder;
    private final String name;
    private XMLSampleProperties properties;

    protected XMLSample(MessageContent content, String name) {
        super(content);
        this.name = name;
    }

    private XMLSample(String relativeResourceName) {
        this(MessageContent.fromClasspath(XMLSample.class, relativeResourceName), relativeResourceName.substring(relativeResourceName.lastIndexOf(47) + 1));
    }

    public final String getName() {
        return this.name;
    }

    private synchronized XMLSampleProperties getProperties() {
        if (this.properties == null) {
            this.properties = new XMLSampleProperties(this);
        }
        return this.properties;
    }

    public final String getEncoding() {
        return this.getProperties().getEncoding();
    }

    public final boolean hasDTD() {
        return this.getProperties().hasDTD();
    }

    public final boolean hasExternalSubset() {
        return this.getProperties().hasExternalSubset();
    }

    public final boolean hasInternalSubset() {
        return this.getProperties().hasInternalSubset();
    }

    public final boolean hasEntityReferences() {
        return this.getProperties().hasEntityReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Document getDocument() {
        Document document;
        InputStream in = this.getInputStream();
        try {
            document = documentBuilder.parse(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }
        in.close();
        return document;
    }

    @Instances
    private static XMLSample[] instances() throws IOException {
        String name;
        BufferedReader in = new BufferedReader(new InputStreamReader(XMLSample.class.getResourceAsStream("bulk/filelist")));
        ArrayList<XMLSample> result = new ArrayList<XMLSample>(10);
        while ((name = in.readLine()) != null) {
            result.add(new XMLSample("bulk/" + name));
        }
        in.close();
        return result.toArray(new XMLSample[result.size()]);
    }

    @Override
    public final String getContentType() {
        return this.getMediaType() + "; charset=\"" + this.getEncoding() + "\"";
    }

    protected String getMediaType() {
        return "application/xml";
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new Error(ex);
        }
    }
}

