/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.policy.AssertionState;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.Header;
import org.apache.wss4j.policy.model.RequiredParts;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.securityEvent.RequiredPartSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class RequiredPartsAssertionState
extends AssertionState
implements Assertable {
    private final Map<Header, Boolean> headers = new HashMap<Header, Boolean>();

    public RequiredPartsAssertionState(AbstractSecurityAssertion assertion, boolean asserted) {
        super((Assertion)assertion, asserted);
        RequiredParts requiredParts = (RequiredParts)assertion;
        for (int i = 0; i < requiredParts.getHeaders().size(); ++i) {
            Header header = (Header)requiredParts.getHeaders().get(i);
            this.headers.put(header, Boolean.FALSE);
        }
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.RequiredPart};
    }

    @Override
    public boolean assertEvent(SecurityEvent securityEvent) throws WSSPolicyException {
        RequiredPartSecurityEvent requiredPartSecurityEvent = (RequiredPartSecurityEvent)securityEvent;
        for (Map.Entry<Header, Boolean> next : this.headers.entrySet()) {
            Header header = next.getKey();
            QName headerQName = new QName(header.getNamespace(), header.getName() == null ? "" : header.getName());
            LinkedList<QName> header11Path = new LinkedList<QName>();
            header11Path.addAll(WSSConstants.SOAP_11_HEADER_PATH);
            header11Path.add(headerQName);
            if (!WSSUtils.pathMatches(header11Path, (List)requiredPartSecurityEvent.getElementPath(), (boolean)true, (header.getName() == null ? 1 : 0) != 0)) continue;
            next.setValue(Boolean.TRUE);
            break;
        }
        return true;
    }

    @Override
    public boolean isAsserted() {
        this.clearErrorMessage();
        for (Map.Entry<Header, Boolean> next : this.headers.entrySet()) {
            if (!Boolean.FALSE.equals(next.getValue())) continue;
            this.setErrorMessage("Element " + next.getKey().toString() + " must be present");
            return false;
        }
        return true;
    }
}

