/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.java2d.CustomFontMetricsMapper;
import org.apache.fop.render.java2d.SystemFontMetricsMapper;

public class FontSetup {
    protected static Log log = LogFactory.getLog((Class)FontSetup.class);
    private static final int LAST_PREDEFINED_FONT_NUMBER = 14;
    private static final Set HARDCODED_FONT_NAMES = new HashSet();

    public static void setup(FontInfo fontInfo, List configuredFontList, FontResolver resolver, Graphics2D graphics) {
        int normal = 0;
        int bold = 1;
        int italic = 2;
        int bolditalic = 3;
        SystemFontMetricsMapper metric = new SystemFontMetricsMapper("SansSerif", normal, graphics);
        fontInfo.addMetrics("F1", metric);
        metric = new SystemFontMetricsMapper("SansSerif", italic, graphics);
        fontInfo.addMetrics("F2", metric);
        metric = new SystemFontMetricsMapper("SansSerif", bold, graphics);
        fontInfo.addMetrics("F3", metric);
        metric = new SystemFontMetricsMapper("SansSerif", bolditalic, graphics);
        fontInfo.addMetrics("F4", metric);
        metric = new SystemFontMetricsMapper("Serif", normal, graphics);
        fontInfo.addMetrics("F5", metric);
        metric = new SystemFontMetricsMapper("Serif", italic, graphics);
        fontInfo.addMetrics("F6", metric);
        metric = new SystemFontMetricsMapper("Serif", bold, graphics);
        fontInfo.addMetrics("F7", metric);
        metric = new SystemFontMetricsMapper("Serif", bolditalic, graphics);
        fontInfo.addMetrics("F8", metric);
        metric = new SystemFontMetricsMapper("MonoSpaced", normal, graphics);
        fontInfo.addMetrics("F9", metric);
        metric = new SystemFontMetricsMapper("MonoSpaced", italic, graphics);
        fontInfo.addMetrics("F10", metric);
        metric = new SystemFontMetricsMapper("MonoSpaced", bold, graphics);
        fontInfo.addMetrics("F11", metric);
        metric = new SystemFontMetricsMapper("MonoSpaced", bolditalic, graphics);
        fontInfo.addMetrics("F12", metric);
        metric = new SystemFontMetricsMapper("Serif", normal, graphics);
        fontInfo.addMetrics("F13", metric);
        fontInfo.addMetrics("F14", metric);
        fontInfo.addFontProperties("F5", "any", "normal", 400);
        fontInfo.addFontProperties("F6", "any", "italic", 400);
        fontInfo.addFontProperties("F6", "any", "oblique", 400);
        fontInfo.addFontProperties("F7", "any", "normal", 700);
        fontInfo.addFontProperties("F8", "any", "italic", 700);
        fontInfo.addFontProperties("F8", "any", "oblique", 700);
        fontInfo.addFontProperties("F1", "sans-serif", "normal", 400);
        fontInfo.addFontProperties("F2", "sans-serif", "oblique", 400);
        fontInfo.addFontProperties("F2", "sans-serif", "italic", 400);
        fontInfo.addFontProperties("F3", "sans-serif", "normal", 700);
        fontInfo.addFontProperties("F4", "sans-serif", "oblique", 700);
        fontInfo.addFontProperties("F4", "sans-serif", "italic", 700);
        fontInfo.addFontProperties("F5", "serif", "normal", 400);
        fontInfo.addFontProperties("F6", "serif", "oblique", 400);
        fontInfo.addFontProperties("F6", "serif", "italic", 400);
        fontInfo.addFontProperties("F7", "serif", "normal", 700);
        fontInfo.addFontProperties("F8", "serif", "oblique", 700);
        fontInfo.addFontProperties("F8", "serif", "italic", 700);
        fontInfo.addFontProperties("F9", "monospace", "normal", 400);
        fontInfo.addFontProperties("F10", "monospace", "oblique", 400);
        fontInfo.addFontProperties("F10", "monospace", "italic", 400);
        fontInfo.addFontProperties("F11", "monospace", "normal", 700);
        fontInfo.addFontProperties("F12", "monospace", "oblique", 700);
        fontInfo.addFontProperties("F12", "monospace", "italic", 700);
        fontInfo.addFontProperties("F1", "Helvetica", "normal", 400);
        fontInfo.addFontProperties("F2", "Helvetica", "oblique", 400);
        fontInfo.addFontProperties("F2", "Helvetica", "italic", 400);
        fontInfo.addFontProperties("F3", "Helvetica", "normal", 700);
        fontInfo.addFontProperties("F4", "Helvetica", "oblique", 700);
        fontInfo.addFontProperties("F4", "Helvetica", "italic", 700);
        fontInfo.addFontProperties("F5", "Times", "normal", 400);
        fontInfo.addFontProperties("F6", "Times", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times", "italic", 400);
        fontInfo.addFontProperties("F7", "Times", "normal", 700);
        fontInfo.addFontProperties("F8", "Times", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times", "italic", 700);
        fontInfo.addFontProperties("F9", "Courier", "normal", 400);
        fontInfo.addFontProperties("F10", "Courier", "oblique", 400);
        fontInfo.addFontProperties("F10", "Courier", "italic", 400);
        fontInfo.addFontProperties("F11", "Courier", "normal", 700);
        fontInfo.addFontProperties("F12", "Courier", "oblique", 700);
        fontInfo.addFontProperties("F12", "Courier", "italic", 700);
        fontInfo.addFontProperties("F13", "Symbol", "normal", 400);
        fontInfo.addFontProperties("F14", "ZapfDingbats", "normal", 400);
        fontInfo.addFontProperties("F5", "Times-Roman", "normal", 400);
        fontInfo.addFontProperties("F6", "Times-Roman", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times-Roman", "italic", 400);
        fontInfo.addFontProperties("F7", "Times-Roman", "normal", 700);
        fontInfo.addFontProperties("F8", "Times-Roman", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times-Roman", "italic", 700);
        fontInfo.addFontProperties("F5", "Times Roman", "normal", 400);
        fontInfo.addFontProperties("F6", "Times Roman", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times Roman", "italic", 400);
        fontInfo.addFontProperties("F7", "Times Roman", "normal", 700);
        fontInfo.addFontProperties("F8", "Times Roman", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times Roman", "italic", 700);
        fontInfo.addFontProperties("F9", "Computer-Modern-Typewriter", "normal", 400);
        int lastNum = FontSetup.configureInstalledAWTFonts(fontInfo, graphics, 15);
        FontSetup.addConfiguredFonts(fontInfo, configuredFontList, resolver, lastNum++);
    }

    private static int configureInstalledAWTFonts(FontInfo fontInfo, Graphics2D graphics, int startNumber) {
        int num = startNumber;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = env.getAllFonts();
        for (int i = 0; i < fonts.length; ++i) {
            Font f = fonts[i];
            if (HARDCODED_FONT_NAMES.contains(f.getName())) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("AWT Font: " + f.getFontName() + ", family: " + f.getFamily() + ", PS: " + f.getPSName() + ", Name: " + f.getName() + ", Angle: " + f.getItalicAngle() + ", Style: " + f.getStyle()));
            }
            String searchName = FontUtil.stripWhiteSpace(f.getName()).toLowerCase();
            String guessedStyle = FontUtil.guessStyle(searchName);
            int guessedWeight = FontUtil.guessWeight(searchName);
            String fontKey = "F" + ++num;
            int style = FontSetup.convertToAWTFontStyle(guessedStyle, guessedWeight);
            FontSetup.addFontMetricsMapper(fontInfo, f.getName(), fontKey, graphics, style);
            FontSetup.addFontTriplet(fontInfo, f.getName(), "normal", 400, fontKey);
            if (f.getName().equals(f.getFamily())) continue;
            FontSetup.addFontTriplet(fontInfo, f.getFamily(), guessedStyle, guessedWeight, fontKey);
        }
        return num;
    }

    private static void addConfiguredFonts(FontInfo fontInfo, List fontList, FontResolver resolver, int num) {
        if (fontList == null || fontList.size() < 1) {
            log.debug((Object)"No user configured fonts found.");
            return;
        }
        if (resolver == null) {
            resolver = org.apache.fop.fonts.FontSetup.createMinimalFontResolver();
        }
        String internalName = null;
        for (int i = 0; i < fontList.size(); ++i) {
            EmbedFontInfo configFontInfo = (EmbedFontInfo)fontList.get(i);
            String fontFile = configFontInfo.getEmbedFile();
            internalName = "F" + num;
            ++num;
            try {
                Typeface fontMetrics;
                CustomFontMetricsMapper font = null;
                String metricsUrl = configFontInfo.getMetricsFile();
                if (metricsUrl != null) {
                    fontMetrics = new LazyFont(configFontInfo, resolver);
                    Source fontSource = resolver.resolve(configFontInfo.getEmbedFile());
                    font = new CustomFontMetricsMapper((LazyFont)fontMetrics, fontSource);
                } else {
                    fontMetrics = FontLoader.loadFont(fontFile, resolver);
                    font = new CustomFontMetricsMapper((CustomFont)fontMetrics);
                }
                fontInfo.addMetrics(internalName, font);
                List triplets = configFontInfo.getFontTriplets();
                for (int c = 0; c < triplets.size(); ++c) {
                    FontTriplet triplet = (FontTriplet)triplets.get(c);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Registering: " + triplet + " under " + internalName));
                    }
                    fontInfo.addFontProperties(internalName, triplet);
                }
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("Unable to load custom font from file '" + fontFile + "'"), (Throwable)e);
            }
        }
    }

    private static void addFontTriplet(FontInfo fontInfo, String fontName, String fontStyle, int fontWeight, String fontKey) {
        FontTriplet triplet = FontInfo.createFontKey(fontName, fontStyle, fontWeight);
        fontInfo.addFontProperties(fontKey, triplet);
    }

    private static void addFontMetricsMapper(FontInfo fontInfo, String family, String fontKey, Graphics2D graphics, int style) {
        SystemFontMetricsMapper metric = new SystemFontMetricsMapper(family, style, graphics);
        fontInfo.addMetrics(fontKey, metric);
    }

    private static int convertToAWTFontStyle(String fontStyle, int fontWeight) {
        int style = 0;
        if (fontWeight >= 700) {
            style |= 1;
        }
        if (!"normal".equals(fontStyle)) {
            style |= 2;
        }
        return style;
    }

    static {
        HARDCODED_FONT_NAMES.add("any");
        HARDCODED_FONT_NAMES.add("sans-serif");
        HARDCODED_FONT_NAMES.add("serif");
        HARDCODED_FONT_NAMES.add("monospace");
        HARDCODED_FONT_NAMES.add("Helvetica");
        HARDCODED_FONT_NAMES.add("Times");
        HARDCODED_FONT_NAMES.add("Courier");
        HARDCODED_FONT_NAMES.add("Symbol");
        HARDCODED_FONT_NAMES.add("ZapfDingbats");
        HARDCODED_FONT_NAMES.add("Times Roman");
        HARDCODED_FONT_NAMES.add("Times-Roman");
        HARDCODED_FONT_NAMES.add("Computer-Modern-Typewriter");
    }
}

