/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumPeerTestBase
extends ZKTestCase
implements Watcher {
    protected static final Logger LOG = LoggerFactory.getLogger(QuorumPeerTestBase.class);

    public void process(WatchedEvent event) {
    }

    public static class MainThread
    implements Runnable {
        final File confFile;
        volatile TestQPMain main;
        Thread currentThread;

        public MainThread(int myid, int clientPort, String quorumCfgSection) throws IOException {
            File tmpDir = ClientBase.createTmpDir();
            this.confFile = new File(tmpDir, "zoo.cfg");
            FileWriter fwriter = new FileWriter(this.confFile);
            fwriter.write("tickTime=4000\n");
            fwriter.write("initLimit=10\n");
            fwriter.write("syncLimit=5\n");
            File dataDir = new File(tmpDir, "data");
            if (!dataDir.mkdir()) {
                throw new IOException("Unable to mkdir " + dataDir);
            }
            String dir = dataDir.toString();
            String osname = System.getProperty("os.name");
            if (osname.toLowerCase().contains("windows")) {
                dir = dir.replace('\\', '/');
            }
            fwriter.write("dataDir=" + dir + "\n");
            fwriter.write("clientPort=" + clientPort + "\n");
            fwriter.write(quorumCfgSection + "\n");
            fwriter.flush();
            fwriter.close();
            File myidFile = new File(dataDir, "myid");
            fwriter = new FileWriter(myidFile);
            fwriter.write(Integer.toString(myid));
            fwriter.flush();
            fwriter.close();
        }

        public synchronized void start() {
            this.main = new TestQPMain();
            this.currentThread = new Thread(this);
            this.currentThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String[] args = new String[]{this.confFile.toString()};
            try {
                this.main.initializeAndRun(args);
            }
            catch (Exception e) {
                LOG.error("unexpected exception in run", (Throwable)e);
            }
            finally {
                this.currentThread = null;
            }
        }

        public void shutdown() throws InterruptedException {
            Thread t = this.currentThread;
            if (t != null && t.isAlive()) {
                this.main.shutdown();
                t.join(500L);
            }
        }

        public void join(long timeout) throws InterruptedException {
            Thread t = this.currentThread;
            if (t != null) {
                t.join(timeout);
            }
        }

        public boolean isAlive() {
            Thread t = this.currentThread;
            return t != null && t.isAlive();
        }
    }

    public static class TestQPMain
    extends QuorumPeerMain {
        public void shutdown() {
            if (this.quorumPeer != null) {
                QuorumBase.shutdown(this.quorumPeer);
            }
        }
    }
}

