/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.ByteBufferOutputStream;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.LearnerInfo;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.StateSummary;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.Assert;
import org.junit.Test;

public class Zab1_0Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaderInConnectingFollowers() throws Exception {
        File tmpDir = File.createTempFile("test", "dir");
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        try {
            QuorumPeer peer = this.createQuorumPeer(tmpDir);
            peer.leader = leader = this.createLeader(tmpDir, peer);
            peer.setAcceptedEpoch(5L);
            FollowerMockThread f1 = new FollowerMockThread(1L, leader, true);
            FollowerMockThread f2 = new FollowerMockThread(2L, leader, true);
            f1.start();
            f2.start();
            f1.join(leader.self.getInitLimit() * leader.self.getTickTime() + 5000);
            f2.join(leader.self.getInitLimit() * leader.self.getTickTime() + 5000);
            try {
                long epoch = leader.getEpochToPropose(leader.self.getId(), leader.self.getAcceptedEpoch());
                Assert.assertEquals((String)"leader got wrong epoch from getEpochToPropose", (long)6L, (long)epoch);
            }
            catch (Exception e) {
                Assert.fail((String)"leader timed out in getEpochToPropose");
            }
        }
        finally {
            this.recursiveDelete(tmpDir);
            if (leader != null) {
                leader.shutdown("end of test");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaderInElectingFollowers() throws Exception {
        File tmpDir = File.createTempFile("test", "dir");
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        try {
            QuorumPeer peer = this.createQuorumPeer(tmpDir);
            peer.leader = leader = this.createLeader(tmpDir, peer);
            FollowerMockThread f1 = new FollowerMockThread(1L, leader, false);
            FollowerMockThread f2 = new FollowerMockThread(2L, leader, false);
            leader.readyToStart = true;
            leader.leaderStateSummary = new StateSummary(leader.self.getCurrentEpoch(), leader.zk.getLastProcessedZxid());
            f1.start();
            f2.start();
            f1.join(leader.self.getInitLimit() * leader.self.getTickTime() + 5000);
            f2.join(leader.self.getInitLimit() * leader.self.getTickTime() + 5000);
            Assert.assertTrue((String)(f1.msg + " without waiting for leader"), (f1.msg == null ? 1 : 0) != 0);
            Assert.assertTrue((String)(f2.msg + " without waiting for leader"), (f2.msg == null ? 1 : 0) != 0);
        }
        finally {
            this.recursiveDelete(tmpDir);
            if (leader != null) {
                leader.shutdown("end of test");
            }
        }
    }

    static Socket[] getSocketPair() throws IOException {
        ServerSocket ss = new ServerSocket();
        ss.bind(null);
        InetSocketAddress endPoint = (InetSocketAddress)ss.getLocalSocketAddress();
        Socket s = new Socket(endPoint.getAddress(), endPoint.getPort());
        return new Socket[]{s, ss.accept()};
    }

    static void readPacketSkippingPing(InputArchive ia, QuorumPacket qp) throws IOException {
        do {
            ia.readRecord((Record)qp, null);
        } while (qp.getType() == 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeaderConversation(LeaderConversation conversation) throws Exception {
        Socket[] pair = Zab1_0Test.getSocketPair();
        Socket leaderSocket = pair[0];
        Socket followerSocket = pair[1];
        File tmpDir = File.createTempFile("test", "dir");
        tmpDir.delete();
        tmpDir.mkdir();
        Thread leadThread = null;
        Leader leader = null;
        try {
            QuorumPeer peer = this.createQuorumPeer(tmpDir);
            peer.leader = leader = this.createLeader(tmpDir, peer);
            leadThread = new LeadThread(leader);
            leadThread.start();
            while (!leader.readyToStart) {
                Thread.sleep(20L);
            }
            LearnerHandler lh = new LearnerHandler(leaderSocket, leader);
            lh.start();
            leaderSocket.setSoTimeout(4000);
            BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)followerSocket.getInputStream());
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)followerSocket.getOutputStream());
            conversation.converseWithLeader((InputArchive)ia, (OutputArchive)oa, leader);
        }
        finally {
            this.recursiveDelete(tmpDir);
            if (leader != null) {
                leader.shutdown("end of test");
            }
            if (leadThread != null) {
                leadThread.interrupt();
                leadThread.join();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFollowerConversation(FollowerConversation conversation) throws Exception {
        File tmpDir = File.createTempFile("test", "dir");
        tmpDir.delete();
        tmpDir.mkdir();
        Thread followerThread = null;
        ConversableFollower follower = null;
        QuorumPeer peer = null;
        try {
            peer = this.createQuorumPeer(tmpDir);
            follower = this.createFollower(tmpDir, peer);
            peer.follower = follower;
            ServerSocket ss = new ServerSocket();
            ss.bind(null);
            follower.setLeaderSocketAddress((InetSocketAddress)ss.getLocalSocketAddress());
            final ConversableFollower followerForThread = follower;
            followerThread = new Thread(){

                public void run() {
                    try {
                        followerForThread.followLeader();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            followerThread.start();
            Socket leaderSocket = ss.accept();
            BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)leaderSocket.getInputStream());
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)leaderSocket.getOutputStream());
            conversation.converseWithFollower((InputArchive)ia, (OutputArchive)oa, follower);
        }
        finally {
            if (follower != null) {
                follower.shutdown();
            }
            if (followerThread != null) {
                followerThread.interrupt();
                followerThread.join();
            }
            if (peer != null) {
                peer.shutdown();
            }
            this.recursiveDelete(tmpDir);
        }
    }

    @Test
    public void testNormalFollowerRun() throws Exception {
        this.testFollowerConversation(new FollowerConversation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void converseWithFollower(InputArchive ia, OutputArchive oa, Follower f) throws Exception {
                File tmpDir = File.createTempFile("test", "dir");
                tmpDir.delete();
                tmpDir.mkdir();
                File logDir = f.fzk.getTxnLogFactory().getDataDir().getParentFile();
                File snapDir = f.fzk.getTxnLogFactory().getSnapDir().getParentFile();
                try {
                    Assert.assertEquals((long)0L, (long)f.self.getAcceptedEpoch());
                    Assert.assertEquals((long)0L, (long)f.self.getCurrentEpoch());
                    ZKDatabase zkDb = new ZKDatabase(new FileTxnSnapLog(tmpDir, tmpDir));
                    long firstZxid = ZxidUtils.makeZxid((long)1L, (long)1L);
                    zkDb.processTxn(new TxnHeader(13L, 1313, firstZxid, 33L, 1), (Record)new CreateTxn("/foo", "data1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 1));
                    Stat stat = new Stat();
                    Assert.assertEquals((Object)"data1", (Object)new String(zkDb.getData("/foo", stat, null)));
                    QuorumPacket qp = new QuorumPacket();
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)11L, (long)qp.getType());
                    Assert.assertEquals((long)qp.getZxid(), (long)0L);
                    LearnerInfo learnInfo = new LearnerInfo();
                    ByteBufferInputStream.byteBuffer2Record((ByteBuffer)ByteBuffer.wrap(qp.getData()), (Record)learnInfo);
                    Assert.assertEquals((long)learnInfo.getProtocolVersion(), (long)65536L);
                    Assert.assertEquals((long)learnInfo.getServerid(), (long)0L);
                    qp.setType(17);
                    qp.setZxid(ZxidUtils.makeZxid((long)1L, (long)0L));
                    byte[] protoBytes = new byte[4];
                    ByteBuffer.wrap(protoBytes).putInt(65536);
                    qp.setData(protoBytes);
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)18L, (long)qp.getType());
                    Assert.assertEquals((long)0L, (long)qp.getZxid());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)0L, (long)0L), (long)ByteBuffer.wrap(qp.getData()).getInt());
                    Assert.assertEquals((long)1L, (long)f.self.getAcceptedEpoch());
                    Assert.assertEquals((long)0L, (long)f.self.getCurrentEpoch());
                    qp.setType(15);
                    qp.setData(new byte[0]);
                    qp.setZxid(zkDb.getDataTreeLastProcessedZxid());
                    oa.writeRecord((Record)qp, null);
                    zkDb.serializeSnapshot(oa);
                    oa.writeString("BenWasHere", null);
                    qp.setType(10);
                    qp.setZxid(ZxidUtils.makeZxid((long)1L, (long)0L));
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)3L, (long)qp.getType());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                    Assert.assertEquals((long)1L, (long)f.self.getAcceptedEpoch());
                    Assert.assertEquals((long)1L, (long)f.self.getCurrentEpoch());
                    Assert.assertEquals((long)firstZxid, (long)f.fzk.getLastProcessedZxid());
                    ZKDatabase zkDb2 = new ZKDatabase(new FileTxnSnapLog(logDir, snapDir));
                    long lastZxid = zkDb2.loadDataBase();
                    Assert.assertEquals((Object)"data1", (Object)new String(zkDb2.getData("/foo", stat, null)));
                    Assert.assertEquals((long)firstZxid, (long)lastZxid);
                    long proposalZxid = ZxidUtils.makeZxid((long)1L, (long)1000L);
                    this.proposeSetData(qp, proposalZxid, "data2", 2);
                    oa.writeRecord((Record)qp, null);
                    class TrackerWatcher
                    implements Watcher {
                        boolean changed;

                        TrackerWatcher() {
                        }

                        synchronized void waitForChange() throws InterruptedException {
                            while (!this.changed) {
                                this.wait();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void process(WatchedEvent event) {
                            if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                                TrackerWatcher trackerWatcher = this;
                                synchronized (trackerWatcher) {
                                    this.changed = true;
                                    this.notifyAll();
                                }
                            }
                        }

                        public synchronized boolean changed() {
                            return this.changed;
                        }
                    }
                    TrackerWatcher watcher = new TrackerWatcher();
                    Assert.assertEquals((Object)"data1", (Object)new String(f.fzk.getZKDatabase().getData("/foo", stat, (Watcher)watcher)));
                    qp.setType(4);
                    qp.setZxid(proposalZxid);
                    oa.writeRecord((Record)qp, null);
                    qp.setType(12);
                    qp.setZxid(0L);
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)3L, (long)qp.getType());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)3L, (long)qp.getType());
                    Assert.assertEquals((long)proposalZxid, (long)qp.getZxid());
                    watcher.waitForChange();
                    Assert.assertEquals((Object)"data2", (Object)new String(f.fzk.getZKDatabase().getData("/foo", stat, null)));
                    zkDb2 = new ZKDatabase(new FileTxnSnapLog(logDir, snapDir));
                    lastZxid = zkDb2.loadDataBase();
                    Assert.assertEquals((Object)"data2", (Object)new String(zkDb2.getData("/foo", stat, null)));
                    Assert.assertEquals((long)proposalZxid, (long)lastZxid);
                }
                finally {
                    Zab1_0Test.this.recursiveDelete(tmpDir);
                }
            }

            private void proposeSetData(QuorumPacket qp, long zxid, String data, int version) throws IOException {
                qp.setType(2);
                qp.setZxid(zxid);
                TxnHeader hdr = new TxnHeader(4L, 1414, qp.getZxid(), 55L, 5);
                SetDataTxn sdt = new SetDataTxn("/foo", data.getBytes(), version);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
                boa.writeRecord((Record)hdr, null);
                boa.writeRecord((Record)sdt, null);
                qp.setData(baos.toByteArray());
            }
        });
    }

    @Test
    public void testNormalRun() throws Exception {
        this.testLeaderConversation(new LeaderConversation(){

            public void converseWithLeader(InputArchive ia, OutputArchive oa, Leader l) throws IOException {
                Assert.assertEquals((long)0L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)0L, (long)l.self.getCurrentEpoch());
                LearnerInfo li = new LearnerInfo(1L, 65536);
                byte[] liBytes = new byte[12];
                ByteBufferOutputStream.record2ByteBuffer((Record)li, (ByteBuffer)ByteBuffer.wrap(liBytes));
                QuorumPacket qp = new QuorumPacket(11, 0L, liBytes, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)17L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)ByteBuffer.wrap(qp.getData()).getInt(), (long)65536L);
                Assert.assertEquals((long)1L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)0L, (long)l.self.getCurrentEpoch());
                qp = new QuorumPacket(18, 0L, new byte[4], null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)15L, (long)qp.getType());
                Zab1_0Test.this.deserializeSnapshot(ia);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)10L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)1L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)1L, (long)l.self.getCurrentEpoch());
                qp = new QuorumPacket(3, qp.getZxid(), null, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)10L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)1L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)1L, (long)l.self.getCurrentEpoch());
                qp = new QuorumPacket(3, qp.getZxid(), null, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)12L, (long)qp.getType());
            }
        });
    }

    private void deserializeSnapshot(InputArchive ia) throws IOException {
        ZKDatabase zkdb = new ZKDatabase(null);
        zkdb.deserializeSnapshot(ia);
        String signature = ia.readString("signature");
        Assert.assertEquals((Object)"BenWasHere", (Object)signature);
    }

    @Test
    public void testLeaderBehind() throws Exception {
        this.testLeaderConversation(new LeaderConversation(){

            public void converseWithLeader(InputArchive ia, OutputArchive oa, Leader l) throws IOException {
                LearnerInfo li = new LearnerInfo(1L, 65536);
                byte[] liBytes = new byte[12];
                ByteBufferOutputStream.record2ByteBuffer((Record)li, (ByteBuffer)ByteBuffer.wrap(liBytes));
                QuorumPacket qp = new QuorumPacket(11, ZxidUtils.makeZxid((long)20L, (long)0L), liBytes, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)17L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)21L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)ByteBuffer.wrap(qp.getData()).getInt(), (long)65536L);
                qp = new QuorumPacket(18, 0L, new byte[4], null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)15L, (long)qp.getType());
                Zab1_0Test.this.deserializeSnapshot(ia);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)10L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)21L, (long)0L), (long)qp.getZxid());
                qp = new QuorumPacket(3, qp.getZxid(), null, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)10L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)21L, (long)0L), (long)qp.getZxid());
                qp = new QuorumPacket(3, qp.getZxid(), null, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)12L, (long)qp.getType());
            }
        });
    }

    @Test
    public void testAbandonBeforeACKEpoch() throws Exception {
        this.testLeaderConversation(new LeaderConversation(){

            public void converseWithLeader(InputArchive ia, OutputArchive oa, Leader l) throws IOException, InterruptedException {
                LearnerInfo li = new LearnerInfo(1L, 65536);
                byte[] liBytes = new byte[12];
                ByteBufferOutputStream.record2ByteBuffer((Record)li, (ByteBuffer)ByteBuffer.wrap(liBytes));
                QuorumPacket qp = new QuorumPacket(11, 0L, liBytes, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)17L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)ByteBuffer.wrap(qp.getData()).getInt(), (long)65536L);
                Thread.sleep(l.self.getInitLimit() * l.self.getTickTime() + 5000);
                Assert.assertEquals((long)0L, (long)l.self.getCurrentEpoch());
            }
        });
    }

    private void recursiveDelete(File file) {
        if (file.isFile()) {
            file.delete();
        } else {
            for (File c : file.listFiles()) {
                this.recursiveDelete(c);
            }
            file.delete();
        }
    }

    private Leader createLeader(File tmpDir, QuorumPeer peer) throws IOException, NoSuchFieldException, IllegalAccessException {
        FileTxnSnapLog logFactory = new FileTxnSnapLog(tmpDir, tmpDir);
        peer.setTxnFactory(logFactory);
        Field addrField = peer.getClass().getDeclaredField("myQuorumAddr");
        addrField.setAccessible(true);
        addrField.set(peer, new InetSocketAddress(33556));
        ZKDatabase zkDb = new ZKDatabase(logFactory);
        LeaderZooKeeperServer zk = new LeaderZooKeeperServer(logFactory, peer, (ZooKeeperServer.DataTreeBuilder)new ZooKeeperServer.BasicDataTreeBuilder(), zkDb);
        return new Leader(peer, zk);
    }

    private ConversableFollower createFollower(File tmpDir, QuorumPeer peer) throws IOException {
        FileTxnSnapLog logFactory = new FileTxnSnapLog(tmpDir, tmpDir);
        peer.setTxnFactory(logFactory);
        ZKDatabase zkDb = new ZKDatabase(logFactory);
        FollowerZooKeeperServer zk = new FollowerZooKeeperServer(logFactory, peer, (ZooKeeperServer.DataTreeBuilder)new ZooKeeperServer.BasicDataTreeBuilder(), zkDb);
        peer.setZKDatabase(zkDb);
        return new ConversableFollower(peer, zk);
    }

    private QuorumPeer createQuorumPeer(File tmpDir) throws IOException, FileNotFoundException {
        QuorumPeer peer = new QuorumPeer();
        peer.syncLimit = 2;
        peer.initLimit = 2;
        peer.tickTime = 2000;
        peer.quorumPeers = new HashMap();
        peer.quorumPeers.put(1L, new QuorumPeer.QuorumServer(0L, new InetSocketAddress(33221)));
        peer.quorumPeers.put(1L, new QuorumPeer.QuorumServer(1L, new InetSocketAddress(33223)));
        peer.setQuorumVerifier((QuorumVerifier)new QuorumMaj(3));
        peer.setCnxnFactory((ServerCnxnFactory)new NullServerCnxnFactory());
        File version2 = new File(tmpDir, "version-2");
        version2.mkdir();
        new FileOutputStream(new File(version2, "currentEpoch")).write("0\n".getBytes());
        new FileOutputStream(new File(version2, "acceptedEpoch")).write("0\n".getBytes());
        return peer;
    }

    static class ConversableFollower
    extends Follower {
        InetSocketAddress leaderAddr;

        ConversableFollower(QuorumPeer self, FollowerZooKeeperServer zk) {
            super(self, zk);
        }

        public void setLeaderSocketAddress(InetSocketAddress addr) {
            this.leaderAddr = addr;
        }

        protected InetSocketAddress findLeader() {
            return this.leaderAddr;
        }
    }

    public static interface FollowerConversation {
        public void converseWithFollower(InputArchive var1, OutputArchive var2, Follower var3) throws Exception;
    }

    public static interface LeaderConversation {
        public void converseWithLeader(InputArchive var1, OutputArchive var2, Leader var3) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullServerCnxnFactory
    extends ServerCnxnFactory {
        private NullServerCnxnFactory() {
        }

        public void startup(ZooKeeperServer zkServer) throws IOException, InterruptedException {
        }

        public void start() {
        }

        public void shutdown() {
        }

        public void setMaxClientCnxnsPerHost(int max) {
        }

        public void join() throws InterruptedException {
        }

        public int getMaxClientCnxnsPerHost() {
            return 0;
        }

        public int getLocalPort() {
            return 0;
        }

        public InetSocketAddress getLocalAddress() {
            return null;
        }

        public Iterable<ServerCnxn> getConnections() {
            return null;
        }

        public void configure(InetSocketAddress addr, int maxClientCnxns) throws IOException {
        }

        public void closeSession(long sessionId) {
        }

        public void closeAll() {
        }
    }

    public static final class FollowerMockThread
    extends Thread {
        private final Leader leader;
        private final long followerSid;
        public long epoch = -1L;
        public String msg = null;
        private boolean onlyGetEpochToPropose;

        private FollowerMockThread(long followerSid, Leader leader, boolean onlyGetEpochToPropose) {
            this.leader = leader;
            this.followerSid = followerSid;
            this.onlyGetEpochToPropose = onlyGetEpochToPropose;
        }

        public void run() {
            if (this.onlyGetEpochToPropose) {
                try {
                    this.epoch = this.leader.getEpochToPropose(this.followerSid, 0L);
                }
                catch (Exception e) {}
            } else {
                try {
                    this.leader.waitForEpochAck(this.followerSid, new StateSummary(0L, 0L));
                    this.msg = "FollowerMockThread (id = " + this.followerSid + ")  returned from waitForEpochAck";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static final class LeadThread
    extends Thread {
        private final Leader leader;

        private LeadThread(Leader leader) {
            this.leader = leader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.leader.lead();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.leader.shutdown("lead ended");
            }
        }
    }
}

