/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import junit.framework.TestCase;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXEnv {
    protected static final Logger LOG = LoggerFactory.getLogger(JMXEnv.class);
    private static JMXConnectorServer cs;
    private static JMXConnector cc;

    public static void setUp() throws IOException {
        MBeanServer mbs = MBeanRegistry.getInstance().getPlatformMBeanServer();
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://");
        cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbs);
        cs.start();
        JMXServiceURL addr = cs.getAddress();
        cc = JMXConnectorFactory.connect(addr);
    }

    public static void tearDown() {
        try {
            cc.close();
        }
        catch (IOException e) {
            LOG.warn("Unexpected, ignoring", (Throwable)e);
        }
        cc = null;
        try {
            cs.stop();
        }
        catch (IOException e) {
            LOG.warn("Unexpected, ignoring", (Throwable)e);
        }
        cs = null;
    }

    public static MBeanServerConnection conn() throws IOException {
        return cc.getMBeanServerConnection();
    }

    public static Set<ObjectName> ensureAll(String ... expectedNames) throws IOException {
        Set<ObjectName> beans;
        try {
            beans = JMXEnv.conn().queryNames(new ObjectName("org.apache.ZooKeeperService:*"), null);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        HashSet<ObjectName> found = new HashSet<ObjectName>();
        for (String name : expectedNames) {
            LOG.info("expect:" + name);
            for (ObjectName bean : beans) {
                if (!bean.toString().contains(name)) continue;
                LOG.info("found:" + name + " " + bean);
                found.add(bean);
                break;
            }
            beans.removeAll(found);
        }
        TestCase.assertEquals((String)("expected " + Arrays.toString(expectedNames)), (int)expectedNames.length, (int)found.size());
        return beans;
    }

    public static Set<ObjectName> ensureOnly(String ... expectedNames) throws IOException {
        LOG.info("ensureOnly:" + Arrays.toString(expectedNames));
        Set<ObjectName> beans = JMXEnv.ensureAll(expectedNames);
        for (ObjectName bean : beans) {
            LOG.info("unexpected:" + bean.toString());
        }
        TestCase.assertEquals((int)0, (int)beans.size());
        return beans;
    }

    public static void ensureNone(String ... expectedNames) throws IOException {
        Set<ObjectName> beans;
        try {
            beans = JMXEnv.conn().queryNames(new ObjectName("org.apache.ZooKeeperService:*"), null);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        for (String name : expectedNames) {
            for (ObjectName bean : beans) {
                if (!bean.toString().contains(name)) continue;
                LOG.info("didntexpect:" + name);
                TestCase.fail((String)(name + " " + bean.toString()));
            }
        }
    }

    public static void dump() throws IOException {
        Set<ObjectName> beans;
        LOG.info("JMXEnv.dump() follows");
        try {
            beans = JMXEnv.conn().queryNames(new ObjectName("org.apache.ZooKeeperService:*"), null);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        for (ObjectName bean : beans) {
            LOG.info("bean:" + bean.toString());
        }
    }
}

