/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ClientTest;
import org.apache.zookeeper.test.DisconnectableZooKeeper;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.Assert;
import org.junit.Test;

public class FollowerResyncConcurrencyTest
extends ZKTestCase {
    private static final Logger LOG = Logger.getLogger(FollowerResyncConcurrencyTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;
    private volatile int counter = 0;
    private volatile int errors = 0;

    @Test
    public void testLaggingFollowerResyncsUnderNewEpoch() throws Exception {
        ClientBase.CountdownWatcher watcher1 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher2 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher3 = new ClientBase.CountdownWatcher();
        QuorumUtil qu = new QuorumUtil(1);
        qu.shutdownAll();
        qu.start(1);
        qu.start(2);
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + qu.getPeer((int)1).clientPort, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + qu.getPeer((int)2).clientPort, ClientBase.CONNECTION_TIMEOUT));
        DisconnectableZooKeeper zk1 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)1).peer.getClientPort(), watcher1);
        LOG.info((Object)("zk1 has session id 0x" + Long.toHexString(zk1.getSessionId())));
        String resyncPath = "/resyncundernewepoch";
        zk1.create("/resyncundernewepoch", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.close();
        qu.shutdown(1);
        qu.shutdown(2);
        Assert.assertTrue((String)"Waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + qu.getPeer((int)1).clientPort, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"Waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + qu.getPeer((int)2).clientPort, ClientBase.CONNECTION_TIMEOUT));
        qu.start(1);
        qu.start(2);
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + qu.getPeer((int)1).clientPort, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + qu.getPeer((int)2).clientPort, ClientBase.CONNECTION_TIMEOUT));
        qu.start(3);
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + qu.getPeer((int)3).clientPort, ClientBase.CONNECTION_TIMEOUT));
        zk1 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)1).peer.getClientPort(), watcher1);
        LOG.info((Object)("zk1 has session id 0x" + Long.toHexString(zk1.getSessionId())));
        Assert.assertNotNull((String)"zk1 has data", (Object)zk1.exists("/resyncundernewepoch", false));
        DisconnectableZooKeeper zk2 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)2).peer.getClientPort(), watcher2);
        LOG.info((Object)("zk2 has session id 0x" + Long.toHexString(zk2.getSessionId())));
        Assert.assertNotNull((String)"zk2 has data", (Object)zk2.exists("/resyncundernewepoch", false));
        DisconnectableZooKeeper zk3 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)3).peer.getClientPort(), watcher3);
        LOG.info((Object)("zk3 has session id 0x" + Long.toHexString(zk3.getSessionId())));
        Assert.assertNotNull((String)"zk3 has data", (Object)zk3.exists("/resyncundernewepoch", false));
        zk1.close();
        zk2.close();
        zk3.close();
        qu.shutdownAll();
    }

    @Test
    public void testResyncBySnapThenDiffAfterFollowerCrashes() throws IOException, InterruptedException, KeeperException, Throwable {
        final Semaphore sem = new Semaphore(0);
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        ClientBase.CountdownWatcher watcher1 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher2 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher3 = new ClientBase.CountdownWatcher();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        Leader leader = qu.getPeer((int)index).peer.leader;
        Assert.assertNotNull((Object)leader);
        index = index == 1 ? 2 : 1;
        LOG.info((Object)("Connecting to follower:" + index));
        qu.shutdown(index);
        final DisconnectableZooKeeper zk3 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)3).peer.getClientPort(), watcher3);
        LOG.info((Object)("zk3 has session id 0x" + Long.toHexString(zk3.getSessionId())));
        zk3.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        qu.restart(index);
        DisconnectableZooKeeper zk1 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)index).peer.getClientPort(), watcher1);
        LOG.info((Object)("zk1 has session id 0x" + Long.toHexString(zk1.getSessionId())));
        DisconnectableZooKeeper zk2 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)index).peer.getClientPort(), watcher2);
        LOG.info((Object)("zk2 has session id 0x" + Long.toHexString(zk2.getSessionId())));
        zk1.create("/first", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Thread mytestfooThread = new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < 3000; ++i) {
                    zk3.create("/mytestfoo", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                        public void processResult(int rc, String path, Object ctx, String name) {
                            FollowerResyncConcurrencyTest.this.counter++;
                            if (rc != 0) {
                                FollowerResyncConcurrencyTest.this.errors++;
                            }
                            if (FollowerResyncConcurrencyTest.this.counter == 16200) {
                                sem.release();
                            }
                        }
                    }, null);
                    if (i % 10 != 0) continue;
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        for (int i = 0; i < 13000; ++i) {
            zk3.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                public void processResult(int rc, String path, Object ctx, String name) {
                    FollowerResyncConcurrencyTest.this.counter++;
                    if (rc != 0) {
                        FollowerResyncConcurrencyTest.this.errors++;
                    }
                    if (FollowerResyncConcurrencyTest.this.counter == 16200) {
                        sem.release();
                    }
                }
            }, null);
            if (i == 5000) {
                qu.shutdown(index);
                LOG.info((Object)"Shutting down s1");
            }
            if (i == 12000) {
                mytestfooThread.start();
                qu.restart(index);
                Thread.sleep(300L);
                qu.shutdown(index);
                Thread.sleep(300L);
                qu.restart(index);
                LOG.info((Object)("Setting up server: " + index));
            }
            if (i % 1000 == 0) {
                Thread.sleep(1000L);
            }
            if (i % 50 != 0) continue;
            zk2.create("/newbaz", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                public void processResult(int rc, String path, Object ctx, String name) {
                    FollowerResyncConcurrencyTest.this.counter++;
                    if (rc != 0) {
                        FollowerResyncConcurrencyTest.this.errors++;
                    }
                    if (FollowerResyncConcurrencyTest.this.counter == 16200) {
                        sem.release();
                    }
                }
            }, null);
        }
        if (!sem.tryAcquire(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
            LOG.warn((Object)"Did not aquire semaphore fast enough");
        }
        mytestfooThread.join(ClientBase.CONNECTION_TIMEOUT);
        if (mytestfooThread.isAlive()) {
            LOG.error((Object)"mytestfooThread is still alive");
        }
        Thread.sleep(1000L);
        this.verifyState(qu, index, leader);
        zk1.close();
        zk2.close();
        zk3.close();
        qu.shutdownAll();
    }

    @Test
    public void testResyncByDiffAfterFollowerCrashes() throws IOException, InterruptedException, KeeperException, Throwable {
        final Semaphore sem = new Semaphore(0);
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        ClientBase.CountdownWatcher watcher1 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher2 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher3 = new ClientBase.CountdownWatcher();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        Leader leader = qu.getPeer((int)index).peer.leader;
        Assert.assertNotNull((Object)leader);
        index = index == 1 ? 2 : 1;
        LOG.info((Object)("Connecting to follower:" + index));
        DisconnectableZooKeeper zk1 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)index).peer.getClientPort(), watcher1);
        LOG.info((Object)("zk1 has session id 0x" + Long.toHexString(zk1.getSessionId())));
        DisconnectableZooKeeper zk2 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)index).peer.getClientPort(), watcher2);
        LOG.info((Object)("zk2 has session id 0x" + Long.toHexString(zk2.getSessionId())));
        final DisconnectableZooKeeper zk3 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)3).peer.getClientPort(), watcher3);
        LOG.info((Object)("zk3 has session id 0x" + Long.toHexString(zk3.getSessionId())));
        zk1.create("/first", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk2.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        final AtomicBoolean runNow = new AtomicBoolean(false);
        Thread mytestfooThread = new Thread(new Runnable(){

            public void run() {
                int inSyncCounter = 0;
                while (inSyncCounter < 400) {
                    if (runNow.get()) {
                        zk3.create("/mytestfoo", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                            public void processResult(int rc, String path, Object ctx, String name) {
                                FollowerResyncConcurrencyTest.this.counter++;
                                if (rc != 0) {
                                    FollowerResyncConcurrencyTest.this.errors++;
                                }
                                if (FollowerResyncConcurrencyTest.this.counter > 7300) {
                                    sem.release();
                                }
                            }
                        }, null);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++inSyncCounter;
                        continue;
                    }
                    Thread.yield();
                }
            }
        });
        mytestfooThread.start();
        for (int i = 0; i < 5000; ++i) {
            zk2.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                public void processResult(int rc, String path, Object ctx, String name) {
                    FollowerResyncConcurrencyTest.this.counter++;
                    if (rc != 0) {
                        FollowerResyncConcurrencyTest.this.errors++;
                    }
                    if (FollowerResyncConcurrencyTest.this.counter > 7300) {
                        sem.release();
                    }
                }
            }, null);
            if (i == 1000) {
                qu.shutdown(index);
                Thread.sleep(1100L);
                LOG.info((Object)"Shutting down s1");
            }
            if (i == 1100 || i == 1150 || i == 1200) {
                Thread.sleep(1000L);
            }
            if (i == 1200) {
                qu.startThenShutdown(index);
                runNow.set(true);
                qu.restart(index);
                LOG.info((Object)("Setting up server: " + index));
            }
            if (i >= 1000 && i % 2 == 0) {
                zk3.create("/newbaz", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                    public void processResult(int rc, String path, Object ctx, String name) {
                        FollowerResyncConcurrencyTest.this.counter++;
                        if (rc != 0) {
                            FollowerResyncConcurrencyTest.this.errors++;
                        }
                        if (FollowerResyncConcurrencyTest.this.counter > 7300) {
                            sem.release();
                        }
                    }
                }, null);
            }
            if (i != 1050 && i != 1100 && i != 1150) continue;
            Thread.sleep(1000L);
        }
        if (!sem.tryAcquire(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
            LOG.warn((Object)"Did not aquire semaphore fast enough");
        }
        mytestfooThread.join(ClientBase.CONNECTION_TIMEOUT);
        if (mytestfooThread.isAlive()) {
            LOG.error((Object)"mytestfooThread is still alive");
        }
        Thread.sleep(1000L);
        this.verifyState(qu, index, leader);
        zk1.close();
        zk2.close();
        zk3.close();
        qu.shutdownAll();
    }

    private static DisconnectableZooKeeper createClient(int port, ClientBase.CountdownWatcher watcher) throws IOException, TimeoutException, InterruptedException {
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper("127.0.0.1:" + port, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        return zk;
    }

    private void verifyState(QuorumUtil qu, int index, Leader leader) {
        Assert.assertTrue((String)"Not following", (qu.getPeer((int)index).peer.follower != null ? 1 : 0) != 0);
        long epochF = qu.getPeer((int)index).peer.getActiveServer().getZxid() >> 32;
        long epochL = leader.getEpoch() >> 32;
        Assert.assertTrue((String)("Zxid: " + qu.getPeer((int)index).peer.getActiveServer().getZKDatabase().getDataTreeLastProcessedZxid() + "Current epoch: " + epochF), (epochF == epochL ? 1 : 0) != 0);
        int leaderIndex = index == 1 ? 2 : 1;
        Collection sessionsRestarted = qu.getPeer((int)index).peer.getActiveServer().getZKDatabase().getSessions();
        Collection sessionsNotRestarted = qu.getPeer((int)leaderIndex).peer.getActiveServer().getZKDatabase().getSessions();
        for (Long l : sessionsRestarted) {
            Assert.assertTrue((String)("Should have same set of sessions in both servers, did not expect: " + l), (boolean)sessionsNotRestarted.contains(l));
        }
        Assert.assertEquals((String)"Should have same number of sessions", (long)sessionsNotRestarted.size(), (long)sessionsRestarted.size());
        ZKDatabase restarted = qu.getPeer((int)index).peer.getActiveServer().getZKDatabase();
        ZKDatabase clean = qu.getPeer((int)3).peer.getActiveServer().getZKDatabase();
        ZKDatabase lead = qu.getPeer((int)leaderIndex).peer.getActiveServer().getZKDatabase();
        for (Long l : sessionsRestarted) {
            Assert.assertTrue((String)("Should have same set of sessions in both servers, did not expect: " + l), (boolean)sessionsNotRestarted.contains(l));
            HashSet ephemerals = restarted.getEphemerals(l.longValue());
            HashSet cleanEphemerals = clean.getEphemerals(l.longValue());
            for (Object o : cleanEphemerals) {
                if (ephemerals.contains(o)) continue;
                LOG.info((Object)("Restarted follower doesn't contain ephemeral " + o));
            }
            HashSet leadEphemerals = lead.getEphemerals(l.longValue());
            for (Object o : leadEphemerals) {
                if (cleanEphemerals.contains(o)) continue;
                LOG.info((Object)("Follower doesn't contain ephemeral from leader " + o));
            }
            Assert.assertEquals((String)"Should have same number of ephemerals in both followers", (long)ephemerals.size(), (long)cleanEphemerals.size());
            Assert.assertEquals((String)"Leader should equal follower", (long)lead.getEphemerals(l.longValue()).size(), (long)cleanEphemerals.size());
        }
    }
}

