/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.client.FourLetterWordMain;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourLetterWordsTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(FourLetterWordsTest.class);

    @Test
    public void testFourLetterWords() throws Exception {
        this.verify("ruok", "imok");
        this.verify("envi", "java.version");
        this.verify("conf", "clientPort");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        this.verify("dump", "Session");
        this.verify("wchs", "watches");
        this.verify("wchp", "");
        this.verify("wchc", "");
        this.verify("srst", "reset");
        this.verify("crst", "reset");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        TestableZooKeeper zk = this.createClient();
        String sid = "0x" + Long.toHexString(zk.getSessionId());
        this.verify("stat", "queued");
        this.verify("srvr", "Outstanding");
        this.verify("cons", sid);
        this.verify("dump", sid);
        zk.getData("/", true, null);
        this.verify("stat", "queued");
        this.verify("srvr", "Outstanding");
        this.verify("cons", sid);
        this.verify("dump", sid);
        this.verify("wchs", "watching 1");
        this.verify("wchp", sid);
        this.verify("wchc", sid);
        zk.close();
        this.verify("ruok", "imok");
        this.verify("envi", "java.version");
        this.verify("conf", "clientPort");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        this.verify("dump", "Session");
        this.verify("wchs", "watch");
        this.verify("wchp", "");
        this.verify("wchc", "");
        this.verify("srst", "reset");
        this.verify("crst", "reset");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        this.verify("mntr", "zk_server_state\tstandalone");
    }

    private String sendRequest(String cmd) throws IOException {
        ClientBase.HostPort hpobj = ClientBase.parseHostPortList(this.hostPort).get(0);
        return FourLetterWordMain.send4LetterWord((String)hpobj.host, (int)hpobj.port, (String)cmd);
    }

    private void verify(String cmd, String expected) throws IOException {
        String resp = this.sendRequest(cmd);
        LOG.info("cmd " + cmd + " expected " + expected + " got " + resp);
        Assert.assertTrue((boolean)resp.contains(expected));
    }

    @Test
    public void validateStatOutput() throws Exception {
        TestableZooKeeper zk1 = this.createClient();
        TestableZooKeeper zk2 = this.createClient();
        String resp = this.sendRequest("stat");
        BufferedReader in = new BufferedReader(new StringReader(resp));
        String line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^.*\\s\\d+\\.\\d+\\.\\d+-.*$", line));
        Assert.assertTrue((boolean)Pattern.matches("^Clients:$", in.readLine()));
        int count = 0;
        while ((line = in.readLine()).length() > 0) {
            ++count;
            Assert.assertTrue((boolean)Pattern.matches("^ /.*:\\d+\\[\\d+\\]\\(queued=\\d+,recved=\\d+,sent=\\d+\\)$", line));
        }
        Assert.assertTrue((count >= 2 ? 1 : 0) != 0);
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Latency min/avg/max: \\d+/\\d+/\\d+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Received: \\d+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Sent: \\d+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Outstanding: \\d+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Zxid: 0x[\\da-fA-F]+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Mode: .*$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Node count: \\d+$", line));
        zk1.close();
        zk2.close();
    }

    @Test
    public void validateConsOutput() throws Exception {
        String line;
        TestableZooKeeper zk1 = this.createClient();
        TestableZooKeeper zk2 = this.createClient();
        String resp = this.sendRequest("cons");
        BufferedReader in = new BufferedReader(new StringReader(resp));
        int count = 0;
        while ((line = in.readLine()) != null && line.length() > 0) {
            ++count;
            Assert.assertTrue((String)line, (boolean)Pattern.matches("^ /.*:\\d+\\[\\d+\\]\\(queued=\\d+,recved=\\d+,sent=\\d+.*\\)$", line));
        }
        Assert.assertTrue((count >= 2 ? 1 : 0) != 0);
        zk1.close();
        zk2.close();
    }
}

