/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class GetAclCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetAclCommand() {
        super("getAcl", "[-s] path");
        options.addOption("s", false, "stats");
    }

    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        this.cl = parser.parse(options, cmdArgs);
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new ParseException(this.getUsageStr());
        }
        return this;
    }

    public boolean exec() throws KeeperException, InterruptedException {
        String path = this.args[1];
        Stat stat = new Stat();
        List<ACL> acl = this.zk.getACL(path, stat);
        for (ACL a : acl) {
            this.out.println(a.getId() + ": " + GetAclCommand.getPermString(a.getPerms()));
        }
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return false;
    }

    private static String getPermString(int perms) {
        StringBuilder p = new StringBuilder();
        if ((perms & 4) != 0) {
            p.append('c');
        }
        if ((perms & 8) != 0) {
            p.append('d');
        }
        if ((perms & 1) != 0) {
            p.append('r');
        }
        if ((perms & 2) != 0) {
            p.append('w');
        }
        if ((perms & 0x10) != 0) {
            p.append('a');
        }
        return p.toString();
    }
}

