/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.Stat;

public class Ls2Command
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public Ls2Command() {
        super("ls2", "path [watch]");
    }

    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cl = parser.parse(options, cmdArgs);
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new ParseException(this.getUsageStr());
        }
        return this;
    }

    public boolean exec() throws KeeperException, InterruptedException {
        this.err.println("'ls2' has been deprecated. Please use 'ls [-s] path' instead.");
        String path = this.args[1];
        boolean watch = this.args.length > 2;
        Stat stat = new Stat();
        List<String> children = this.zk.getChildren(path, watch, stat);
        this.out.println(children);
        new StatPrinter(this.out).print(stat);
        return watch;
    }
}

