/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.Stat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LsCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public LsCommand() {
        super("ls", "[-s] [-w] path");
        options.addOption("?", false, "help");
        options.addOption("s", false, "stat");
        options.addOption("w", false, "watch");
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("ls [options] path", options);
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        this.cl = parser.parse(options, cmdArgs);
        this.args = this.cl.getArgs();
        if (this.cl.hasOption("?")) {
            this.printHelp();
        }
        if (this.args.length < 2) {
            throw new ParseException(this.getUsageStr());
        }
        this.retainCompatibility(cmdArgs);
        return this;
    }

    private void retainCompatibility(String[] cmdArgs) throws ParseException {
        if (this.args.length > 2) {
            cmdArgs[2] = "-w";
            this.err.println("'ls path [watch]' has been deprecated. Please use 'ls [-w] path' instead.");
            PosixParser parser = new PosixParser();
            this.cl = parser.parse(options, cmdArgs);
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws KeeperException, InterruptedException {
        String path = this.args[1];
        boolean watch = this.cl.hasOption("w");
        boolean withStat = this.cl.hasOption("s");
        try {
            Stat stat = new Stat();
            List<String> children = withStat ? this.zk.getChildren(path, watch, stat) : this.zk.getChildren(path, watch);
            this.out.println(this.printChildren(children));
            if (withStat) {
                new StatPrinter(this.out).print(stat);
            }
        }
        catch (KeeperException.NoAuthException ex) {
            this.err.println(ex.getMessage());
            watch = false;
        }
        return watch;
    }

    private String printChildren(List<String> children) {
        Collections.sort(children);
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (String child : children) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(child);
        }
        sb.append("]");
        return sb.toString();
    }
}

