/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class ReconfigCommand
extends CliCommand {
    private static Options options = new Options();
    private String joining;
    private String leaving;
    private String members;
    long version = -1L;
    private CommandLine cl;

    public ReconfigCommand() {
        super("reconfig", "[-s] [-v version] [[-file path] | [-members serverID=host:port1:port2;port3[,...]*]] | [-add serverId=host:port1:port2;port3[,...]]* [-remove serverId[,...]*]");
        options.addOption("s", false, "stats");
        options.addOption("v", true, "required current config version");
        options.addOption("file", true, "path of config file to parse for membership");
        options.addOption("members", true, "comma-separated list of config strings for non-incremental reconfig");
        options.addOption("add", true, "comma-separated list of config strings for new servers");
        options.addOption("remove", true, "comma-separated list of server IDs to remove");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CliCommand parse(String[] cmdArgs) throws ParseException {
        this.joining = null;
        this.leaving = null;
        this.members = null;
        PosixParser parser = new PosixParser();
        this.cl = parser.parse(options, cmdArgs);
        if (!(this.cl.hasOption("file") || this.cl.hasOption("members") || this.cl.hasOption("add") || this.cl.hasOption("remove"))) {
            throw new ParseException(this.getUsageStr());
        }
        if (this.cl.hasOption("v")) {
            try {
                this.version = Long.parseLong(this.cl.getOptionValue("v"), 16);
            }
            catch (NumberFormatException e) {
                throw new ParseException("-v must be followed by a long (configuration version)");
            }
        } else {
            this.version = -1L;
        }
        if ((this.cl.hasOption("file") || this.cl.hasOption("members")) && (this.cl.hasOption("add") || this.cl.hasOption("remove"))) {
            throw new ParseException("Can't use -file or -members together with -add or -remove (mixing incremental and non-incremental modes is not allowed)");
        }
        if (this.cl.hasOption("file") && this.cl.hasOption("members")) {
            throw new ParseException("Can't use -file and -members together (conflicting non-incremental modes)");
        }
        if (this.cl.hasOption("add")) {
            this.joining = this.cl.getOptionValue("add").toLowerCase();
        }
        if (this.cl.hasOption("remove")) {
            this.leaving = this.cl.getOptionValue("remove").toLowerCase();
        }
        if (this.cl.hasOption("members")) {
            this.members = this.cl.getOptionValue("members").toLowerCase();
        }
        if (this.cl.hasOption("file")) {
            try {
                FileInputStream inConfig = new FileInputStream(this.cl.getOptionValue("file"));
                Properties dynamicCfg = new Properties();
                try {
                    dynamicCfg.load(inConfig);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    inConfig.close();
                    throw throwable;
                }
                inConfig.close();
                this.members = QuorumPeerConfig.parseDynamicConfig(dynamicCfg, 0, true, false).toString();
            }
            catch (Exception e) {
                throw new ParseException("Error processing " + this.cl.getOptionValue("file") + e.getMessage());
            }
        }
        return this;
    }

    public boolean exec() throws KeeperException, InterruptedException {
        try {
            Stat stat = new Stat();
            byte[] curConfig = this.zk.reconfig(this.joining, this.leaving, this.members, this.version, stat);
            this.out.println("Committed new configuration:\n" + new String(curConfig));
            if (this.cl.hasOption("s")) {
                new StatPrinter(this.out).print(stat);
            }
        }
        catch (KeeperException ex) {
            this.err.println(ex.getMessage());
        }
        return false;
    }
}

