/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.AclParser;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class SetAclCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetAclCommand() {
        super("setAcl", "[-s] [-v version] path acl");
        options.addOption("s", false, "stats");
        options.addOption("v", true, "version");
    }

    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        this.cl = parser.parse(options, cmdArgs);
        this.args = this.cl.getArgs();
        if (this.args.length < 3) {
            throw new ParseException(this.getUsageStr());
        }
        return this;
    }

    public boolean exec() throws KeeperException, InterruptedException {
        String path = this.args[1];
        String aclStr = this.args[2];
        List<ACL> acl = AclParser.parse(aclStr);
        int version = this.cl.hasOption("v") ? Integer.parseInt(this.cl.getOptionValue("v")) : -1;
        try {
            Stat stat = this.zk.setACL(path, acl, version);
            if (this.cl.hasOption("s")) {
                new StatPrinter(this.out).print(stat);
            }
        }
        catch (KeeperException.InvalidACLException ex) {
            this.err.println(ex.getMessage());
        }
        catch (KeeperException.NoAuthException ex) {
            this.err.println(ex.getMessage());
        }
        return false;
    }
}

