/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.Stat;

public class SetCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetCommand() {
        super("set", "[-s] [-v version] path data");
        options.addOption("s", false, "stats");
        options.addOption("v", true, "version");
    }

    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        this.cl = parser.parse(options, cmdArgs);
        this.args = this.cl.getArgs();
        if (this.args.length < 3) {
            throw new ParseException(this.getUsageStr());
        }
        return this;
    }

    public boolean exec() throws KeeperException, InterruptedException {
        String path = this.args[1];
        byte[] data = this.args[2].getBytes();
        int version = this.cl.hasOption("v") ? Integer.parseInt(this.cl.getOptionValue("v")) : -1;
        try {
            Stat stat = this.zk.setData(path, data, version);
            if (this.cl.hasOption("s")) {
                new StatPrinter(this.out).print(stat);
            }
        }
        catch (KeeperException.BadVersionException ex) {
            this.err.println(ex.getMessage());
        }
        return false;
    }
}

