/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.Environment;
import org.apache.zookeeper.Version;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.proto.WatcherEvent;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperSaslServer;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import org.apache.zookeeper.server.util.OSMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOServerCnxn
extends ServerCnxn {
    private static final Logger LOG = LoggerFactory.getLogger(NIOServerCnxn.class);
    private final NIOServerCnxnFactory factory;
    private final SocketChannel sock;
    private final NIOServerCnxnFactory.SelectorThread selectorThread;
    private final SelectionKey sk;
    private boolean initialized;
    private final ByteBuffer lenBuffer;
    private ByteBuffer incomingBuffer;
    private final Queue<ByteBuffer> outgoingBuffers;
    private int sessionTimeout;
    private final ZooKeeperServer zkServer;
    private final AtomicInteger outstandingRequests;
    private long sessionId;
    private final int outstandingLimit;
    private final AtomicBoolean selectable;
    private final AtomicBoolean throttled;
    private static final String ZK_NOT_SERVING = "This ZooKeeper instance is not currently serving requests";
    private static final byte[] fourBytes = new byte[4];

    public NIOServerCnxn(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, NIOServerCnxnFactory factory, NIOServerCnxnFactory.SelectorThread selectorThread) throws IOException {
        this.incomingBuffer = this.lenBuffer = ByteBuffer.allocate(4);
        this.outgoingBuffers = new LinkedBlockingQueue<ByteBuffer>();
        this.outstandingRequests = new AtomicInteger(0);
        this.selectable = new AtomicBoolean(true);
        this.throttled = new AtomicBoolean(false);
        this.zkServer = zk;
        this.sock = sock;
        this.sk = sk;
        this.factory = factory;
        this.selectorThread = selectorThread;
        if (this.factory.login != null) {
            this.zooKeeperSaslServer = new ZooKeeperSaslServer(factory.login);
        }
        this.outstandingLimit = zk != null ? zk.getGlobalOutstandingLimit() : 1;
        sock.socket().setTcpNoDelay(true);
        sock.socket().setSoLinger(false, -1);
        InetAddress addr = ((InetSocketAddress)sock.socket().getRemoteSocketAddress()).getAddress();
        this.authInfo.add(new Id("ip", addr.getHostAddress()));
        this.sessionTimeout = factory.sessionlessCnxnTimeout;
    }

    public void sendCloseSession() {
        this.sendBuffer(ServerCnxnFactory.closeConn);
    }

    void sendBufferSync(ByteBuffer bb) {
        try {
            if (bb != ServerCnxnFactory.closeConn) {
                if (this.sock.isOpen()) {
                    this.sock.configureBlocking(true);
                    this.sock.write(bb);
                }
                this.packetSent();
            }
        }
        catch (IOException ie) {
            LOG.error("Error sending data synchronously ", (Throwable)ie);
        }
    }

    public void sendBuffer(ByteBuffer bb) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Add a buffer to outgoingBuffers, sk " + this.sk + " is valid: " + this.sk.isValid());
        }
        this.outgoingBuffers.add(bb);
        this.requestInterestOpsUpdate();
    }

    private void readPayload() throws IOException, InterruptedException {
        int rc;
        if (this.incomingBuffer.remaining() != 0 && (rc = this.sock.read(this.incomingBuffer)) < 0) {
            throw new ServerCnxn.EndOfStreamException("Unable to read additional data from client sessionid 0x" + Long.toHexString(this.sessionId) + ", likely client has closed socket");
        }
        if (this.incomingBuffer.remaining() == 0) {
            this.packetReceived();
            this.incomingBuffer.flip();
            if (!this.initialized) {
                this.readConnectRequest();
            } else {
                this.readRequest();
            }
            this.lenBuffer.clear();
            this.incomingBuffer = this.lenBuffer;
        }
    }

    public boolean isSelectable() {
        return this.sk.isValid() && this.selectable.get();
    }

    public void disableSelectable() {
        this.selectable.set(false);
    }

    public void enableSelectable() {
        this.selectable.set(true);
    }

    private void requestInterestOpsUpdate() {
        if (this.isSelectable()) {
            this.selectorThread.addInterestOpsUpdateRequest(this.sk);
        }
    }

    void handleWrite(SelectionKey k) throws IOException, ServerCnxn.CloseRequestException {
        if (this.outgoingBuffers.isEmpty()) {
            return;
        }
        ByteBuffer directBuffer = NIOServerCnxnFactory.getDirectBuffer();
        if (directBuffer == null) {
            ByteBuffer bb;
            ByteBuffer[] bufferList = new ByteBuffer[this.outgoingBuffers.size()];
            this.sock.write(this.outgoingBuffers.toArray(bufferList));
            while ((bb = this.outgoingBuffers.peek()) != null) {
                if (bb == ServerCnxnFactory.closeConn) {
                    throw new ServerCnxn.CloseRequestException("close requested");
                }
                if (bb.remaining() <= 0) {
                    this.packetSent();
                    this.outgoingBuffers.remove();
                    continue;
                }
                break;
            }
        } else {
            ByteBuffer bb;
            directBuffer.clear();
            for (ByteBuffer b : this.outgoingBuffers) {
                if (directBuffer.remaining() < b.remaining()) {
                    b = (ByteBuffer)b.slice().limit(directBuffer.remaining());
                }
                int p = b.position();
                directBuffer.put(b);
                b.position(p);
                if (directBuffer.remaining() != 0) continue;
                break;
            }
            directBuffer.flip();
            int sent = this.sock.write(directBuffer);
            while ((bb = this.outgoingBuffers.peek()) != null) {
                if (bb == ServerCnxnFactory.closeConn) {
                    throw new ServerCnxn.CloseRequestException("close requested");
                }
                if (sent < bb.remaining()) {
                    bb.position(bb.position() + sent);
                    break;
                }
                this.packetSent();
                sent -= bb.remaining();
                this.outgoingBuffers.remove();
            }
        }
    }

    protected boolean isSocketOpen() {
        return this.sock.isOpen();
    }

    void doIO(SelectionKey k) throws InterruptedException {
        try {
            if (!this.isSocketOpen()) {
                LOG.warn("trying to do i/o on a null socket for session:0x" + Long.toHexString(this.sessionId));
                return;
            }
            if (k.isReadable()) {
                int rc = this.sock.read(this.incomingBuffer);
                if (rc < 0) {
                    throw new ServerCnxn.EndOfStreamException("Unable to read additional data from client sessionid 0x" + Long.toHexString(this.sessionId) + ", likely client has closed socket");
                }
                if (this.incomingBuffer.remaining() == 0) {
                    boolean isPayload;
                    if (this.incomingBuffer == this.lenBuffer) {
                        this.incomingBuffer.flip();
                        isPayload = this.readLength(k);
                        this.incomingBuffer.clear();
                    } else {
                        isPayload = true;
                    }
                    if (isPayload) {
                        this.readPayload();
                    } else {
                        return;
                    }
                }
            }
            if (k.isWritable()) {
                this.handleWrite(k);
                if (!(this.initialized || this.getReadInterest() || this.getWriteInterest())) {
                    throw new ServerCnxn.CloseRequestException("responded to info probe");
                }
            }
        }
        catch (CancelledKeyException e) {
            LOG.warn("CancelledKeyException causing close of session 0x" + Long.toHexString(this.sessionId));
            if (LOG.isDebugEnabled()) {
                LOG.debug("CancelledKeyException stack trace", (Throwable)e);
            }
            this.close();
        }
        catch (ServerCnxn.CloseRequestException e) {
            this.close();
        }
        catch (ServerCnxn.EndOfStreamException e) {
            LOG.warn(e.getMessage());
            this.close();
        }
        catch (IOException e) {
            LOG.warn("Exception causing close of session 0x" + Long.toHexString(this.sessionId) + ": " + e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug("IOException stack trace", (Throwable)e);
            }
            this.close();
        }
    }

    private void readRequest() throws IOException {
        this.zkServer.processPacket(this, this.incomingBuffer);
    }

    protected void incrOutstandingRequests(RequestHeader h) {
        if (h.getXid() >= 0) {
            this.outstandingRequests.incrementAndGet();
            int inProcess = this.zkServer.getInProcess();
            if (inProcess > this.outstandingLimit) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Throttling recv " + inProcess);
                }
                this.disableRecv();
            }
        }
    }

    private boolean getWriteInterest() {
        return !this.outgoingBuffers.isEmpty();
    }

    private boolean getReadInterest() {
        return !this.throttled.get();
    }

    public void disableRecv() {
        if (this.throttled.compareAndSet(false, true)) {
            this.requestInterestOpsUpdate();
        }
    }

    public void enableRecv() {
        if (this.throttled.compareAndSet(true, false)) {
            this.requestInterestOpsUpdate();
        }
    }

    private void readConnectRequest() throws IOException, InterruptedException {
        if (this.zkServer == null) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.zkServer.processConnectRequest(this, this.incomingBuffer);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void cleanupWriterSocket(PrintWriter pwriter) {
        block9: {
            block8: {
                if (pwriter == null) break block8;
                pwriter.flush();
                pwriter.close();
            }
            Object var4_2 = null;
            try {
                this.close();
            }
            catch (Exception e2) {
                LOG.error("Error closing a command socket ", (Throwable)e2);
            }
            break block9;
            {
                catch (Exception e) {
                    LOG.info("Error closing PrintWriter ", (Throwable)e);
                    Object var4_3 = null;
                    try {
                        this.close();
                    }
                    catch (Exception e2) {
                        LOG.error("Error closing a command socket ", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.close();
                }
                catch (Exception e2) {
                    LOG.error("Error closing a command socket ", (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    private boolean checkFourLetterWord(SelectionKey k, int len) throws IOException {
        String cmd = (String)cmd2String.get(len);
        if (cmd == null) {
            return false;
        }
        LOG.info("Processing " + cmd + " command from " + this.sock.socket().getRemoteSocketAddress());
        this.packetReceived();
        if (k != null) {
            try {
                k.cancel();
            }
            catch (Exception e) {
                LOG.error("Error cancelling command selection key ", (Throwable)e);
            }
        }
        PrintWriter pwriter = new PrintWriter(new BufferedWriter(new SendBufferWriter()));
        if (len == ruokCmd) {
            RuokCommand ruok = new RuokCommand(pwriter);
            ruok.start();
            return true;
        }
        if (len == getTraceMaskCmd) {
            TraceMaskCommand tmask = new TraceMaskCommand(pwriter);
            tmask.start();
            return true;
        }
        if (len == setTraceMaskCmd) {
            int rc = this.sock.read(this.incomingBuffer);
            if (rc < 0) {
                throw new IOException("Read error");
            }
            this.incomingBuffer.flip();
            long traceMask = this.incomingBuffer.getLong();
            ZooTrace.setTextTraceLevel(traceMask);
            SetTraceMaskCommand setMask = new SetTraceMaskCommand(pwriter, traceMask);
            setMask.start();
            return true;
        }
        if (len == enviCmd) {
            EnvCommand env = new EnvCommand(pwriter);
            env.start();
            return true;
        }
        if (len == confCmd) {
            ConfCommand ccmd = new ConfCommand(pwriter);
            ccmd.start();
            return true;
        }
        if (len == srstCmd) {
            StatResetCommand strst = new StatResetCommand(pwriter);
            strst.start();
            return true;
        }
        if (len == crstCmd) {
            CnxnStatResetCommand crst = new CnxnStatResetCommand(pwriter);
            crst.start();
            return true;
        }
        if (len == dumpCmd) {
            DumpCommand dump = new DumpCommand(pwriter);
            dump.start();
            return true;
        }
        if (len == statCmd || len == srvrCmd) {
            StatCommand stat = new StatCommand(pwriter, len);
            stat.start();
            return true;
        }
        if (len == consCmd) {
            ConsCommand cons = new ConsCommand(pwriter);
            cons.start();
            return true;
        }
        if (len == wchpCmd || len == wchcCmd || len == wchsCmd) {
            WatchCommand wcmd = new WatchCommand(pwriter, len);
            wcmd.start();
            return true;
        }
        if (len == mntrCmd) {
            MonitorCommand mntr = new MonitorCommand(pwriter);
            mntr.start();
            return true;
        }
        if (len == isroCmd) {
            IsroCommand isro = new IsroCommand(pwriter);
            isro.start();
            return true;
        }
        if (len == -720899) {
            this.cleanupWriterSocket(null);
            return true;
        }
        return false;
    }

    private boolean readLength(SelectionKey k) throws IOException {
        int len = this.lenBuffer.getInt();
        if (!this.initialized && this.checkFourLetterWord(this.sk, len)) {
            return false;
        }
        if (len < 0 || len > BinaryInputArchive.maxBuffer) {
            throw new IOException("Len error " + len);
        }
        if (this.zkServer == null) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.incomingBuffer = ByteBuffer.allocate(len);
        return true;
    }

    public long getOutstandingRequests() {
        return this.outstandingRequests.get();
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public String toString() {
        return "ip: " + this.sock.socket().getRemoteSocketAddress() + " sessionId: 0x" + Long.toHexString(this.sessionId);
    }

    public void close() {
        block5: {
            if (!this.factory.removeCnxn(this)) {
                return;
            }
            if (this.zkServer != null) {
                this.zkServer.removeCnxn(this);
            }
            if (this.sk != null) {
                try {
                    this.sk.cancel();
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("ignoring exception during selectionkey cancel", (Throwable)e);
                }
            }
        }
        this.closeSock();
    }

    private void closeSock() {
        if (!this.sock.isOpen()) {
            return;
        }
        LOG.info("Closed socket connection for client " + this.sock.socket().getRemoteSocketAddress() + (this.sessionId != 0L ? " which had sessionid 0x" + Long.toHexString(this.sessionId) : " (no session established for client)"));
        NIOServerCnxn.closeSock(this.sock);
    }

    public static void closeSock(SocketChannel sock) {
        block12: {
            block11: {
                block10: {
                    block9: {
                        if (!sock.isOpen()) {
                            return;
                        }
                        try {
                            sock.socket().shutdownOutput();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block9;
                            LOG.debug("ignoring exception during output shutdown", (Throwable)e);
                        }
                    }
                    try {
                        sock.socket().shutdownInput();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block10;
                        LOG.debug("ignoring exception during input shutdown", (Throwable)e);
                    }
                }
                try {
                    sock.socket().close();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug("ignoring exception during socket close", (Throwable)e);
                }
            }
            try {
                sock.close();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block12;
                LOG.debug("ignoring exception during socketchannel close", (Throwable)e);
            }
        }
    }

    public void sendResponse(ReplyHeader h, Record r, String tag) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
            try {
                baos.write(fourBytes);
                bos.writeRecord(h, "header");
                if (r != null) {
                    bos.writeRecord(r, tag);
                }
                baos.close();
            }
            catch (IOException e) {
                LOG.error("Error serializing response");
            }
            byte[] b = baos.toByteArray();
            ByteBuffer bb = ByteBuffer.wrap(b);
            bb.putInt(b.length - 4).rewind();
            this.sendBuffer(bb);
            if (h.getXid() > 0 && (this.outstandingRequests.decrementAndGet() < 1 || this.zkServer.getInProcess() < this.outstandingLimit)) {
                this.enableRecv();
            }
        }
        catch (Exception e) {
            LOG.warn("Unexpected exception. Destruction averted.", (Throwable)e);
        }
    }

    public void process(WatchedEvent event) {
        ReplyHeader h = new ReplyHeader(-1, -1L, 0);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 64L, "Deliver event " + event + " to 0x" + Long.toHexString(this.sessionId) + " through " + this);
        }
        WatcherEvent e = event.getWrapper();
        this.sendResponse(h, e, "notification");
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
        this.factory.addSession(sessionId, this);
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        this.factory.touchCnxn(this);
    }

    public int getInterestOps() {
        if (!this.isSelectable()) {
            return 0;
        }
        int interestOps = 0;
        if (this.getReadInterest()) {
            interestOps |= 1;
        }
        if (this.getWriteInterest()) {
            interestOps |= 4;
        }
        return interestOps;
    }

    public InetSocketAddress getRemoteSocketAddress() {
        if (!this.sock.isOpen()) {
            return null;
        }
        return (InetSocketAddress)this.sock.socket().getRemoteSocketAddress();
    }

    public InetAddress getSocketAddress() {
        if (!this.sock.isOpen()) {
            return null;
        }
        return this.sock.socket().getInetAddress();
    }

    protected ServerStats serverStats() {
        if (this.zkServer == null) {
            return null;
        }
        return this.zkServer.serverStats();
    }

    private class IsroCommand
    extends CommandThread {
        public IsroCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.print("null");
            } else if (NIOServerCnxn.this.zkServer instanceof ReadOnlyZooKeeperServer) {
                this.pw.print("ro");
            } else {
                this.pw.print("rw");
            }
        }
    }

    private class MonitorCommand
    extends CommandThread {
        MonitorCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
                return;
            }
            ZKDatabase zkdb = NIOServerCnxn.this.zkServer.getZKDatabase();
            ServerStats stats = NIOServerCnxn.this.zkServer.serverStats();
            this.print("version", Version.getFullVersion());
            this.print("avg_latency", stats.getAvgLatency());
            this.print("max_latency", stats.getMaxLatency());
            this.print("min_latency", stats.getMinLatency());
            this.print("packets_received", stats.getPacketsReceived());
            this.print("packets_sent", stats.getPacketsSent());
            this.print("num_alive_connections", stats.getNumAliveClientConnections());
            this.print("outstanding_requests", stats.getOutstandingRequests());
            this.print("server_state", stats.getServerState());
            this.print("znode_count", zkdb.getNodeCount());
            this.print("watch_count", zkdb.getDataTree().getWatchCount());
            this.print("ephemerals_count", zkdb.getDataTree().getEphemeralsCount());
            this.print("approximate_data_size", zkdb.getDataTree().approximateDataSize());
            OSMXBean osMbean = new OSMXBean();
            if (osMbean != null && osMbean.getUnix()) {
                this.print("open_file_descriptor_count", osMbean.getOpenFileDescriptorCount());
                this.print("max_file_descriptor_count", osMbean.getMaxFileDescriptorCount());
            }
            if (stats.getServerState().equals("leader")) {
                Leader leader = ((LeaderZooKeeperServer)NIOServerCnxn.this.zkServer).getLeader();
                this.print("followers", leader.getLearners().size());
                this.print("synced_followers", leader.getForwardingFollowers().size());
                this.print("pending_syncs", leader.getNumPendingSyncs());
            }
        }

        private void print(String key, long number) {
            this.print(key, "" + number);
        }

        private void print(String key, String value) {
            this.pw.print("zk_");
            this.pw.print(key);
            this.pw.print("\t");
            this.pw.println(value);
        }
    }

    private class WatchCommand
    extends CommandThread {
        int len;

        public WatchCommand(PrintWriter pw, int len) {
            super(pw);
            this.len = 0;
            this.len = len;
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                DataTree dt = NIOServerCnxn.this.zkServer.getZKDatabase().getDataTree();
                if (this.len == ServerCnxn.wchsCmd) {
                    dt.dumpWatchesSummary(this.pw);
                } else if (this.len == ServerCnxn.wchpCmd) {
                    dt.dumpWatches(this.pw, true);
                } else {
                    dt.dumpWatches(this.pw, false);
                }
                this.pw.println();
            }
        }
    }

    private class ConsCommand
    extends CommandThread {
        public ConsCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                for (ServerCnxn c : ((NIOServerCnxn)NIOServerCnxn.this).factory.cnxns) {
                    c.dumpConnectionInfo(this.pw, false);
                    this.pw.println();
                }
                this.pw.println();
            }
        }
    }

    private class StatCommand
    extends CommandThread {
        int len;

        public StatCommand(PrintWriter pw, int len) {
            super(pw);
            this.len = len;
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                this.pw.print("Zookeeper version: ");
                this.pw.println(Version.getFullVersion());
                if (NIOServerCnxn.this.zkServer instanceof ReadOnlyZooKeeperServer) {
                    this.pw.println("READ-ONLY mode; serving only read-only clients");
                }
                if (this.len == ServerCnxn.statCmd) {
                    LOG.info("Stat command output");
                    this.pw.println("Clients:");
                    for (ServerCnxn c : ((NIOServerCnxn)NIOServerCnxn.this).factory.cnxns) {
                        c.dumpConnectionInfo(this.pw, true);
                        this.pw.println();
                    }
                    this.pw.println();
                }
                this.pw.print(NIOServerCnxn.this.zkServer.serverStats().toString());
                this.pw.print("Node count: ");
                this.pw.println(NIOServerCnxn.this.zkServer.getZKDatabase().getNodeCount());
            }
        }
    }

    private class DumpCommand
    extends CommandThread {
        public DumpCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                this.pw.println("SessionTracker dump:");
                ((NIOServerCnxn)NIOServerCnxn.this).zkServer.sessionTracker.dumpSessions(this.pw);
                this.pw.println("ephemeral nodes dump:");
                NIOServerCnxn.this.zkServer.dumpEphemerals(this.pw);
                this.pw.println("Connections dump:");
                NIOServerCnxn.this.factory.dumpConnections(this.pw);
            }
        }
    }

    private class CnxnStatResetCommand
    extends CommandThread {
        public CnxnStatResetCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                for (ServerCnxn c : ((NIOServerCnxn)NIOServerCnxn.this).factory.cnxns) {
                    c.resetStats();
                }
                this.pw.println("Connection stats reset.");
            }
        }
    }

    private class StatResetCommand
    extends CommandThread {
        public StatResetCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                NIOServerCnxn.this.zkServer.serverStats().reset();
                this.pw.println("Server stats reset.");
            }
        }
    }

    private class ConfCommand
    extends CommandThread {
        ConfCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                NIOServerCnxn.this.zkServer.dumpConf(this.pw);
            }
        }
    }

    private class EnvCommand
    extends CommandThread {
        EnvCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            List<Environment.Entry> env = Environment.list();
            this.pw.println("Environment:");
            for (Environment.Entry e : env) {
                this.pw.print(e.getKey());
                this.pw.print("=");
                this.pw.println(e.getValue());
            }
        }
    }

    private class SetTraceMaskCommand
    extends CommandThread {
        long trace;

        SetTraceMaskCommand(PrintWriter pw, long trace) {
            super(pw);
            this.trace = 0L;
            this.trace = trace;
        }

        public void commandRun() {
            this.pw.print(this.trace);
        }
    }

    private class TraceMaskCommand
    extends CommandThread {
        TraceMaskCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            long traceMask = ZooTrace.getTextTraceLevel();
            this.pw.print(traceMask);
        }
    }

    private class RuokCommand
    extends CommandThread {
        public RuokCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            this.pw.print("imok");
        }
    }

    private abstract class CommandThread {
        PrintWriter pw;

        CommandThread(PrintWriter pw) {
            this.pw = pw;
        }

        public void start() {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.commandRun();
                }
                catch (IOException ie) {
                    LOG.error("Error in running command ", (Throwable)ie);
                    Object var3_2 = null;
                    NIOServerCnxn.this.cleanupWriterSocket(this.pw);
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                NIOServerCnxn.this.cleanupWriterSocket(this.pw);
                throw throwable;
            }
            NIOServerCnxn.this.cleanupWriterSocket(this.pw);
        }

        public abstract void commandRun() throws IOException;
    }

    private class SendBufferWriter
    extends Writer {
        private StringBuffer sb = new StringBuffer();

        private SendBufferWriter() {
        }

        private void checkFlush(boolean force) {
            if (force && this.sb.length() > 0 || this.sb.length() > 2048) {
                NIOServerCnxn.this.sendBufferSync(ByteBuffer.wrap(this.sb.toString().getBytes()));
                this.sb.setLength(0);
            }
        }

        public void close() throws IOException {
            if (this.sb == null) {
                return;
            }
            this.checkFlush(true);
            this.sb = null;
        }

        public void flush() throws IOException {
            this.checkFlush(true);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.sb.append(cbuf, off, len);
            this.checkFlush(false);
        }
    }
}

