/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.zookeeper.Login;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.ConnectionBean;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.auth.SaslServerCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerCnxnFactory {
    public static final String ZOOKEEPER_SERVER_CNXN_FACTORY = "zookeeper.serverCnxnFactory";
    private static final Logger LOG = LoggerFactory.getLogger(ServerCnxnFactory.class);
    static final ByteBuffer closeConn = ByteBuffer.allocate(0);
    protected SaslServerCallbackHandler saslServerCallbackHandler;
    public Login login;
    protected ZooKeeperServer zkServer;
    private final ConcurrentHashMap<ServerCnxn, ConnectionBean> connectionBeans = new ConcurrentHashMap();
    protected final Set<ServerCnxn> cnxns = Collections.newSetFromMap(new ConcurrentHashMap());

    public abstract int getLocalPort();

    public abstract Iterable<ServerCnxn> getConnections();

    public int getNumAliveConnections() {
        return this.cnxns.size();
    }

    public ZooKeeperServer getZooKeeperServer() {
        return this.zkServer;
    }

    public abstract void closeSession(long var1);

    public abstract void configure(InetSocketAddress var1, int var2) throws IOException;

    public abstract void reconfigure(InetSocketAddress var1);

    public abstract int getMaxClientCnxnsPerHost();

    public abstract void setMaxClientCnxnsPerHost(int var1);

    public abstract void startup(ZooKeeperServer var1) throws IOException, InterruptedException;

    public abstract void join() throws InterruptedException;

    public abstract void shutdown();

    public abstract void start();

    public final void setZooKeeperServer(ZooKeeperServer zk) {
        this.zkServer = zk;
        if (zk != null) {
            zk.setServerCnxnFactory(this);
        }
    }

    public abstract void closeAll();

    public static ServerCnxnFactory createFactory() throws IOException {
        String serverCnxnFactoryName = System.getProperty(ZOOKEEPER_SERVER_CNXN_FACTORY);
        if (serverCnxnFactoryName == null) {
            serverCnxnFactoryName = NIOServerCnxnFactory.class.getName();
        }
        try {
            return (ServerCnxnFactory)Class.forName(serverCnxnFactoryName).newInstance();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Couldn't instantiate " + serverCnxnFactoryName);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static ServerCnxnFactory createFactory(int clientPort, int maxClientCnxns) throws IOException {
        return ServerCnxnFactory.createFactory(new InetSocketAddress(clientPort), maxClientCnxns);
    }

    public static ServerCnxnFactory createFactory(InetSocketAddress addr, int maxClientCnxns) throws IOException {
        ServerCnxnFactory factory = ServerCnxnFactory.createFactory();
        factory.configure(addr, maxClientCnxns);
        return factory;
    }

    public abstract InetSocketAddress getLocalAddress();

    public abstract void resetAllConnectionStats();

    public abstract Iterable<Map<String, Object>> getAllConnectionInfo(boolean var1);

    public void unregisterConnection(ServerCnxn serverCnxn) {
        ConnectionBean jmxConnectionBean = this.connectionBeans.remove(serverCnxn);
        if (jmxConnectionBean != null) {
            MBeanRegistry.getInstance().unregister(jmxConnectionBean);
        }
    }

    public void registerConnection(ServerCnxn serverCnxn) {
        if (this.zkServer != null) {
            ConnectionBean jmxConnectionBean = new ConnectionBean(serverCnxn, this.zkServer);
            try {
                MBeanRegistry.getInstance().register(jmxConnectionBean, this.zkServer.jmxServerBean);
                this.connectionBeans.put(serverCnxn, jmxConnectionBean);
            }
            catch (JMException e) {
                LOG.warn("Could not register connection", (Throwable)e);
            }
        }
    }

    protected void configureSaslLogin() throws IOException {
        String serverSection = System.getProperty("zookeeper.sasl.serverconfig", "Server");
        AppConfigurationEntry[] entries = null;
        SecurityException securityException = null;
        try {
            entries = Configuration.getConfiguration().getAppConfigurationEntry(serverSection);
        }
        catch (SecurityException e) {
            securityException = e;
        }
        if (entries == null) {
            String jaasFile = System.getProperty("java.security.auth.login.config");
            String loginContextName = System.getProperty("zookeeper.sasl.serverconfig");
            if (securityException != null && (loginContextName != null || jaasFile != null)) {
                String errorMessage = "No JAAS configuration section named '" + serverSection + "' was found";
                if (jaasFile != null) {
                    errorMessage = errorMessage + "in '" + jaasFile + "'.";
                }
                if (loginContextName != null) {
                    errorMessage = errorMessage + " But zookeeper.sasl.serverconfig was set.";
                }
                LOG.error(errorMessage);
                throw new IOException(errorMessage);
            }
            return;
        }
        try {
            this.saslServerCallbackHandler = new SaslServerCallbackHandler(Configuration.getConfiguration());
            this.login = new Login(serverSection, this.saslServerCallbackHandler);
            this.login.startThreadIfNeeded();
        }
        catch (LoginException e) {
            throw new IOException("Could not configure server because SASL configuration did not allow the  ZooKeeper server to authenticate itself properly: " + e);
        }
    }

    public static interface PacketProcessor {
        public void processPacket(ByteBuffer var1, ServerCnxn var2);
    }
}

