/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.TxnLogProposalIterator;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZKDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(ZKDatabase.class);
    protected DataTree dataTree;
    protected ConcurrentHashMap<Long, Integer> sessionsWithTimeouts;
    protected FileTxnSnapLog snapLog;
    protected long minCommittedLog;
    protected long maxCommittedLog;
    public static final String SNAPSHOT_SIZE_FACTOR = "zookeeper.snapshotSizeFactor";
    private double snapshotSizeFactor = 0.33;
    public static final int commitLogCount = 500;
    protected static int commitLogBuffer = 700;
    protected LinkedList<Leader.Proposal> committedLog = new LinkedList();
    protected ReentrantReadWriteLock logLock = new ReentrantReadWriteLock();
    private volatile boolean initialized = false;

    public ZKDatabase(FileTxnSnapLog snapLog) {
        this.dataTree = new DataTree();
        this.sessionsWithTimeouts = new ConcurrentHashMap();
        this.snapLog = snapLog;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.minCommittedLog = 0L;
        this.maxCommittedLog = 0L;
        this.dataTree = new DataTree();
        this.sessionsWithTimeouts.clear();
        ReentrantReadWriteLock.WriteLock lock = this.logLock.writeLock();
        try {
            lock.lock();
            this.committedLog.clear();
            Object var3_2 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
        this.initialized = false;
    }

    public DataTree getDataTree() {
        return this.dataTree;
    }

    public long getmaxCommittedLog() {
        return this.maxCommittedLog;
    }

    public long getminCommittedLog() {
        return this.minCommittedLog;
    }

    public ReentrantReadWriteLock getLogLock() {
        return this.logLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Leader.Proposal> getCommittedLog() {
        ReentrantReadWriteLock.ReadLock rl = this.logLock.readLock();
        if (this.logLock.getReadHoldCount() <= 0) {
            try {
                rl.lock();
                LinkedList<Leader.Proposal> linkedList = new LinkedList<Leader.Proposal>(this.committedLog);
                Object var4_3 = null;
                rl.unlock();
                return linkedList;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                rl.unlock();
                throw throwable;
            }
        }
        return this.committedLog;
    }

    public long getDataTreeLastProcessedZxid() {
        return this.dataTree.lastProcessedZxid;
    }

    public Collection<Long> getSessions() {
        return this.dataTree.getSessions();
    }

    public ConcurrentHashMap<Long, Integer> getSessionWithTimeOuts() {
        return this.sessionsWithTimeouts;
    }

    public long loadDataBase() throws IOException {
        FileTxnSnapLog.PlayBackListener listener = new FileTxnSnapLog.PlayBackListener(){

            public void onTxnLoaded(TxnHeader hdr, Record txn) {
                Request r = new Request(0L, hdr.getCxid(), hdr.getType(), hdr, txn, hdr.getZxid());
                ZKDatabase.this.addCommittedProposal(r);
            }
        };
        long zxid = this.snapLog.restore(this.dataTree, this.sessionsWithTimeouts, listener);
        this.initialized = true;
        return zxid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommittedProposal(Request request) {
        ReentrantReadWriteLock.WriteLock wl = this.logLock.writeLock();
        try {
            wl.lock();
            if (this.committedLog.size() > 500) {
                this.committedLog.removeFirst();
                this.minCommittedLog = this.committedLog.getFirst().packet.getZxid();
            }
            if (this.committedLog.isEmpty()) {
                this.minCommittedLog = request.zxid;
                this.maxCommittedLog = request.zxid;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
            try {
                request.getHdr().serialize(boa, "hdr");
                if (request.getTxn() != null) {
                    request.getTxn().serialize(boa, "txn");
                }
                baos.close();
            }
            catch (IOException e) {
                LOG.error("This really should be impossible", (Throwable)e);
            }
            QuorumPacket pp = new QuorumPacket(2, request.zxid, baos.toByteArray(), null);
            Leader.Proposal p = new Leader.Proposal();
            p.packet = pp;
            p.request = request;
            this.committedLog.add(p);
            this.maxCommittedLog = p.packet.getZxid();
            Object var8_8 = null;
            wl.unlock();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wl.unlock();
            throw throwable;
        }
    }

    public double getSnapshotSizeFactor() {
        return this.snapshotSizeFactor;
    }

    public long calculateTxnLogSizeLimit() {
        long snapSize = 0L;
        try {
            snapSize = this.snapLog.findMostRecentSnapshot().length();
        }
        catch (IOException e) {
            LOG.error("Unable to get size of most recent snapshot");
        }
        return (long)((double)snapSize * this.snapshotSizeFactor);
    }

    public Iterator<Leader.Proposal> getProposalsFromTxnLog(long startZxid, long sizeLimit) {
        if (sizeLimit < 0L) {
            LOG.debug("Negative size limit - retrieving proposal via txnlog is disabled");
            return TxnLogProposalIterator.EMPTY_ITERATOR;
        }
        TxnLog.TxnIterator itr = null;
        try {
            long txnSize;
            itr = this.snapLog.readTxnLog(startZxid, false);
            if (itr.getHeader() != null && itr.getHeader().getZxid() > startZxid) {
                LOG.warn("Unable to find proposals from txnlog for zxid: " + startZxid);
                itr.close();
                return TxnLogProposalIterator.EMPTY_ITERATOR;
            }
            if (sizeLimit > 0L && (txnSize = itr.getStorageSize()) > sizeLimit) {
                LOG.info("Txnlog size: " + txnSize + " exceeds sizeLimit: " + sizeLimit);
                itr.close();
                return TxnLogProposalIterator.EMPTY_ITERATOR;
            }
        }
        catch (IOException e) {
            LOG.error("Unable to read txnlog from disk", (Throwable)e);
            try {
                if (itr != null) {
                    itr.close();
                }
            }
            catch (IOException ioe) {
                LOG.warn("Error closing file iterator", (Throwable)ioe);
            }
            return TxnLogProposalIterator.EMPTY_ITERATOR;
        }
        return new TxnLogProposalIterator(itr);
    }

    public void removeCnxn(ServerCnxn cnxn) {
        this.dataTree.removeCnxn(cnxn);
    }

    public void killSession(long sessionId, long zxid) {
        this.dataTree.killSession(sessionId, zxid);
    }

    public void dumpEphemerals(PrintWriter pwriter) {
        this.dataTree.dumpEphemerals(pwriter);
    }

    public Map<Long, Set<String>> getEphemerals() {
        return this.dataTree.getEphemerals();
    }

    public int getNodeCount() {
        return this.dataTree.getNodeCount();
    }

    public Set<String> getEphemerals(long sessionId) {
        return this.dataTree.getEphemerals(sessionId);
    }

    public void setlastProcessedZxid(long zxid) {
        this.dataTree.lastProcessedZxid = zxid;
    }

    public DataTree.ProcessTxnResult processTxn(TxnHeader hdr, Record txn) {
        return this.dataTree.processTxn(hdr, txn);
    }

    public Stat statNode(String path, ServerCnxn serverCnxn) throws KeeperException.NoNodeException {
        return this.dataTree.statNode(path, serverCnxn);
    }

    public DataNode getNode(String path) {
        return this.dataTree.getNode(path);
    }

    public List<ACL> convertLong(Long aclL) {
        return this.dataTree.convertLong(aclL);
    }

    public byte[] getData(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        return this.dataTree.getData(path, stat, watcher);
    }

    public void setWatches(long relativeZxid, List<String> dataWatches, List<String> existWatches, List<String> childWatches, Watcher watcher) {
        this.dataTree.setWatches(relativeZxid, dataWatches, existWatches, childWatches, watcher);
    }

    public List<ACL> getACL(String path, Stat stat) throws KeeperException.NoNodeException {
        return this.dataTree.getACL(path, stat);
    }

    public List<String> getChildren(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        return this.dataTree.getChildren(path, stat, watcher);
    }

    public boolean isSpecialPath(String path) {
        return this.dataTree.isSpecialPath(path);
    }

    public int getAclSize() {
        return this.dataTree.getAclSize();
    }

    public boolean truncateLog(long zxid) throws IOException {
        this.clear();
        boolean truncated = this.snapLog.truncateLog(zxid);
        if (!truncated) {
            return false;
        }
        this.loadDataBase();
        return true;
    }

    public void deserializeSnapshot(InputArchive ia) throws IOException {
        this.clear();
        SerializeUtils.deserializeSnapshot(this.getDataTree(), ia, this.getSessionWithTimeOuts());
        this.initialized = true;
    }

    public void serializeSnapshot(OutputArchive oa) throws IOException, InterruptedException {
        SerializeUtils.serializeSnapshot(this.getDataTree(), oa, this.getSessionWithTimeOuts());
    }

    public boolean append(Request si) throws IOException {
        return this.snapLog.append(si);
    }

    public void rollLog() throws IOException {
        this.snapLog.rollLog();
    }

    public void commit() throws IOException {
        this.snapLog.commit();
    }

    public void close() throws IOException {
        this.snapLog.close();
    }

    public synchronized void initConfigInZKDatabase(QuorumVerifier qv) {
        if (qv == null) {
            return;
        }
        try {
            if (this.dataTree.getNode("/zookeeper/config") == null) {
                LOG.warn("configuration znode missing (hould only happen during upgrade), creating the node");
                this.dataTree.addConfigNode();
            }
            this.dataTree.setData("/zookeeper/config", qv.toString().getBytes(), -1, qv.getVersion(), System.currentTimeMillis());
        }
        catch (KeeperException.NoNodeException e) {
            System.out.println("configuration node missing - should not happen");
        }
    }

    public void setSnapshotSizeFactor(double snapshotSizeFactor) {
        this.snapshotSizeFactor = snapshotSizeFactor;
    }

    public boolean containsWatcher(String path, Watcher.WatcherType type, Watcher watcher) {
        return this.dataTree.containsWatcher(path, type, watcher);
    }

    public boolean removeWatch(String path, Watcher.WatcherType type, Watcher watcher) {
        return this.dataTree.removeWatch(path, type, watcher);
    }
}

