/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import javax.management.JMException;
import org.apache.zookeeper.jmx.ManagedUtil;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.admin.AdminServerFactory;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerMain {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServerMain.class);
    private static final String USAGE = "Usage: ZooKeeperServerMain configfile | port datadir [ticktime] [maxcnxns]";
    private ServerCnxnFactory cnxnFactory;
    private AdminServer adminServer;

    public static void main(String[] args) {
        ZooKeeperServerMain main = new ZooKeeperServerMain();
        try {
            main.initializeAndRun(args);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Invalid arguments, exiting abnormally", (Throwable)e);
            LOG.info(USAGE);
            System.err.println(USAGE);
            System.exit(2);
        }
        catch (QuorumPeerConfig.ConfigException e) {
            LOG.error("Invalid config, exiting abnormally", (Throwable)e);
            System.err.println("Invalid config, exiting abnormally");
            System.exit(2);
        }
        catch (FileTxnSnapLog.DatadirException e) {
            LOG.error("Unable to access datadir, exiting abnormally", (Throwable)e);
            System.err.println("Unable to access datadir, exiting abnormally");
            System.exit(3);
        }
        catch (AdminServer.AdminServerException e) {
            LOG.error("Unable to start AdminServer, exiting abnormally", (Throwable)e);
            System.err.println("Unable to start AdminServer, exiting abnormally");
            System.exit(4);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception, exiting abnormally", (Throwable)e);
            System.exit(1);
        }
        LOG.info("Exiting normally");
        System.exit(0);
    }

    protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException, AdminServer.AdminServerException {
        try {
            ManagedUtil.registerLog4jMBeans();
        }
        catch (JMException e) {
            LOG.warn("Unable to register log4j JMX control", (Throwable)e);
        }
        ServerConfig config = new ServerConfig();
        if (args.length == 1) {
            config.parse(args[0]);
        } else {
            config.parse(args);
        }
        this.runFromConfig(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runFromConfig(ServerConfig config) throws IOException, AdminServer.AdminServerException {
        LOG.info("Starting server");
        FileTxnSnapLog txnLog = null;
        try {
            block4: {
                try {
                    txnLog = new FileTxnSnapLog(config.dataLogDir, config.dataDir);
                    ZooKeeperServer zkServer = new ZooKeeperServer(txnLog, config.tickTime, config.minSessionTimeout, config.maxSessionTimeout, null);
                    this.adminServer = AdminServerFactory.createAdminServer();
                    this.adminServer.setZooKeeperServer(zkServer);
                    this.adminServer.start();
                    this.cnxnFactory = ServerCnxnFactory.createFactory();
                    this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
                    this.cnxnFactory.startup(zkServer);
                    this.cnxnFactory.join();
                    if (!zkServer.isRunning()) break block4;
                    zkServer.shutdown();
                }
                catch (InterruptedException e) {
                    LOG.warn("Server interrupted", (Throwable)e);
                    Object var5_6 = null;
                    if (txnLog == null) return;
                    txnLog.close();
                    return;
                }
            }
            Object var5_5 = null;
            if (txnLog == null) return;
            txnLog.close();
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (txnLog == null) throw throwable;
            txnLog.close();
            throw throwable;
        }
    }

    protected void shutdown() {
        this.cnxnFactory.shutdown();
        try {
            this.adminServer.shutdown();
        }
        catch (AdminServer.AdminServerException e) {
            LOG.warn("Problem stopping AdminServer", (Throwable)e);
        }
    }
}

