/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.admin.CommandResponse;
import org.apache.zookeeper.server.admin.Commands;
import org.apache.zookeeper.server.admin.JsonOutputter;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyAdminServer
implements AdminServer {
    static final Logger LOG = LoggerFactory.getLogger(JettyAdminServer.class);
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_COMMAND_URL = "/commands";
    private final Server server;
    private ZooKeeperServer zkServer;
    private final int port;
    private final String commandUrl;

    public JettyAdminServer() throws AdminServer.AdminServerException {
        this(Integer.getInteger("zookeeper.admin.serverPort", 8080), System.getProperty("zookeeper.admin.commandURL", DEFAULT_COMMAND_URL));
    }

    public JettyAdminServer(int port, String commandUrl) {
        this.port = port;
        this.commandUrl = commandUrl;
        this.server = new Server(port);
        Context context = new Context((HandlerContainer)this.server, "/");
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new CommandServlet()), commandUrl + "/*");
    }

    @Override
    public void start() throws AdminServer.AdminServerException {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new AdminServer.AdminServerException(String.format("Problem starting AdminServer on port %d, command URL %s", this.port, this.commandUrl), e);
        }
        LOG.info(String.format("Started AdminServer on port %d, command URL %s", this.port, this.commandUrl));
    }

    @Override
    public void shutdown() throws AdminServer.AdminServerException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new AdminServer.AdminServerException(String.format("Problem stopping AdminServer on port %d, command URL %s", this.port, this.commandUrl), e);
        }
    }

    @Override
    public void setZooKeeperServer(ZooKeeperServer zkServer) {
        this.zkServer = zkServer;
    }

    private List<String> commandLinks() {
        ArrayList<String> links = new ArrayList<String>();
        ArrayList<String> commands = new ArrayList<String>(Commands.getPrimaryNames());
        Collections.sort(commands);
        for (String command : commands) {
            String url = this.commandUrl + "/" + command;
            links.add(String.format("<a href=\"%s\">%s</a>", url, command));
        }
        return links;
    }

    private class CommandServlet
    extends HttpServlet {
        private CommandServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String cmd = request.getPathInfo();
            if (cmd == null || cmd.equals("/")) {
                for (String link : JettyAdminServer.this.commandLinks()) {
                    response.getWriter().println(link);
                    response.getWriter().println("<br />");
                }
                return;
            }
            cmd = cmd.substring(1);
            Map parameterMap = request.getParameterMap();
            HashMap<String, String> kwargs = new HashMap<String, String>();
            for (Map.Entry entry : parameterMap.entrySet()) {
                kwargs.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
            CommandResponse cmdResponse = Commands.runCommand(cmd, JettyAdminServer.this.zkServer, kwargs);
            JsonOutputter outputter = new JsonOutputter();
            response.setStatus(200);
            response.setContentType(outputter.getContentType());
            outputter.output(cmdResponse, response.getWriter());
        }
    }
}

