/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.zookeeper.server.admin.CommandOutputter;
import org.apache.zookeeper.server.admin.CommandResponse;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonOutputter
implements CommandOutputter {
    static final Logger LOG = LoggerFactory.getLogger(JsonOutputter.class);
    public static final String ERROR_RESPONSE = "{\"error\": \"Exception writing command response to JSON\"}";
    private ObjectMapper mapper = new ObjectMapper();

    public JsonOutputter() {
        this.mapper.configure(SerializationConfig.Feature.WRITE_ENUMS_USING_TO_STRING, true);
        this.mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    }

    public String getContentType() {
        return "application/json";
    }

    public void output(CommandResponse response, PrintWriter pw) {
        try {
            this.mapper.writeValue((Writer)pw, response.toMap());
        }
        catch (JsonGenerationException e) {
            LOG.warn("Exception writing command response to JSON:", (Throwable)e);
            pw.write(ERROR_RESPONSE);
        }
        catch (JsonMappingException e) {
            LOG.warn("Exception writing command response to JSON:", (Throwable)e);
            pw.write(ERROR_RESPONSE);
        }
        catch (IOException e) {
            LOG.warn("Exception writing command response to JSON:", (Throwable)e);
            pw.write(ERROR_RESPONSE);
        }
    }
}

