/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import org.apache.zookeeper.common.HostNameUtils;
import org.apache.zookeeper.server.quorum.LocalPeerMXBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.ServerBean;

public class LocalPeerBean
extends ServerBean
implements LocalPeerMXBean {
    private final QuorumPeer peer;

    public LocalPeerBean(QuorumPeer peer) {
        this.peer = peer;
    }

    public String getName() {
        return "replica." + this.peer.getId();
    }

    public boolean isHidden() {
        return false;
    }

    public int getTickTime() {
        return this.peer.getTickTime();
    }

    public int getMaxClientCnxnsPerHost() {
        return this.peer.getMaxClientCnxnsPerHost();
    }

    public int getMinSessionTimeout() {
        return this.peer.getMinSessionTimeout();
    }

    public int getMaxSessionTimeout() {
        return this.peer.getMaxSessionTimeout();
    }

    public int getInitLimit() {
        return this.peer.getInitLimit();
    }

    public int getSyncLimit() {
        return this.peer.getSyncLimit();
    }

    public int getTick() {
        return this.peer.getTick();
    }

    public String getState() {
        return this.peer.getState().toString();
    }

    public String getQuorumAddress() {
        return this.peer.getQuorumAddress().toString();
    }

    public int getElectionType() {
        return this.peer.getElectionType();
    }

    public String getElectionAddress() {
        return HostNameUtils.getHostString(this.peer.getElectionAddress()) + ":" + this.peer.getElectionAddress().getPort();
    }

    public String getClientAddress() {
        return HostNameUtils.getHostString(this.peer.getClientAddress()) + ":" + this.peer.getClientAddress().getPort();
    }

    public String getLearnerType() {
        return this.peer.getLearnerType().toString();
    }

    public long getConfigVersion() {
        return this.peer.getQuorumVerifier().getVersion();
    }

    public String getQuorumSystemInfo() {
        return this.peer.getQuorumVerifier().toString();
    }

    public boolean isPartOfEnsemble() {
        return this.peer.getView().containsKey(this.peer.getId());
    }
}

