/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.common.AtomicFileWritingIdiom;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.VerifyingFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuorumPeerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumPeerConfig.class);
    private static boolean standaloneEnabled = true;
    protected InetSocketAddress clientPortAddress;
    protected File dataDir;
    protected File dataLogDir;
    protected boolean configBackwardCompatibilityMode = false;
    protected String dynamicConfigFileStr = null;
    protected String configFileStr = null;
    protected int tickTime = 3000;
    protected int maxClientCnxns = 60;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected boolean localSessionsEnabled = false;
    protected boolean localSessionsUpgradingEnabled = false;
    protected int initLimit;
    protected int syncLimit;
    protected int electionAlg = 3;
    protected int electionPort = 2182;
    protected boolean quorumListenOnAllIPs = false;
    protected long serverId;
    protected QuorumVerifier quorumVerifier = null;
    protected QuorumVerifier lastSeenQuorumVerifier = null;
    protected int snapRetainCount = 3;
    protected int purgeInterval = 0;
    protected boolean syncEnabled = true;
    protected QuorumPeer.LearnerType peerType = QuorumPeer.LearnerType.PARTICIPANT;
    private final int MIN_SNAP_RETAIN_COUNT = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String path) throws ConfigException {
        LOG.info("Reading configuration from: " + path);
        try {
            File configFile = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().create(path);
            Properties cfg = new Properties();
            FileInputStream in = new FileInputStream(configFile);
            try {
                cfg.load(in);
                this.configFileStr = path;
                Object var6_10 = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                in.close();
                throw throwable;
            }
            in.close();
            this.parseProperties(cfg);
        }
        catch (IOException e) {
            throw new ConfigException("Error processing " + path, e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Error processing " + path, e);
        }
        if (this.dynamicConfigFileStr != null) {
            try {
                Properties dynamicCfg = new Properties();
                FileInputStream inConfig = new FileInputStream(this.dynamicConfigFileStr);
                try {
                    dynamicCfg.load(inConfig);
                    Object var8_14 = null;
                }
                catch (Throwable throwable) {
                    Object var8_15 = null;
                    inConfig.close();
                    throw throwable;
                }
                inConfig.close();
                this.quorumVerifier = QuorumPeerConfig.parseDynamicConfig(dynamicCfg, this.electionAlg, true, this.configBackwardCompatibilityMode);
                this.checkValidity();
            }
            catch (IOException e) {
                throw new ConfigException("Error processing " + this.dynamicConfigFileStr, e);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException("Error processing " + this.dynamicConfigFileStr, e);
            }
            File nextDynamicConfigFile = new File(this.dynamicConfigFileStr + ".next");
            if (nextDynamicConfigFile.exists()) {
                try {
                    Properties dynamicConfigNextCfg = new Properties();
                    FileInputStream inConfigNext = new FileInputStream(nextDynamicConfigFile);
                    try {
                        dynamicConfigNextCfg.load(inConfigNext);
                        Object var10_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_19 = null;
                        inConfigNext.close();
                        throw throwable;
                    }
                    inConfigNext.close();
                    boolean isHierarchical = false;
                    for (Map.Entry<Object, Object> entry : dynamicConfigNextCfg.entrySet()) {
                        String key = entry.getKey().toString().trim();
                        if (!key.startsWith("group") && !key.startsWith("weight")) continue;
                        isHierarchical = true;
                        break;
                    }
                    this.lastSeenQuorumVerifier = QuorumPeerConfig.createQuorumVerifier(dynamicConfigNextCfg, isHierarchical);
                }
                catch (IOException e) {
                    LOG.warn("NextQuorumVerifier is initiated to null");
                }
            }
        }
    }

    public void parseProperties(Properties zkProp) throws IOException, ConfigException {
        int clientPort = 0;
        String clientPortAddress = null;
        VerifyingFileFactory vff = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().build();
        for (Map.Entry<Object, Object> entry : zkProp.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (key.equals("dataDir")) {
                this.dataDir = vff.create(value);
                continue;
            }
            if (key.equals("dataLogDir")) {
                this.dataLogDir = vff.create(value);
                continue;
            }
            if (key.equals("clientPort")) {
                clientPort = Integer.parseInt(value);
                continue;
            }
            if (key.equals("localSessionsEnabled")) {
                this.localSessionsEnabled = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("localSessionsUpgradingEnabled")) {
                this.localSessionsUpgradingEnabled = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("clientPortAddress")) {
                clientPortAddress = value.trim();
                continue;
            }
            if (key.equals("tickTime")) {
                this.tickTime = Integer.parseInt(value);
                continue;
            }
            if (key.equals("maxClientCnxns")) {
                this.maxClientCnxns = Integer.parseInt(value);
                continue;
            }
            if (key.equals("minSessionTimeout")) {
                this.minSessionTimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("maxSessionTimeout")) {
                this.maxSessionTimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("initLimit")) {
                this.initLimit = Integer.parseInt(value);
                continue;
            }
            if (key.equals("syncLimit")) {
                this.syncLimit = Integer.parseInt(value);
                continue;
            }
            if (key.equals("electionAlg")) {
                this.electionAlg = Integer.parseInt(value);
                continue;
            }
            if (key.equals("quorumListenOnAllIPs")) {
                this.quorumListenOnAllIPs = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("peerType")) {
                if (value.toLowerCase().equals("observer")) {
                    this.peerType = QuorumPeer.LearnerType.OBSERVER;
                    continue;
                }
                if (value.toLowerCase().equals("participant")) {
                    this.peerType = QuorumPeer.LearnerType.PARTICIPANT;
                    continue;
                }
                throw new ConfigException("Unrecognised peertype: " + value);
            }
            if (key.equals("syncEnabled")) {
                this.syncEnabled = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("dynamicConfigFile")) {
                this.dynamicConfigFileStr = value;
                continue;
            }
            if (key.equals("autopurge.snapRetainCount")) {
                this.snapRetainCount = Integer.parseInt(value);
                continue;
            }
            if (key.equals("autopurge.purgeInterval")) {
                this.purgeInterval = Integer.parseInt(value);
                continue;
            }
            if (key.equals("standaloneEnabled")) {
                if (value.toLowerCase().equals("true")) {
                    QuorumPeerConfig.setStandaloneEnabled(true);
                    continue;
                }
                if (value.toLowerCase().equals("false")) {
                    QuorumPeerConfig.setStandaloneEnabled(false);
                    continue;
                }
                throw new ConfigException("Invalid option for standalone mode. Choose 'true' or 'false.'");
            }
            if ((key.startsWith("server.") || key.startsWith("group") || key.startsWith("weight")) && zkProp.containsKey("dynamicConfigFile")) {
                throw new ConfigException("parameter: " + key + " must be in a separate dynamic config file");
            }
            System.setProperty("zookeeper." + key, value);
        }
        if (this.snapRetainCount < 3) {
            LOG.warn("Invalid autopurge.snapRetainCount: " + this.snapRetainCount + ". Defaulting to " + 3);
            this.snapRetainCount = 3;
        }
        if (this.dataDir == null) {
            throw new IllegalArgumentException("dataDir is not set");
        }
        if (this.dataLogDir == null) {
            this.dataLogDir = this.dataDir;
        }
        if (clientPortAddress != null) {
            if (clientPort == 0) {
                throw new IllegalArgumentException("clientPortAddress is set but clientPort is not set");
            }
            this.clientPortAddress = new InetSocketAddress(InetAddress.getByName(clientPortAddress), clientPort);
        } else if (clientPort != 0) {
            this.clientPortAddress = new InetSocketAddress(clientPort);
        }
        if (this.tickTime == 0) {
            throw new IllegalArgumentException("tickTime is not set");
        }
        this.minSessionTimeout = this.minSessionTimeout == -1 ? this.tickTime * 2 : this.minSessionTimeout;
        int n = this.maxSessionTimeout = this.maxSessionTimeout == -1 ? this.tickTime * 20 : this.maxSessionTimeout;
        if (this.minSessionTimeout > this.maxSessionTimeout) {
            throw new IllegalArgumentException("minSessionTimeout must not be larger than maxSessionTimeout");
        }
        if (this.dynamicConfigFileStr == null) {
            this.configBackwardCompatibilityMode = true;
            this.quorumVerifier = QuorumPeerConfig.parseDynamicConfig(zkProp, this.electionAlg, true, this.configBackwardCompatibilityMode);
            this.checkValidity();
        }
    }

    public static void writeDynamicConfig(String dynamicConfigFilename, String configFileStr, boolean configBackwardCompatibilityMode, final QuorumVerifier qv, boolean needEraseStaticClientInfo) throws IOException {
        String actualDynamicConfigFilename = dynamicConfigFilename;
        new AtomicFileWritingIdiom(new File(actualDynamicConfigFilename), new AtomicFileWritingIdiom.OutputStreamStatement(){

            public void write(OutputStream outConfig) throws IOException {
                byte[] b = qv.toString().getBytes();
                outConfig.write(b);
            }
        });
        if (!configBackwardCompatibilityMode && !needEraseStaticClientInfo) {
            return;
        }
        QuorumPeerConfig.editStaticConfig(configFileStr, actualDynamicConfigFilename, configBackwardCompatibilityMode, needEraseStaticClientInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void editStaticConfig(String configFileStr, final String dynamicFileStr, final boolean backwardCompatible, final boolean eraseClientPortAddress) throws IOException {
        if (configFileStr == null) {
            return;
        }
        File configFile = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().create(configFileStr);
        final Properties cfg = new Properties();
        FileInputStream in = new FileInputStream(configFile);
        try {
            cfg.load(in);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            in.close();
            throw throwable;
        }
        in.close();
        new AtomicFileWritingIdiom(new File(configFileStr), new AtomicFileWritingIdiom.WriterStatement(){

            public void write(Writer out) throws IOException {
                for (Map.Entry<Object, Object> entry : cfg.entrySet()) {
                    String key = entry.getKey().toString().trim();
                    if (key.startsWith("server.") || key.startsWith("group") || key.startsWith("weight") || eraseClientPortAddress && (key.startsWith("clientPort") || key.startsWith("clientPortAddress"))) continue;
                    String value = entry.getValue().toString().trim();
                    out.write(key.concat("=").concat(value).concat("\n"));
                }
                if (!backwardCompatible) {
                    return;
                }
                out.write("dynamicConfigFile=".concat(dynamicFileStr).concat("\n"));
            }
        });
    }

    public static void deleteFile(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            try {
                f.delete();
            }
            catch (Exception e) {
                LOG.warn("deleting " + filename + " failed");
            }
        }
    }

    private static QuorumVerifier createQuorumVerifier(Properties dynamicConfigProp, boolean isHierarchical) throws ConfigException {
        if (isHierarchical) {
            return new QuorumHierarchical(dynamicConfigProp);
        }
        return new QuorumMaj(dynamicConfigProp);
    }

    public static QuorumVerifier parseDynamicConfig(Properties dynamicConfigProp, int eAlg, boolean warnings, boolean configBackwardCompatibilityMode) throws IOException, ConfigException {
        boolean isHierarchical = false;
        for (Map.Entry<Object, Object> entry : dynamicConfigProp.entrySet()) {
            String key = entry.getKey().toString().trim();
            if (key.startsWith("group") || key.startsWith("weight")) {
                isHierarchical = true;
                continue;
            }
            if (configBackwardCompatibilityMode || key.startsWith("server.") || key.equals("version")) continue;
            LOG.info(dynamicConfigProp.toString());
            throw new ConfigException("Unrecognised parameter: " + key);
        }
        QuorumVerifier qv = QuorumPeerConfig.createQuorumVerifier(dynamicConfigProp, isHierarchical);
        int numParticipators = qv.getVotingMembers().size();
        int numObservers = qv.getObservingMembers().size();
        if (numParticipators == 0) {
            if (numObservers > 0) {
                throw new IllegalArgumentException("Observers w/o participants is an invalid configuration");
            }
        } else if (numParticipators == 1 && standaloneEnabled) {
            LOG.error("Invalid configuration, only one server specified (ignoring)");
            if (numObservers > 0) {
                throw new IllegalArgumentException("Observers w/o quorum is an invalid configuration");
            }
        } else {
            if (warnings) {
                if (numParticipators <= 2) {
                    LOG.warn("No server failure will be tolerated. You need at least 3 servers.");
                } else if (numParticipators % 2 == 0) {
                    LOG.warn("Non-optimial configuration, consider an odd number of servers.");
                }
            }
            if (eAlg != 0) {
                for (QuorumPeer.QuorumServer s : qv.getVotingMembers().values()) {
                    if (s.electionAddr != null) continue;
                    throw new IllegalArgumentException("Missing election port for server: " + s.id);
                }
            }
        }
        return qv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkValidity() throws IOException, ConfigException {
        int numMembers = this.quorumVerifier.getVotingMembers().size();
        if (numMembers > 1 || !standaloneEnabled && numMembers > 0) {
            QuorumPeer.LearnerType roleByServersList;
            String myIdString;
            if (this.initLimit == 0) {
                throw new IllegalArgumentException("initLimit is not set");
            }
            if (this.syncLimit == 0) {
                throw new IllegalArgumentException("syncLimit is not set");
            }
            File myIdFile = new File(this.dataDir, "myid");
            if (!myIdFile.exists()) {
                throw new IllegalArgumentException(myIdFile.toString() + " file is missing");
            }
            BufferedReader br = new BufferedReader(new FileReader(myIdFile));
            try {
                myIdString = br.readLine();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                br.close();
                throw throwable;
            }
            br.close();
            try {
                this.serverId = Long.parseLong(myIdString);
                MDC.put((String)"myid", (String)myIdString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("serverid " + myIdString + " is not a number");
            }
            QuorumPeer.QuorumServer qs = this.quorumVerifier.getAllMembers().get(this.serverId);
            if (this.clientPortAddress != null && qs != null && qs.clientAddr != null) {
                if (!this.clientPortAddress.getAddress().isAnyLocalAddress() && !this.clientPortAddress.equals(qs.clientAddr) || this.clientPortAddress.getAddress().isAnyLocalAddress() && this.clientPortAddress.getPort() != qs.clientAddr.getPort()) {
                    throw new ConfigException("client address for this server (id = " + this.serverId + ") in static config file is " + this.clientPortAddress + " is different from client address found in dynamic file: " + qs.clientAddr);
                }
                QuorumPeerConfig.editStaticConfig(this.configFileStr, null, false, true);
            }
            if (qs != null && qs.clientAddr != null) {
                this.clientPortAddress = qs.clientAddr;
            }
            QuorumPeer.LearnerType learnerType = roleByServersList = this.quorumVerifier.getObservingMembers().containsKey(this.serverId) ? QuorumPeer.LearnerType.OBSERVER : QuorumPeer.LearnerType.PARTICIPANT;
            if (roleByServersList != this.peerType) {
                LOG.warn("Peer type from servers list (" + (Object)((Object)roleByServersList) + ") doesn't match peerType (" + (Object)((Object)this.peerType) + "). Defaulting to servers list.");
                this.peerType = roleByServersList;
            }
        }
    }

    public InetSocketAddress getClientPortAddress() {
        return this.clientPortAddress;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getDataLogDir() {
        return this.dataLogDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public boolean areLocalSessionsEnabled() {
        return this.localSessionsEnabled;
    }

    public boolean isLocalSessionsUpgradingEnabled() {
        return this.localSessionsUpgradingEnabled;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public int getSyncLimit() {
        return this.syncLimit;
    }

    public int getElectionAlg() {
        return this.electionAlg;
    }

    public int getElectionPort() {
        return this.electionPort;
    }

    public int getSnapRetainCount() {
        return this.snapRetainCount;
    }

    public int getPurgeInterval() {
        return this.purgeInterval;
    }

    public boolean getSyncEnabled() {
        return this.syncEnabled;
    }

    public QuorumVerifier getQuorumVerifier() {
        return this.quorumVerifier;
    }

    public QuorumVerifier getLastSeenQuorumVerifier() {
        return this.lastSeenQuorumVerifier;
    }

    public Map<Long, QuorumPeer.QuorumServer> getServers() {
        return Collections.unmodifiableMap(this.quorumVerifier.getAllMembers());
    }

    public long getServerId() {
        return this.serverId;
    }

    public boolean isDistributed() {
        return this.quorumVerifier != null && (!standaloneEnabled || this.quorumVerifier.getVotingMembers().size() > 1);
    }

    public QuorumPeer.LearnerType getPeerType() {
        return this.peerType;
    }

    public String getDynamicConfigFilename() {
        return this.dynamicConfigFileStr;
    }

    public String getConfigFilename() {
        return this.configFileStr;
    }

    public boolean getConfigBackwardCompatibility() {
        return this.configBackwardCompatibilityMode;
    }

    public Boolean getQuorumListenOnAllIPs() {
        return this.quorumListenOnAllIPs;
    }

    public static boolean isStandaloneEnabled() {
        return standaloneEnabled;
    }

    public static void setStandaloneEnabled(boolean enabled) {
        standaloneEnabled = enabled;
    }

    public static class ConfigException
    extends Exception {
        public ConfigException(String msg) {
            super(msg);
        }

        public ConfigException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

