/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.cli.ParseException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public abstract class CliCommand {
    protected ZooKeeper zk;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    private String cmdStr;
    private String optionStr;

    public CliCommand(String cmdStr, String optionStr) {
        this.cmdStr = cmdStr;
        this.optionStr = optionStr;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public void setZk(ZooKeeper zk) {
        this.zk = zk;
    }

    public String getCmdStr() {
        return this.cmdStr;
    }

    public String getOptionStr() {
        return this.optionStr;
    }

    public String getUsageStr() {
        return this.cmdStr + " " + this.optionStr;
    }

    public void addToMap(Map<String, CliCommand> cmdMap) {
        cmdMap.put(this.cmdStr, this);
    }

    public abstract CliCommand parse(String[] var1) throws ParseException;

    public abstract boolean exec() throws KeeperException, IOException, InterruptedException;
}

