/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.Stat;

public class StatCommand
extends CliCommand {
    private static final Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public StatCommand() {
        super("stat", "[-w] path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        this.cl = parser.parse(options, cmdArgs);
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new ParseException(this.getUsageStr());
        }
        this.retainCompatibility(cmdArgs);
        return this;
    }

    private void retainCompatibility(String[] cmdArgs) throws ParseException {
        if (this.args.length > 2) {
            cmdArgs[2] = "-w";
            this.err.println("'stat path [watch]' has been deprecated. Please use 'stat [-w] path' instead.");
            PosixParser parser = new PosixParser();
            this.cl = parser.parse(options, cmdArgs);
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws KeeperException, InterruptedException {
        String path = this.args[1];
        boolean watch = this.cl.hasOption("w");
        Stat stat = this.zk.exists(path, watch);
        if (stat == null) {
            throw new KeeperException.NoNodeException(path);
        }
        new StatPrinter(this.out).print(stat);
        return watch;
    }

    static {
        options.addOption("w", false, "watch");
    }
}

