/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.FileKeyStoreLoader;
import org.apache.zookeeper.common.FileKeyStoreLoaderBuilderProvider;
import org.apache.zookeeper.common.JKSFileLoader;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.zookeeper.common.PEMFileLoader;
import org.apache.zookeeper.common.PKCS12FileLoader;
import org.junit.Assert;
import org.junit.Test;

public class FileKeyStoreLoaderBuilderProviderTest
extends ZKTestCase {
    @Test
    public void testGetBuilderForJKSFileType() {
        FileKeyStoreLoader.Builder builder = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType((KeyStoreFileType)KeyStoreFileType.JKS);
        Assert.assertTrue((boolean)(builder instanceof JKSFileLoader.Builder));
    }

    @Test
    public void testGetBuilderForPEMFileType() {
        FileKeyStoreLoader.Builder builder = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType((KeyStoreFileType)KeyStoreFileType.PEM);
        Assert.assertTrue((boolean)(builder instanceof PEMFileLoader.Builder));
    }

    @Test
    public void testGetBuilderForPKCS12FileType() {
        FileKeyStoreLoader.Builder builder = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType((KeyStoreFileType)KeyStoreFileType.PKCS12);
        Assert.assertTrue((boolean)(builder instanceof PKCS12FileLoader.Builder));
    }

    @Test(expected=NullPointerException.class)
    public void testGetBuilderForNullFileType() {
        FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(null);
    }
}

