/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.junit.Assert;
import org.junit.Test;

public class KeyStoreFileTypeTest
extends ZKTestCase {
    @Test
    public void testGetPropertyValue() {
        Assert.assertEquals((Object)"PEM", (Object)KeyStoreFileType.PEM.getPropertyValue());
        Assert.assertEquals((Object)"JKS", (Object)KeyStoreFileType.JKS.getPropertyValue());
        Assert.assertEquals((Object)"PKCS12", (Object)KeyStoreFileType.PKCS12.getPropertyValue());
        Assert.assertEquals((Object)"BCFKS", (Object)KeyStoreFileType.BCFKS.getPropertyValue());
    }

    @Test
    public void testFromPropertyValue() {
        Assert.assertEquals((Object)KeyStoreFileType.PEM, (Object)KeyStoreFileType.fromPropertyValue((String)"PEM"));
        Assert.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromPropertyValue((String)"JKS"));
        Assert.assertEquals((Object)KeyStoreFileType.PKCS12, (Object)KeyStoreFileType.fromPropertyValue((String)"PKCS12"));
        Assert.assertEquals((Object)KeyStoreFileType.BCFKS, (Object)KeyStoreFileType.fromPropertyValue((String)"BCFKS"));
        Assert.assertNull((Object)KeyStoreFileType.fromPropertyValue((String)""));
        Assert.assertNull((Object)KeyStoreFileType.fromPropertyValue(null));
    }

    @Test
    public void testFromPropertyValueIgnoresCase() {
        Assert.assertEquals((Object)KeyStoreFileType.PEM, (Object)KeyStoreFileType.fromPropertyValue((String)"pem"));
        Assert.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromPropertyValue((String)"jks"));
        Assert.assertEquals((Object)KeyStoreFileType.PKCS12, (Object)KeyStoreFileType.fromPropertyValue((String)"pkcs12"));
        Assert.assertEquals((Object)KeyStoreFileType.BCFKS, (Object)KeyStoreFileType.fromPropertyValue((String)"bcfks"));
        Assert.assertNull((Object)KeyStoreFileType.fromPropertyValue((String)""));
        Assert.assertNull((Object)KeyStoreFileType.fromPropertyValue(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromPropertyValueThrowsOnBadPropertyValue() {
        KeyStoreFileType.fromPropertyValue((String)"foobar");
    }

    @Test
    public void testFromFilename() {
        Assert.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromFilename((String)"mykey.jks"));
        Assert.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromFilename((String)"/path/to/key/dir/mykey.jks"));
        Assert.assertEquals((Object)KeyStoreFileType.PEM, (Object)KeyStoreFileType.fromFilename((String)"mykey.pem"));
        Assert.assertEquals((Object)KeyStoreFileType.PEM, (Object)KeyStoreFileType.fromFilename((String)"/path/to/key/dir/mykey.pem"));
        Assert.assertEquals((Object)KeyStoreFileType.PKCS12, (Object)KeyStoreFileType.fromFilename((String)"mykey.p12"));
        Assert.assertEquals((Object)KeyStoreFileType.PKCS12, (Object)KeyStoreFileType.fromFilename((String)"/path/to/key/dir/mykey.p12"));
        Assert.assertEquals((Object)KeyStoreFileType.BCFKS, (Object)KeyStoreFileType.fromFilename((String)"mykey.bcfks"));
        Assert.assertEquals((Object)KeyStoreFileType.BCFKS, (Object)KeyStoreFileType.fromFilename((String)"/path/to/key/dir/mykey.bcfks"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromFilenameThrowsOnBadFileExtension() {
        KeyStoreFileType.fromFilename((String)"prod.key");
    }

    @Test
    public void testFromPropertyValueOrFileName() {
        Assert.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromPropertyValueOrFileName((String)"JKS", (String)"prod.key"));
        Assert.assertEquals((Object)KeyStoreFileType.PEM, (Object)KeyStoreFileType.fromPropertyValueOrFileName((String)"PEM", (String)"prod.key"));
        Assert.assertEquals((Object)KeyStoreFileType.PKCS12, (Object)KeyStoreFileType.fromPropertyValueOrFileName((String)"PKCS12", (String)"prod.key"));
        Assert.assertEquals((Object)KeyStoreFileType.BCFKS, (Object)KeyStoreFileType.fromPropertyValueOrFileName((String)"BCFKS", (String)"prod.key"));
        Assert.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromPropertyValueOrFileName((String)"", (String)"prod.jks"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromPropertyValueOrFileNameThrowsOnBadPropertyValue() {
        KeyStoreFileType.fromPropertyValueOrFileName((String)"foobar", (String)"prod.jks");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromPropertyValueOrFileNameThrowsOnBadFileExtension() {
        KeyStoreFileType.fromPropertyValueOrFileName((String)"", (String)"prod.key");
    }
}

