/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.net.InetSocketAddress;
import org.apache.zookeeper.server.quorum.MultipleAddresses;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.RemotePeerBean;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RemotePeerBeanTest {
    @Test
    public void testGetClientAddressShouldReturnEmptyStringWhenClientAddressIsNull() {
        InetSocketAddress peerCommunicationAddress = null;
        QuorumPeer.QuorumServer peer = new QuorumPeer.QuorumServer(1L, peerCommunicationAddress);
        RemotePeerBean remotePeerBean = new RemotePeerBean(null, peer);
        String clientAddress = remotePeerBean.getClientAddress();
        Assert.assertNotNull((Object)clientAddress);
        Assert.assertEquals((long)0L, (long)clientAddress.length());
    }

    @Test
    public void testIsLeader() {
        long peerId = 7L;
        QuorumPeer.QuorumServer quorumServerMock = (QuorumPeer.QuorumServer)Mockito.mock(QuorumPeer.QuorumServer.class);
        Mockito.when((Object)quorumServerMock.getId()).thenReturn((Object)peerId);
        QuorumPeer peerMock = (QuorumPeer)Mockito.mock(QuorumPeer.class);
        RemotePeerBean remotePeerBean = new RemotePeerBean(peerMock, quorumServerMock);
        Mockito.when((Object)peerMock.isLeader(ArgumentMatchers.eq((long)peerId))).thenReturn((Object)true);
        Assert.assertTrue((boolean)remotePeerBean.isLeader());
        Mockito.when((Object)peerMock.isLeader(ArgumentMatchers.eq((long)peerId))).thenReturn((Object)false);
        Assert.assertFalse((boolean)remotePeerBean.isLeader());
    }

    @Test
    public void testHostPortReturnedWhenIPIsIPV6() {
        QuorumPeer.QuorumServer quorumServerMock = (QuorumPeer.QuorumServer)Mockito.mock(QuorumPeer.QuorumServer.class);
        InetSocketAddress address = new InetSocketAddress("127::1", 2181);
        MultipleAddresses multipleAddresses = new MultipleAddresses(address);
        quorumServerMock.clientAddr = address;
        quorumServerMock.electionAddr = multipleAddresses;
        quorumServerMock.addr = multipleAddresses;
        QuorumPeer peerMock = (QuorumPeer)Mockito.mock(QuorumPeer.class);
        RemotePeerBean remotePeerBean = new RemotePeerBean(peerMock, quorumServerMock);
        String expectedHostPort = "[127:0:0:0:0:0:0:1]:2181";
        Assert.assertEquals((Object)expectedHostPort, (Object)remotePeerBean.getClientAddress());
        Assert.assertEquals((Object)expectedHostPort, (Object)remotePeerBean.getElectionAddress());
        Assert.assertEquals((Object)expectedHostPort, (Object)remotePeerBean.getQuorumAddress());
    }
}

