/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepRequestProcessorMetricsTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(PrepRequestProcessorMetricsTest.class);
    ZooKeeperServer zks;
    RequestProcessor nextProcessor;

    @BeforeEach
    public void setup() {
        System.setProperty("zookeeper.skipACL", "true");
        this.zks = (ZooKeeperServer)Mockito.spy((Object)new ZooKeeperServer());
        this.zks.sessionTracker = (SessionTracker)Mockito.mock(SessionTracker.class);
        ZKDatabase db = (ZKDatabase)Mockito.mock(ZKDatabase.class);
        Mockito.when((Object)this.zks.getZKDatabase()).thenReturn((Object)db);
        DataNode node = new DataNode(new byte[1], null, (StatPersisted)Mockito.mock(StatPersisted.class));
        Mockito.when((Object)db.getNode(ArgumentMatchers.anyString())).thenReturn((Object)node);
        DataTree dataTree = (DataTree)Mockito.mock(DataTree.class);
        Mockito.when((Object)db.getDataTree()).thenReturn((Object)dataTree);
        HashSet<String> ephemerals = new HashSet<String>();
        ephemerals.add("/crystalmountain");
        ephemerals.add("/stevenspass");
        Mockito.when((Object)db.getEphemerals(ArgumentMatchers.anyLong())).thenReturn(ephemerals);
        this.nextProcessor = (RequestProcessor)Mockito.mock(RequestProcessor.class);
        ServerMetrics.getMetrics().resetAll();
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.skipACL");
    }

    private Request createRequest(Record record, int opCode) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        record.serialize((OutputArchive)boa, "request");
        baos.close();
        return new Request(null, 1L, 0, opCode, ByteBuffer.wrap(baos.toByteArray()), null);
    }

    private Request createRequest(String path, int opCode) throws IOException {
        DeleteRequest record;
        switch (opCode) {
            case 5: {
                record = new SetDataRequest(path, new byte[0], -1);
                break;
            }
            case 2: {
                record = new DeleteRequest(path, -1);
                break;
            }
            default: {
                record = new DeleteRequest(path, -1);
            }
        }
        return this.createRequest((Record)record, opCode);
    }

    private Request createRequest(long sessionId, int opCode) {
        return new Request(null, sessionId, 0, opCode, null, null);
    }

    @Test
    public void testPrepRequestProcessorMetrics() throws Exception {
        CountDownLatch threeRequests = new CountDownLatch(3);
        ((RequestProcessor)Mockito.doAnswer(invocationOnMock -> {
            threeRequests.countDown();
            return null;
        }).when((Object)this.nextProcessor)).processRequest((Request)ArgumentMatchers.any(Request.class));
        PrepRequestProcessor prepRequestProcessor = new PrepRequestProcessor(this.zks, this.nextProcessor);
        prepRequestProcessor.processRequest(this.createRequest("/foo", 5));
        prepRequestProcessor.processRequest(this.createRequest("/foo/bar", 2));
        prepRequestProcessor.processRequest(this.createRequest(2L, -11));
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)3L, (Object)values.get("prep_processor_request_queued"));
        Thread.sleep(20L);
        prepRequestProcessor.start();
        threeRequests.await(500L, TimeUnit.MILLISECONDS);
        values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)3L, (Object)values.get("max_prep_processor_queue_size"));
        MatcherAssert.assertThat((Object)((Long)values.get("min_prep_processor_queue_time_ms")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(20L)));
        Assertions.assertEquals((Object)3L, (Object)values.get("cnt_prep_processor_queue_time_ms"));
        Assertions.assertEquals((Object)3L, (Object)values.get("cnt_prep_process_time"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_prep_process_time")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_close_session_prep_time"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_close_session_prep_time")), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((Object)7L, (Object)values.get("outstanding_changes_queued"));
    }

    @Test
    public void testOutstandingChangesRemoved() throws Exception {
        QuorumUtil util = new QuorumUtil(1);
        util.startAll();
        ServerMetrics.getMetrics().resetAll();
        ZooKeeper zk = ClientBase.createZKClient(util.getConnString());
        zk.create("/test", new byte[50], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch created = new CountDownLatch(1);
        zk.exists("/test", (Watcher)new SimpleWatcher(created));
        created.await(200L, TimeUnit.MILLISECONDS);
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        MatcherAssert.assertThat((Object)((Long)values.get("outstanding_changes_removed")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        util.shutdownAll();
    }

    private class SimpleWatcher
    implements Watcher {
        CountDownLatch created;

        public SimpleWatcher(CountDownLatch latch) {
            this.created = latch;
        }

        public void process(WatchedEvent e) {
            this.created.countDown();
        }
    }
}

