/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.util.OSMXBean;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.JMXEnv;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumBaseOracle_2Nodes
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumBase.class);
    private static final String LOCALADDR = "127.0.0.1";
    private File oracleDir;
    private static String oraclePath_0 = "/oraclePath/0/mastership/";
    private static String oraclePath_1 = "/oraclePath/1/mastership/";
    private static final String mastership = "value";
    File s1dir;
    File s2dir;
    QuorumPeer s1;
    QuorumPeer s2;
    protected int port1;
    protected int port2;
    protected int portLE1;
    protected int portLE2;
    protected int portClient1;
    protected int portClient2;
    protected boolean localSessionsEnabled = false;
    protected boolean localSessionsUpgradingEnabled = false;
    Map<Long, QuorumPeer.QuorumServer> peers = null;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        LOG.info("QuorumBase.setup {}", (Object)this.getTestName());
        QuorumBaseOracle_2Nodes.setupTestEnv();
        JMXEnv.setUp();
        this.setUpAll();
        this.port1 = PortAssignment.unique();
        this.port2 = PortAssignment.unique();
        this.portLE1 = PortAssignment.unique();
        this.portLE2 = PortAssignment.unique();
        this.portClient1 = PortAssignment.unique();
        this.portClient2 = PortAssignment.unique();
        this.hostPort = "127.0.0.1:" + this.portClient1 + ",127.0.0.1:" + this.portClient2;
        LOG.info("Ports are: {}", (Object)this.hostPort);
        this.s1dir = ClientBase.createTmpDir();
        this.s2dir = ClientBase.createTmpDir();
        this.createOraclePath();
        this.startServers();
        OSMXBean osMbean = new OSMXBean();
        if (osMbean.getUnix()) {
            LOG.info("Initial fdcount is: {}", (Object)osMbean.getOpenFileDescriptorCount());
        }
        LOG.info("Setup finished");
    }

    private void createOraclePath() throws IOException {
        this.oracleDir = ClientBase.createTmpDir();
        File directory = new File(this.oracleDir, oraclePath_0);
        directory.mkdirs();
        FileWriter fw = new FileWriter(this.oracleDir.getAbsolutePath() + oraclePath_0 + mastership);
        fw.write("0");
        fw.close();
        directory = new File(this.oracleDir, oraclePath_1);
        directory.mkdirs();
        fw = new FileWriter(this.oracleDir.getAbsolutePath() + oraclePath_1 + mastership);
        fw.write("1");
        fw.close();
    }

    void startServers() throws Exception {
        int i;
        int tickTime = 2000;
        int initLimit = 3;
        int syncLimit = 3;
        int connectToLearnerMasterLimit = 3;
        HashMap<Long, QuorumPeer.QuorumServer> peers = new HashMap<Long, QuorumPeer.QuorumServer>();
        peers.put(1L, new QuorumPeer.QuorumServer(1L, new InetSocketAddress(LOCALADDR, this.port1), new InetSocketAddress(LOCALADDR, this.portLE1), new InetSocketAddress(LOCALADDR, this.portClient1), QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress(LOCALADDR, this.port2), new InetSocketAddress(LOCALADDR, this.portLE2), new InetSocketAddress(LOCALADDR, this.portClient2), QuorumPeer.LearnerType.PARTICIPANT));
        LOG.info("creating QuorumPeer 1 port {}", (Object)this.portClient1);
        this.s1 = new QuorumPeer(peers, this.s1dir, this.s1dir, this.portClient1, 3, 1L, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit, this.oracleDir.getAbsolutePath() + oraclePath_0 + mastership);
        Assertions.assertEquals((int)this.portClient1, (int)this.s1.getClientPort());
        LOG.info("creating QuorumPeer 2 port {}", (Object)this.portClient2);
        this.s2 = new QuorumPeer(peers, this.s2dir, this.s2dir, this.portClient2, 3, 2L, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit, this.oracleDir.getAbsolutePath() + oraclePath_1 + mastership);
        Assertions.assertEquals((int)this.portClient2, (int)this.s2.getClientPort());
        LOG.info("QuorumPeer 1 voting view: {}", (Object)this.s1.getVotingView());
        LOG.info("QuorumPeer 2 voting view: {}", (Object)this.s2.getVotingView());
        this.s1.enableLocalSessions(this.localSessionsEnabled);
        this.s2.enableLocalSessions(this.localSessionsEnabled);
        this.s1.enableLocalSessionsUpgrading(this.localSessionsUpgradingEnabled);
        this.s2.enableLocalSessionsUpgrading(this.localSessionsUpgradingEnabled);
        LOG.info("start QuorumPeer 1");
        this.s1.start();
        LOG.info("start QuorumPeer 2");
        this.s2.start();
        LOG.info("Checking ports {}", (Object)this.hostPort);
        for (String hp : this.hostPort.split(",")) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(hp, CONNECTION_TIMEOUT), (String)"waiting for server up");
            LOG.info("{} is accepting client connections", (Object)hp);
        }
        JMXEnv.dump();
        LinkedHashSet<String> ensureNames = new LinkedHashSet<String>();
        for (i = 1; i <= 2; ++i) {
            ensureNames.add("InMemoryDataTree");
        }
        for (i = 1; i <= 2; ++i) {
            ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + i + ",name2=");
        }
        for (i = 1; i <= 2; ++i) {
            for (int j = 1; j <= 2; ++j) {
                ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + j);
            }
        }
        for (i = 1; i <= 2; ++i) {
            ensureNames.add("name0=ReplicatedServer_id" + i);
        }
        JMXEnv.ensureAll(ensureNames.toArray(new String[ensureNames.size()]));
    }

    public int getLeaderIndex() {
        if (this.s1.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return 0;
        }
        if (this.s2.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return 1;
        }
        return -1;
    }

    public int getLeaderClientPort() {
        if (this.s1.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return this.portClient1;
        }
        if (this.s2.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return this.portClient2;
        }
        return -1;
    }

    public QuorumPeer getLeaderQuorumPeer() {
        if (this.s1.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return this.s1;
        }
        if (this.s2.getPeerState() == QuorumPeer.ServerState.LEADING) {
            return this.s2;
        }
        return null;
    }

    public QuorumPeer getFirstObserver() {
        if (this.s1.getLearnerType() == QuorumPeer.LearnerType.OBSERVER) {
            return this.s1;
        }
        if (this.s2.getLearnerType() == QuorumPeer.LearnerType.OBSERVER) {
            return this.s2;
        }
        return null;
    }

    public int getFirstObserverClientPort() {
        if (this.s1.getLearnerType() == QuorumPeer.LearnerType.OBSERVER) {
            return this.portClient1;
        }
        if (this.s2.getLearnerType() == QuorumPeer.LearnerType.OBSERVER) {
            return this.portClient2;
        }
        return -1;
    }

    public String getPeersMatching(QuorumPeer.ServerState state) {
        StringBuilder hosts = new StringBuilder();
        for (QuorumPeer p : this.getPeerList()) {
            if (p.getPeerState() != state) continue;
            hosts.append(String.format("%s:%d,", LOCALADDR, p.getClientAddress().getPort()));
        }
        LOG.info("getPeersMatching ports are {}", (Object)hosts);
        return hosts.toString();
    }

    public ArrayList<QuorumPeer> getPeerList() {
        ArrayList<QuorumPeer> peers = new ArrayList<QuorumPeer>();
        peers.add(this.s1);
        peers.add(this.s2);
        return peers;
    }

    public QuorumPeer getPeerByClientPort(int clientPort) {
        for (QuorumPeer p : this.getPeerList()) {
            if (p.getClientAddress().getPort() != clientPort) continue;
            return p;
        }
        return null;
    }

    public void setupServers() throws IOException {
        this.setupServer(1);
        this.setupServer(2);
    }

    public void setupServer(int i) throws IOException {
        int tickTime = 2000;
        int initLimit = 3;
        int syncLimit = 3;
        int connectToLearnerMasterLimit = 3;
        if (this.peers == null) {
            this.peers = new HashMap<Long, QuorumPeer.QuorumServer>();
            this.peers.put(1L, new QuorumPeer.QuorumServer(1L, new InetSocketAddress(LOCALADDR, this.port1), new InetSocketAddress(LOCALADDR, this.portLE1), new InetSocketAddress(LOCALADDR, this.portClient1), QuorumPeer.LearnerType.PARTICIPANT));
            this.peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress(LOCALADDR, this.port2), new InetSocketAddress(LOCALADDR, this.portLE2), new InetSocketAddress(LOCALADDR, this.portClient2), QuorumPeer.LearnerType.PARTICIPANT));
        }
        switch (i) {
            case 1: {
                LOG.info("creating QuorumPeer 1 port {}", (Object)this.portClient1);
                this.s1 = new QuorumPeer(this.peers, this.s1dir, this.s1dir, this.portClient1, 3, 1L, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit);
                Assertions.assertEquals((int)this.portClient1, (int)this.s1.getClientPort());
                break;
            }
            case 2: {
                LOG.info("creating QuorumPeer 2 port {}", (Object)this.portClient2);
                this.s2 = new QuorumPeer(this.peers, this.s2dir, this.s2dir, this.portClient2, 3, 2L, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit);
                Assertions.assertEquals((int)this.portClient2, (int)this.s2.getClientPort());
            }
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        OSMXBean osMbean;
        LOG.info("TearDown started");
        if (this.oracleDir != null) {
            ClientBase.recursiveDelete(this.oracleDir);
        }
        if ((osMbean = new OSMXBean()).getUnix()) {
            LOG.info("fdcount after test is: {}", (Object)osMbean.getOpenFileDescriptorCount());
        }
        this.shutdownServers();
        for (String hp : this.hostPort.split(",")) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown(hp, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
            LOG.info("{} is no longer accepting client connections", (Object)hp);
        }
        JMXEnv.tearDown();
    }

    public void shutdownServers() {
        QuorumBaseOracle_2Nodes.shutdown(this.s1);
        QuorumBaseOracle_2Nodes.shutdown(this.s2);
    }

    public static void shutdown(QuorumPeer qp) {
        if (qp == null) {
            return;
        }
        try {
            LOG.info("Shutting down quorum peer {}", (Object)qp.getName());
            qp.shutdown();
            Election e = qp.getElectionAlg();
            if (e != null) {
                LOG.info("Shutting down leader election {}", (Object)qp.getName());
                e.shutdown();
            } else {
                LOG.info("No election available to shutdown {}", (Object)qp.getName());
            }
            LOG.info("Waiting for {} to exit thread", (Object)qp.getName());
            long readTimeout = qp.getTickTime() * qp.getInitLimit();
            long connectTimeout = qp.getTickTime() * qp.getSyncLimit();
            long maxTimeout = Math.max(readTimeout, connectTimeout);
            maxTimeout = Math.max(maxTimeout, (long)ClientBase.CONNECTION_TIMEOUT);
            qp.join(maxTimeout * 2L);
            if (qp.isAlive()) {
                Assertions.fail((String)("QP failed to shutdown in " + maxTimeout * 2L + " seconds: " + qp.getName()));
            }
        }
        catch (InterruptedException e) {
            LOG.debug("QP interrupted: {}", (Object)qp.getName(), (Object)e);
        }
    }

    @Override
    protected TestableZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.hostPort);
    }

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        return this.createClient(watcher, hp);
    }

    protected TestableZooKeeper createClient(ClientBase.CountdownWatcher watcher, QuorumPeer.ServerState state) throws IOException, InterruptedException {
        return this.createClient(watcher, this.getPeersMatching(state));
    }
}

