/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.DumbWatcher;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.watch.IWatchManager;
import org.apache.zookeeper.server.watch.WatchManager;
import org.apache.zookeeper.server.watch.WatchManagerFactory;
import org.apache.zookeeper.server.watch.WatchManagerOptimized;
import org.apache.zookeeper.server.watch.WatcherMode;
import org.apache.zookeeper.server.watch.WatcherOrBitSet;
import org.apache.zookeeper.server.watch.WatchesReport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchManagerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(WatchManagerTest.class);
    private static final String PATH_PREFIX = "/path";
    private ConcurrentHashMap<Integer, DumbWatcher> watchers;
    private Random r;

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{WatchManager.class.getName()}), Arguments.of((Object[])new Object[]{WatchManagerOptimized.class.getName()}));
    }

    @BeforeEach
    public void setUp() {
        ServerMetrics.getMetrics().resetAll();
        this.watchers = new ConcurrentHashMap();
        this.r = new Random(System.nanoTime());
    }

    public IWatchManager getWatchManager(String className) throws IOException {
        System.setProperty("zookeeper.watchManagerName", className);
        return WatchManagerFactory.createWatchManager();
    }

    public DumbWatcher createOrGetWatcher(int watcherId) {
        if (!this.watchers.containsKey(watcherId)) {
            DumbWatcher watcher = new DumbWatcher((long)watcherId);
            this.watchers.putIfAbsent(watcherId, watcher);
        }
        return this.watchers.get(watcherId);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=90L)
    public void testAddAndTriggerWatcher(String className) throws IOException {
        IWatchManager manager = this.getWatchManager(className);
        int paths = 1;
        int watchers = 10000;
        AtomicInteger watchTriggered = new AtomicInteger();
        ArrayList<WatcherTriggerWorker> triggerWorkers = new ArrayList<WatcherTriggerWorker>();
        for (int i = 0; i < 5; ++i) {
            WatcherTriggerWorker worker = new WatcherTriggerWorker(manager, paths, watchTriggered);
            triggerWorkers.add(worker);
            worker.start();
        }
        AtomicInteger watchesAdded = new AtomicInteger();
        ArrayList<AddWatcherWorker> addWorkers = new ArrayList<AddWatcherWorker>();
        for (int i = 0; i < 5; ++i) {
            AddWatcherWorker addWatcherWorker = new AddWatcherWorker(manager, paths, watchers, watchesAdded);
            addWorkers.add(addWatcherWorker);
            addWatcherWorker.start();
        }
        while (watchesAdded.get() < 100000) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (AddWatcherWorker addWatcherWorker : addWorkers) {
            addWatcherWorker.shutdown();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (WatcherTriggerWorker watcherTriggerWorker : triggerWorkers) {
            watcherTriggerWorker.shutdown();
        }
        Assertions.assertTrue((watchesAdded.get() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)watchesAdded.get(), (int)watchTriggered.get());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=90L)
    public void testRemoveWatcherOnPath(String className) throws IOException {
        IWatchManager manager = this.getWatchManager(className);
        int paths = 10;
        int watchers = 10000;
        AtomicInteger watchesRemoved = new AtomicInteger();
        ArrayList<RemoveWatcherWorker> removeWorkers = new ArrayList<RemoveWatcherWorker>();
        for (int i = 0; i < 5; ++i) {
            RemoveWatcherWorker worker = new RemoveWatcherWorker(manager, paths, watchers, watchesRemoved);
            removeWorkers.add(worker);
            worker.start();
        }
        AtomicInteger watchesAdded = new AtomicInteger();
        ArrayList<AddWatcherWorker> addWorkers = new ArrayList<AddWatcherWorker>();
        for (int i = 0; i < 5; ++i) {
            AddWatcherWorker addWatcherWorker = new AddWatcherWorker(manager, paths, watchers, watchesAdded);
            addWorkers.add(addWatcherWorker);
            addWatcherWorker.start();
        }
        while (watchesAdded.get() < 100000) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (RemoveWatcherWorker removeWatcherWorker : removeWorkers) {
            removeWatcherWorker.shutdown();
        }
        for (AddWatcherWorker addWatcherWorker : addWorkers) {
            addWatcherWorker.shutdown();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((watchesAdded.get() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((watchesRemoved.get() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((manager.size() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)watchesAdded.get(), (int)(watchesRemoved.get() + manager.size()));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testAddRemoveWatcher(String className) throws IOException {
        IWatchManager manager = this.getWatchManager(className);
        DumbWatcher watcher1 = new DumbWatcher();
        DumbWatcher watcher2 = new DumbWatcher();
        manager.addWatch("/node1", (Watcher)watcher1);
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher2));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node2", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node2", (Watcher)watcher1));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1));
    }

    @Test
    public void testContainsMode() {
        WatchManager manager = new WatchManager();
        DumbWatcher watcher1 = new DumbWatcher();
        DumbWatcher watcher2 = new DumbWatcher();
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertNotEquals((Object)WatcherMode.PERSISTENT, (Object)WatcherMode.DEFAULT_WATCHER_MODE);
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher2));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher2, null));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher2, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher2, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2, null));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node2", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node2", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node2", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node2", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node2", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node2", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node2", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node2", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node2", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node2", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
    }

    @Test
    public void testAddModeRepeatedly() {
        WatchManager manager = new WatchManager();
        DumbWatcher watcher1 = new DumbWatcher();
        manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.STANDARD);
        manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT);
        manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE);
        Assertions.assertFalse((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, null));
    }

    @Test
    public void testRemoveModeOne() {
        WatchManager manager = new WatchManager();
        DumbWatcher watcher1 = new DumbWatcher();
        DumbWatcher watcher2 = new DumbWatcher();
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.addWatch("/node2", (Watcher)watcher2, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.addWatch("/node2", (Watcher)watcher2, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.addWatch("/node2", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node2", (Watcher)watcher2, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node2", (Watcher)watcher2, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node2", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node2", (Watcher)watcher2, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node2", (Watcher)watcher2, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node2", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE));
    }

    @Test
    public void testRemoveModeAll() {
        WatchManager manager = new WatchManager();
        DumbWatcher watcher1 = new DumbWatcher();
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
    }

    @Test
    public void testRemoveModeAllDefault() {
        WatchManager manager = new WatchManager();
        DumbWatcher watcher1 = new DumbWatcher();
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
    }

    @Test
    public void testRemoveModeAllIndividually() {
        WatchManager manager = new WatchManager();
        DumbWatcher watcher1 = new DumbWatcher();
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
    }

    @Test
    public void testRemoveModeMismatch() {
        WatchManager manager = new WatchManager();
        DumbWatcher watcher1 = new DumbWatcher();
        DumbWatcher watcher2 = new DumbWatcher();
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.addWatch("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.addWatch("/node2", (Watcher)watcher2, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.addWatch("/node2", (Watcher)watcher2, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.addWatch("/node2", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2, null));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2, WatcherMode.STANDARD));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2, WatcherMode.PERSISTENT));
        Assertions.assertFalse((boolean)manager.removeWatcher("/node1", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, null));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node1", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node2", (Watcher)watcher2));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node2", (Watcher)watcher2, null));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node2", (Watcher)watcher2, WatcherMode.STANDARD));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node2", (Watcher)watcher2, WatcherMode.PERSISTENT));
        Assertions.assertTrue((boolean)manager.containsWatcher("/node2", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=90L)
    public void testDeadWatchers(String className) throws IOException {
        System.setProperty("zookeeper.watcherCleanThreshold", "10");
        System.setProperty("zookeeper.watcherCleanIntervalInSeconds", "1");
        IWatchManager manager = this.getWatchManager(className);
        int paths = 1;
        int watchers = 100000;
        HashSet<Watcher> deadWatchers = new HashSet<Watcher>();
        ArrayList<CreateDeadWatchersWorker> deadWorkers = new ArrayList<CreateDeadWatchersWorker>();
        for (int i = 0; i < 5; ++i) {
            CreateDeadWatchersWorker worker = new CreateDeadWatchersWorker(manager, watchers, deadWatchers);
            deadWorkers.add(worker);
            worker.start();
        }
        AtomicInteger watchesAdded = new AtomicInteger();
        ArrayList<AddWatcherWorker> addWorkers = new ArrayList<AddWatcherWorker>();
        for (int i = 0; i < 5; ++i) {
            AddWatcherWorker addWatcherWorker = new AddWatcherWorker(manager, paths, watchers, watchesAdded);
            addWorkers.add(addWatcherWorker);
            addWatcherWorker.start();
        }
        while (watchesAdded.get() < 50000) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException i) {}
        }
        for (CreateDeadWatchersWorker createDeadWatchersWorker : deadWorkers) {
            createDeadWatchersWorker.shutdown();
        }
        for (AddWatcherWorker addWatcherWorker : addWorkers) {
            addWatcherWorker.shutdown();
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        WatchesReport existingWatchers = manager.getWatches();
        for (Watcher w : deadWatchers) {
            Assertions.assertFalse((boolean)existingWatchers.hasPaths(((ServerCnxn)w).getSessionId()));
        }
    }

    private void checkMetrics(String metricName, long min, long max, double avg, long cnt, long sum) {
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)min, (Object)values.get("min_" + metricName));
        Assertions.assertEquals((Object)max, (Object)values.get("max_" + metricName));
        Assertions.assertEquals((double)avg, (double)((Double)values.get("avg_" + metricName)), (double)1.0E-6);
        Assertions.assertEquals((Object)cnt, (Object)values.get("cnt_" + metricName));
        Assertions.assertEquals((Object)sum, (Object)values.get("sum_" + metricName));
    }

    private void checkMostRecentWatchedEvent(DumbWatcher watcher, String path, Watcher.Event.EventType eventType, long zxid) {
        Assertions.assertEquals((Object)path, (Object)watcher.getMostRecentPath());
        Assertions.assertEquals((Object)eventType, (Object)watcher.getMostRecentEventType());
        Assertions.assertEquals((long)zxid, (long)watcher.getMostRecentZxid());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testWatcherMetrics(String className) throws IOException {
        IWatchManager manager = this.getWatchManager(className);
        ServerMetrics.getMetrics().resetAll();
        DumbWatcher watcher1 = new DumbWatcher(1L);
        DumbWatcher watcher2 = new DumbWatcher(2L);
        String path1 = "/path1";
        String path2 = "/path2";
        String path3 = "/path3";
        manager.addWatch("/path1", (Watcher)watcher1);
        manager.addWatch("/path1", (Watcher)watcher2);
        manager.addWatch("/path2", (Watcher)watcher1);
        manager.triggerWatch("/path3", Watcher.Event.EventType.NodeCreated, 1L);
        this.checkMetrics("node_created_watch_count", 0L, 0L, 0.0, 0L, 0L);
        this.checkMostRecentWatchedEvent(watcher1, null, null, -1L);
        this.checkMostRecentWatchedEvent(watcher2, null, null, -1L);
        manager.triggerWatch("/path1", Watcher.Event.EventType.NodeCreated, 2L);
        this.checkMetrics("node_created_watch_count", 2L, 2L, 2.0, 1L, 2L);
        this.checkMostRecentWatchedEvent(watcher1, "/path1", Watcher.Event.EventType.NodeCreated, 2L);
        this.checkMostRecentWatchedEvent(watcher2, "/path1", Watcher.Event.EventType.NodeCreated, 2L);
        manager.triggerWatch("/path2", Watcher.Event.EventType.NodeCreated, 3L);
        this.checkMetrics("node_created_watch_count", 1L, 2L, 1.5, 2L, 3L);
        this.checkMostRecentWatchedEvent(watcher1, "/path2", Watcher.Event.EventType.NodeCreated, 3L);
        this.checkMostRecentWatchedEvent(watcher2, "/path1", Watcher.Event.EventType.NodeCreated, 2L);
        manager.triggerWatch("/path1", Watcher.Event.EventType.NodeDataChanged, 4L);
        this.checkMetrics("node_changed_watch_count", 0L, 0L, 0.0, 0L, 0L);
        this.checkMostRecentWatchedEvent(watcher1, "/path2", Watcher.Event.EventType.NodeCreated, 3L);
        this.checkMostRecentWatchedEvent(watcher2, "/path1", Watcher.Event.EventType.NodeCreated, 2L);
        manager.addWatch("/path1", (Watcher)watcher1);
        manager.addWatch("/path1", (Watcher)watcher2);
        manager.addWatch("/path2", (Watcher)watcher1);
        manager.triggerWatch("/path1", Watcher.Event.EventType.NodeDataChanged, 5L);
        this.checkMetrics("node_changed_watch_count", 2L, 2L, 2.0, 1L, 2L);
        this.checkMostRecentWatchedEvent(watcher1, "/path1", Watcher.Event.EventType.NodeDataChanged, 5L);
        this.checkMostRecentWatchedEvent(watcher2, "/path1", Watcher.Event.EventType.NodeDataChanged, 5L);
        manager.triggerWatch("/path2", Watcher.Event.EventType.NodeDeleted, 6L);
        this.checkMetrics("node_deleted_watch_count", 1L, 1L, 1.0, 1L, 1L);
        this.checkMostRecentWatchedEvent(watcher1, "/path2", Watcher.Event.EventType.NodeDeleted, 6L);
        this.checkMostRecentWatchedEvent(watcher2, "/path1", Watcher.Event.EventType.NodeDataChanged, 5L);
        this.checkMetrics("node_created_watch_count", 1L, 2L, 1.5, 2L, 3L);
    }

    public class CreateDeadWatchersWorker
    extends Thread {
        private final IWatchManager manager;
        private final int watchers;
        private final Set<Watcher> removedWatchers;
        private volatile boolean stopped = false;

        public CreateDeadWatchersWorker(IWatchManager manager, int watchers, Set<Watcher> removedWatchers) {
            this.manager = manager;
            this.watchers = watchers;
            this.removedWatchers = removedWatchers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                DumbWatcher watcher = WatchManagerTest.this.createOrGetWatcher(WatchManagerTest.this.r.nextInt(this.watchers));
                watcher.setStale();
                this.manager.removeWatcher((Watcher)watcher);
                Set<Watcher> set = this.removedWatchers;
                synchronized (set) {
                    this.removedWatchers.add((Watcher)watcher);
                }
                try {
                    Thread.sleep(WatchManagerTest.this.r.nextInt(10));
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.stopped = true;
        }
    }

    public class RemoveWatcherWorker
    extends Thread {
        private final IWatchManager manager;
        private final int paths;
        private final int watchers;
        private final AtomicInteger watchesRemoved;
        private volatile boolean stopped = false;

        public RemoveWatcherWorker(IWatchManager manager, int paths, int watchers, AtomicInteger watchesRemoved) {
            this.manager = manager;
            this.paths = paths;
            this.watchers = watchers;
            this.watchesRemoved = watchesRemoved;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                DumbWatcher watcher;
                String path = WatchManagerTest.PATH_PREFIX + WatchManagerTest.this.r.nextInt(this.paths);
                if (this.manager.removeWatcher(path, (Watcher)(watcher = WatchManagerTest.this.createOrGetWatcher(WatchManagerTest.this.r.nextInt(this.watchers))))) {
                    this.watchesRemoved.addAndGet(1);
                }
                try {
                    Thread.sleep(WatchManagerTest.this.r.nextInt(10));
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.stopped = true;
        }
    }

    public class WatcherTriggerWorker
    extends Thread {
        private final IWatchManager manager;
        private final int paths;
        private final AtomicInteger triggeredCount;
        private volatile boolean stopped = false;

        public WatcherTriggerWorker(IWatchManager manager, int paths, AtomicInteger triggeredCount) {
            this.manager = manager;
            this.paths = paths;
            this.triggeredCount = triggeredCount;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                String path = WatchManagerTest.PATH_PREFIX + WatchManagerTest.this.r.nextInt(this.paths);
                WatcherOrBitSet s = this.manager.triggerWatch(path, Watcher.Event.EventType.NodeDeleted, -1L);
                if (s != null) {
                    this.triggeredCount.addAndGet(s.size());
                }
                try {
                    Thread.sleep(WatchManagerTest.this.r.nextInt(10));
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.stopped = true;
        }
    }

    public class AddWatcherWorker
    extends Thread {
        private final IWatchManager manager;
        private final int paths;
        private final int watchers;
        private final AtomicInteger watchesAdded;
        private volatile boolean stopped = false;

        public AddWatcherWorker(IWatchManager manager, int paths, int watchers, AtomicInteger watchesAdded) {
            this.manager = manager;
            this.paths = paths;
            this.watchers = watchers;
            this.watchesAdded = watchesAdded;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                DumbWatcher watcher;
                String path = WatchManagerTest.PATH_PREFIX + WatchManagerTest.this.r.nextInt(this.paths);
                if (!this.manager.addWatch(path, (Watcher)(watcher = WatchManagerTest.this.createOrGetWatcher(WatchManagerTest.this.r.nextInt(this.watchers))))) continue;
                this.watchesAdded.addAndGet(1);
            }
        }

        public void shutdown() {
            this.stopped = true;
        }
    }
}

