/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class NonRecoverableErrorTest
extends QuorumPeerTestBase {
    private static final String NODE_PATH = "/noLeaderIssue";

    @Test
    @Timeout(value=30L)
    public void testZooKeeperServiceAvailableOnLeader() throws Exception {
        int i;
        int SERVER_COUNT = 3;
        int[] clientPorts = new int[SERVER_COUNT];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < SERVER_COUNT; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];
        for (i = 0; i < SERVER_COUNT; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            mt[i].start();
        }
        for (i = 0; i < SERVER_COUNT; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT), (String)("waiting for server " + i + " being up"));
        }
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + clientPorts[0], ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        String data = "originalData";
        zk.create(NODE_PATH, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        QuorumPeer leader = this.getLeaderQuorumPeer(mt);
        Assertions.assertNotNull((Object)leader, (String)"Leader must have been elected by now");
        FileTxnSnapLog snapLog = leader.getActiveServer().getTxnLogFactory();
        FileTxnSnapLog fileTxnSnapLogWithError = new FileTxnSnapLog(snapLog.getDataDir(), snapLog.getSnapDir()){

            public void commit() throws IOException {
                throw new IOException("Input/output error");
            }
        };
        ZKDatabase originalZKDatabase = leader.getActiveServer().getZKDatabase();
        long leaderCurrentEpoch = leader.getCurrentEpoch();
        ZKDatabase newDB = new ZKDatabase(fileTxnSnapLogWithError);
        leader.getActiveServer().setZKDatabase(newDB);
        try {
            zk.create(this.uniqueZnode(), data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"IOException is expected due to error injected to transaction log commit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        watcher.reset();
        this.waitForNewLeaderElection(leader, leaderCurrentEpoch);
        for (int i3 = 0; i3 < SERVER_COUNT; ++i3) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i3], ClientBase.CONNECTION_TIMEOUT), (String)("waiting for server " + i3 + " being up"));
        }
        leader.getActiveServer().setZKDatabase(originalZKDatabase);
        leader = this.getLeaderQuorumPeer(mt);
        Assertions.assertNotNull((Object)leader, (String)"New leader must have been elected by now");
        String uniqueNode = this.uniqueZnode();
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        String createNode = zk.create(uniqueNode, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)uniqueNode, (Object)createNode, (String)"Failed to create znode");
        zk.close();
        for (int i4 = 0; i4 < SERVER_COUNT; ++i4) {
            mt[i4].shutdown();
        }
    }

    private void waitForNewLeaderElection(QuorumPeer peer, long leaderCurrentEpoch) throws IOException, InterruptedException {
        LOG.info("Waiting for new LE cycle..");
        for (int count = 100; count > 0; --count) {
            if (leaderCurrentEpoch != peer.getCurrentEpoch()) continue;
            Thread.sleep(100L);
        }
        Assertions.assertNotEquals((long)leaderCurrentEpoch, (long)peer.getCurrentEpoch(), (String)"New LE cycle must have triggered");
    }

    private QuorumPeer getLeaderQuorumPeer(QuorumPeerTestBase.MainThread[] mt) {
        for (int i = mt.length - 1; i >= 0; --i) {
            QuorumPeer quorumPeer = mt[i].getQuorumPeer();
            if (null == quorumPeer || QuorumPeer.ServerState.LEADING != quorumPeer.getPeerState()) continue;
            return quorumPeer;
        }
        return null;
    }

    private String uniqueZnode() {
        UUID randomUUID = UUID.randomUUID();
        String node = "/noLeaderIssue/" + randomUUID.toString();
        return node;
    }
}

