/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.watch.IWatchManager;
import org.apache.zookeeper.server.watch.WatcherOrBitSet;
import org.apache.zookeeper.server.watch.WatchesPathReport;
import org.apache.zookeeper.server.watch.WatchesReport;
import org.apache.zookeeper.server.watch.WatchesSummary;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UnsupportedAddWatcherTest
extends ClientBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("zookeeper.watchManagerName", StubbedWatchManager.class.getName());
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            System.clearProperty("zookeeper.watchManagerName");
        }
    }

    @Test
    public void testBehavior() throws IOException, InterruptedException, KeeperException {
        Assertions.assertThrows(KeeperException.MarshallingErrorException.class, () -> {
            try (TestableZooKeeper zk = this.createClient(this.hostPort);){
                zk.addWatch("/foo", event -> {}, AddWatchMode.PERSISTENT_RECURSIVE);
            }
        });
    }

    public static class StubbedWatchManager
    implements IWatchManager {
        public boolean addWatch(String path, Watcher watcher) {
            return false;
        }

        public boolean containsWatcher(String path, Watcher watcher) {
            return false;
        }

        public boolean removeWatcher(String path, Watcher watcher) {
            return false;
        }

        public void removeWatcher(Watcher watcher) {
        }

        public WatcherOrBitSet triggerWatch(String path, Watcher.Event.EventType type, long zxid) {
            return new WatcherOrBitSet(Collections.emptySet());
        }

        public WatcherOrBitSet triggerWatch(String path, Watcher.Event.EventType type, long zxid, WatcherOrBitSet suppress) {
            return new WatcherOrBitSet(Collections.emptySet());
        }

        public int size() {
            return 0;
        }

        public void shutdown() {
        }

        public WatchesSummary getWatchesSummary() {
            return null;
        }

        public WatchesReport getWatches() {
            return null;
        }

        public WatchesPathReport getWatchesByPath() {
            return null;
        }

        public void dumpWatches(PrintWriter pwriter, boolean byPath) {
        }
    }
}

