/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo.exporter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Collection;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.appfuse.mojo.HibernateExporterMojo;
import org.appfuse.tool.AppFuseExporter;
import org.appfuse.tool.ArtifactInstaller;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.hibernate.tool.hbm2x.Exporter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AppFuseGeneratorMojo
extends HibernateExporterMojo {
    boolean generateCoreOnly;
    boolean generateWebOnly;
    String pojoName;
    Prompter prompter;
    private String destinationDirectory;
    private String sourceDirectory;
    private boolean disableInstallation;
    private boolean genericCore;
    private String templateDirectory;
    private String fullPath = null;

    public AppFuseGeneratorMojo() {
        this.addDefaultComponent("target/appfuse/generated-sources", "configuration", false);
        this.addDefaultComponent("target/appfuse/generated-sources", "annotationconfiguration", true);
    }

    public String getName() {
        return "gen";
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        block22: {
            String daoFramework;
            if (this.getProject().getPackaging().equalsIgnoreCase("pom")) {
                String errorMsg = "[ERROR] This plugin cannot be run from a pom project, please run it from a jar or war project (i.e. core or web).";
                throw new MojoFailureException(errorMsg);
            }
            this.pojoName = System.getProperty("entity");
            if (this.pojoName == null) {
                try {
                    this.pojoName = this.prompter.prompt("What is the name of your pojo (i.e. Person)?");
                }
                catch (PrompterException pe) {
                    pe.printStackTrace();
                }
            }
            if (this.pojoName == null || "".equals(this.pojoName.trim())) {
                throw new MojoExecutionException("You must specify an entity name to continue.");
            }
            if (this.pojoName.contains(".")) {
                if (this.pojoName.indexOf("model") == -1) {
                    throw new MojoExecutionException("You must specify 'model' as the last package in your entity name.");
                }
                this.fullPath = this.pojoName.substring(0, this.pojoName.indexOf(".model"));
                this.fullPath = this.fullPath.replace("~", this.getProject().getGroupId());
                this.pojoName = this.pojoName.substring(this.pojoName.lastIndexOf(".") + 1);
                this.log("Package name set to: " + this.fullPath);
            }
            if ((daoFramework = this.getProject().getProperties().getProperty("dao.framework")).indexOf("jpa") > -1) {
                this.getComponentProperties().put("implementation", "jpaconfiguration");
                this.checkEntityExists();
            }
            if (this.getProject().getPackaging().equals("war") && this.getProject().hasParent()) {
                String moduleName = (String)this.getProject().getParent().getModules().get(0);
                String pathToParent = this.getProject().getOriginalModel().getParent().getRelativePath();
                pathToParent = pathToParent.substring(0, pathToParent.lastIndexOf(47) + 1);
                this.log("Assuming '" + moduleName + "' has hibernate.cfg.xml in its src/main/resources directory");
                this.getComponentProperties().put("configurationfile", this.getProject().getBasedir() + "/" + pathToParent + moduleName + "/src/main/resources/hibernate.cfg.xml");
            }
            if (this.getComponentProperty("configurationfile") == null) {
                this.getComponentProperties().put("configurationfile", "src/main/resources/hibernate.cfg.xml");
            }
            String hibernateConfig = this.getComponentProperty("configurationfile");
            if (daoFramework.equals("hibernate")) {
                try {
                    String hibernateCfgXml = FileUtils.readFileToString((File)new File(hibernateConfig));
                    this.addEntityToHibernateCfgXml(hibernateCfgXml);
                }
                catch (IOException io) {
                    throw new MojoFailureException(io.getMessage());
                }
            }
            if (daoFramework.equalsIgnoreCase("ibatis")) {
                try {
                    String pomAsString = FileUtils.readFileToString((File)new File("pom.xml"));
                    if (pomAsString.contains("<implementation>annotationconfiguration</implementation>")) {
                        String hibernateCfgXml;
                        this.log("Creating hibernate.cfg.xml from template...");
                        File existingConfig = new File(hibernateConfig);
                        if (!existingConfig.exists()) {
                            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/appfuse/dao/ibatis/hibernate.cfg.ftl");
                            StringBuffer configFile = new StringBuffer();
                            try {
                                String line;
                                InputStreamReader isr = new InputStreamReader(in);
                                BufferedReader reader = new BufferedReader(isr);
                                while ((line = reader.readLine()) != null) {
                                    configFile.append(line).append("\n");
                                }
                                reader.close();
                            }
                            catch (IOException io) {
                                throw new MojoFailureException(io.getMessage());
                            }
                            hibernateCfgXml = configFile.toString();
                        } else {
                            hibernateCfgXml = FileUtils.readFileToString((File)existingConfig);
                        }
                        this.addEntityToHibernateCfgXml(hibernateCfgXml);
                        break block22;
                    }
                    this.log("[WARN] Detected JPA configuration");
                }
                catch (IOException io) {
                    io.printStackTrace();
                    this.getLog().error((CharSequence)io.getMessage());
                }
            }
        }
        super.execute();
    }

    @Override
    protected Exporter configureExporter(Exporter exp) throws MojoExecutionException {
        System.setProperty("appfuse.entity", this.pojoName);
        this.getProject().addCompileSourceRoot(new File(this.getComponent().getOutputDirectory()).getPath());
        AppFuseExporter exporter = (AppFuseExporter)super.configureExporter(exp);
        exporter.getProperties().setProperty("ejb3", this.getComponentProperty("ejb3", "true"));
        exporter.getProperties().setProperty("jdk5", this.getComponentProperty("jdk5", "true"));
        if (this.generateCoreOnly) {
            exporter.getProperties().setProperty("generate-core", "true");
        } else if (this.generateWebOnly) {
            exporter.getProperties().setProperty("generate-web", "true");
        }
        String rootPackage = this.fullPath != null ? this.fullPath : this.getProject().getGroupId();
        exporter.getProperties().setProperty("basepackage", rootPackage);
        exporter.getProperties().setProperty("daoframework", this.getProject().getProperties().getProperty("dao.framework"));
        String webFramework = this.getProject().getProperties().containsKey("web.framework") ? this.getProject().getProperties().getProperty("web.framework") : "";
        exporter.getProperties().setProperty("webframework", webFramework);
        exporter.getProperties().setProperty("packaging", this.getProject().getPackaging());
        exporter.getProperties().setProperty("genericcore", String.valueOf(this.genericCore));
        if (this.templateDirectory != null) {
            exporter.getProperties().setProperty("templatedirectory", this.templateDirectory);
        }
        if (this.isFullSource()) {
            exporter.getProperties().setProperty("appfusepackage", rootPackage);
        } else {
            exporter.getProperties().setProperty("appfusepackage", "org.appfuse");
        }
        boolean hasSecurity = false;
        if (this.getProject().getPackaging().equals("war")) {
            Collection sourceFiles = FileUtils.listFiles((File)this.getProject().getBasedir(), (String[])new String[]{"xml"}, (boolean)true);
            for (File file : sourceFiles) {
                if (!file.getPath().contains("security.xml")) continue;
                hasSecurity = true;
                break;
            }
        }
        exporter.getProperties().setProperty("hasSecurity", String.valueOf(hasSecurity));
        if (webFramework.equals("tapestry")) {
            boolean useMainMenu = true;
            Collection sourceFiles = FileUtils.listFiles((File)this.getProject().getBasedir(), (String[])new String[]{"java"}, (boolean)true);
            for (File file : sourceFiles) {
                if (!file.getPath().contains("Home.java")) continue;
                useMainMenu = false;
                break;
            }
            exporter.getProperties().setProperty("useMainMenu", String.valueOf(useMainMenu));
        }
        return exporter;
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        super.doExecute();
        if (System.getProperty("disableInstallation") != null) {
            this.disableInstallation = Boolean.valueOf(System.getProperty("disableInstallation"));
        }
        if (!this.disableInstallation) {
            ArtifactInstaller installer = new ArtifactInstaller(this.getProject(), this.pojoName, this.sourceDirectory, this.destinationDirectory, this.genericCore);
            installer.execute();
        }
    }

    @Override
    protected Exporter createExporter() {
        return new AppFuseExporter();
    }

    protected void setGenerateCoreOnly(boolean generateCoreOnly) {
        this.generateCoreOnly = generateCoreOnly;
    }

    protected void setGenerateWebOnly(boolean generateWebOnly) {
        this.generateWebOnly = generateWebOnly;
    }

    private void log(String msg) {
        this.getLog().info((CharSequence)("[AppFuse] " + msg));
    }

    private void addEntityToHibernateCfgXml(String hibernateCfgXml) throws MojoFailureException {
        String className = this.fullPath != null ? this.fullPath : this.getProject().getGroupId();
        className = className + ".model." + this.pojoName;
        this.log("Constructed class name : " + className);
        POJOSearcher pojoSearcher = new POJOSearcher(hibernateCfgXml);
        if (!pojoSearcher.searchForPojo(this.pojoName)) {
            this.checkEntityExists();
            hibernateCfgXml = hibernateCfgXml.replace("</session-factory>", "    <mapping class=\"" + className + "\"/>" + "\n    </session-factory>");
            this.log("Adding '" + this.pojoName + "' to hibernate.cfg.xml...");
        }
        hibernateCfgXml = hibernateCfgXml.replaceAll("\\$\\{appfusepackage}", this.isFullSource() ? this.getProject().getGroupId() : "org.appfuse");
        try {
            FileUtils.writeStringToFile((File)new File(this.getComponentProperty("configurationfile", "src/main/resources/hibernate.cfg.xml")), (String)hibernateCfgXml);
        }
        catch (IOException io) {
            throw new MojoFailureException(io.getMessage());
        }
    }

    private void checkEntityExists() throws MojoFailureException {
        if (!"false".equals(System.getProperty("entity.check"))) {
            String FILE_SEP = System.getProperty("file.separator");
            String pathToModelPackage = "src" + FILE_SEP + "main" + FILE_SEP + "java" + FILE_SEP;
            if (this.getProject().getPackaging().equals("war") && this.getProject().hasParent()) {
                String moduleName = (String)this.getProject().getParent().getModules().get(0);
                String pathToParent = this.getProject().getOriginalModel().getParent().getRelativePath();
                pathToParent = pathToParent.substring(0, pathToParent.lastIndexOf(47) + 1);
                pathToParent = pathToParent.replaceAll("/", FILE_SEP);
                pathToModelPackage = this.getProject().getBasedir() + FILE_SEP + pathToParent + moduleName + "/" + pathToModelPackage;
            }
            String groupIdAsPath = this.getProject().getGroupId().replace(".", FILE_SEP);
            String fullPathPackage = pathToModelPackage + groupIdAsPath;
            fullPathPackage = this.fullPath != null ? fullPathPackage + FILE_SEP + this.fullPath.replace(".", FILE_SEP) : fullPathPackage + FILE_SEP + "model";
            this.log("Looking for entity in " + fullPathPackage);
            File modelPackage = new File(fullPathPackage);
            boolean entityExists = false;
            if (modelPackage.exists()) {
                String[] entities;
                for (String entity : entities = modelPackage.list()) {
                    this.log("Found '" + entity + "' in model package...");
                    if (!entity.contains(this.pojoName + ".java")) continue;
                    entityExists = true;
                    break;
                }
            } else {
                this.getLog().error((CharSequence)("The path '" + fullPathPackage + groupIdAsPath + FILE_SEP + "model' does not exist!"));
            }
            if (!entityExists) {
                throw new MojoFailureException("[ERROR] The '" + this.pojoName + "' entity does not exist in '" + modelPackage + "'.");
            }
            try {
                File pojoFile = new File(modelPackage + FILE_SEP + this.pojoName + ".java");
                String entityAsString = FileUtils.readFileToString((File)pojoFile);
                if (!entityAsString.contains("@Entity")) {
                    String msg = "Entity '" + this.pojoName + "' found, but it doesn't contain an @Entity annotation. Please add one.";
                    throw new MojoFailureException(msg);
                }
            }
            catch (IOException io) {
                throw new MojoFailureException("[ERROR] Class '" + this.pojoName + ".java' not found in '" + modelPackage + "'");
            }
        }
    }

    public class POJOSearcher
    extends DefaultHandler {
        private String pojoName;
        private boolean foundPojo;
        private String xmlString;

        public POJOSearcher(String xmlString) {
            this.xmlString = xmlString;
        }

        public boolean searchForPojo(String pojoName) {
            this.pojoName = pojoName;
            this.foundPojo = false;
            SAXParserFactory spf = SAXParserFactory.newInstance();
            try {
                spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                SAXParser sp = spf.newSAXParser();
                sp.parse(new InputSource(new StringReader(this.xmlString)), (DefaultHandler)this);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
            return this.foundPojo;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String classValue;
            super.startElement(uri, localName, name, attributes);
            if (name.equals("mapping") && (classValue = attributes.getValue("class")) != null && classValue.endsWith(this.pojoName)) {
                this.foundPojo = true;
            }
        }
    }
}

