/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.tool;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.mapping.Column;

public class DataHelper {
    private static final Log log = LogFactory.getLog(DataHelper.class);
    private static String datePattern = "yyyy-MM-dd";
    private static String uiDatePattern = DataHelper.getDatePattern();

    public String getTestValueForDbUnit(Column column) {
        StringBuffer result = new StringBuffer();
        String type = column.getValue().getType().getReturnedClass().getName();
        if ("java.lang.Integer".equals(type) || "int".equals(type)) {
            result.append((int)(Math.random() * 2.147483647E9));
        } else if ("java.lang.Float".equals(type) || "float".equals(type)) {
            result.append((float)(Math.random() * 3.4028234663852886E38));
        } else if ("java.lang.Long".equals(type) || "long".equals(type)) {
            result.append((long)(Math.random() * 9.223372036854776E18));
        } else if ("java.lang.Double".equals(type) || "double".equals(type)) {
            result.append(Math.random() * Double.MAX_VALUE);
        } else if ("java.lang.Short".equals(type) || "short".equals(type)) {
            result.append((short)(Math.random() * 32767.0));
        } else if ("java.lang.Byte".equals(type) || "byte".equals(type)) {
            result.append((byte)(Math.random() * 127.0));
        } else if ("java.lang.Boolean".equals(type) || "boolean".equals(type)) {
            result.append("0");
        } else if ("java.util.Date".equals(type) || "java.sql.Date".equals(type)) {
            result.append(DataHelper.getDate(new Date()));
        } else if ("java.sql.Timestamp".equals(type)) {
            result.append(new Timestamp(new Date().getTime()).toString());
        } else {
            String stringWithQuotes = this.generateStringValue(column);
            result.append(stringWithQuotes.substring(1, stringWithQuotes.length() - 1));
        }
        return result.toString();
    }

    public String getValueForJavaTest(Column column) {
        StringBuffer result = new StringBuffer();
        String type = column.getValue().getType().getReturnedClass().getName();
        if ("java.lang.Integer".equals(type)) {
            result.append((int)(Math.random() * 2.147483647E9));
        } else if ("int".equals(type)) {
            result.append("(int) ").append((int)(Math.random() * 2.147483647E9));
        } else if ("java.lang.Float".equals(type)) {
            result.append("new Float(").append((float)(Math.random() * 3.4028234663852886E38)).append(")");
        } else if ("float".equals(type)) {
            result.append("(float) ").append((float)(Math.random() * 3.4028234663852886E38));
        } else if ("java.lang.Long".equals(type)) {
            result.append(Math.random() * 2.147483647E9).append("L");
        } else if ("long".equals(type)) {
            result.append((long)(Math.random() * 2.147483647E9));
        } else if ("java.lang.Double".equals(type)) {
            result.append("new Double(").append(Math.random() * Double.MAX_VALUE).append(")");
        } else if ("double".equals(type)) {
            result.append(Math.random() * Double.MAX_VALUE);
        } else if ("java.lang.Short".equals(type)) {
            result.append("new Short(\"").append((short)(Math.random() * 32767.0)).append("\")");
        } else if ("short".equals(type)) {
            result.append("(short)").append((short)(Math.random() * 32767.0));
        } else if ("java.lang.Byte".equals(type)) {
            result.append("new Byte(\"").append((byte)(Math.random() * 127.0)).append("\")");
        } else if ("byte".equals(type)) {
            result.append("(byte) ").append((byte)(Math.random() * 127.0));
        } else if ("java.lang.Boolean".equals(type)) {
            result.append("Boolean.FALSE");
        } else if ("boolean".equals(type)) {
            result.append("false");
        } else if ("java.util.Date".equals(type)) {
            result.append("new java.util.Date()");
        } else if ("java.sql.Date".equals(type)) {
            result.append("new java.sql.Date()");
        } else if ("java.sql.Timestamp".equals(type)) {
            result.append("java.sql.Timestamp.valueOf(\"").append(new Timestamp(new Date().getTime()).toString()).append("\")");
        } else {
            result.append(this.generateStringValue(column));
        }
        return result.toString();
    }

    public String getValueForWebTest(Column column) {
        String type = column.getValue().getType().getReturnedClass().getName();
        String value = this.getTestValueForDbUnit(column);
        if (type.equalsIgnoreCase(Date.class.getName())) {
            value = DataHelper.getDate(new Date(), uiDatePattern);
        } else if ("boolean".equals(type) || "java.lang.Boolean".equals(type)) {
            value = "true";
        }
        return value;
    }

    private String generateStringValue(Column column) {
        int maxLen = column.getLength();
        if (maxLen > 5000) {
            log.warn((Object)("Column length greater than 5000 characters for '" + column.getName() + "', setting maxlength to 5000."));
            maxLen = 5000;
        }
        StringBuffer result = new StringBuffer("\"");
        for (int i = 0; i < maxLen; ++i) {
            int j = 0;
            j = i % 2 == 0 ? (int)(Math.random() * 26.0 + 65.0) : (int)(Math.random() * 26.0 + 97.0);
            result.append(Character.toString((char)j));
        }
        result.append("\"");
        return result.toString();
    }

    public String generateRandomStringValue(Column column) {
        return "\"\" + Math.random()";
    }

    private static String getDate(Date aDate) {
        return DataHelper.getDate(aDate, datePattern);
    }

    private static String getDate(Date aDate, String pattern) {
        String returnValue = "";
        if (aDate != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static synchronized String getDatePattern() {
        String result;
        try {
            result = ResourceBundle.getBundle("ApplicationResources", Locale.getDefault()).getString("date.format");
        }
        catch (MissingResourceException mse) {
            result = "MM/dd/yyyy";
        }
        return result;
    }

    public String getFieldDescription(String fieldName) {
        StringBuffer buffer = new StringBuffer();
        boolean nextUpper = false;
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (i == 0) {
                buffer.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                buffer.append(' ');
                buffer.append(c);
                continue;
            }
            if (c == '.') {
                buffer.delete(0, buffer.length());
                nextUpper = true;
                continue;
            }
            char x = nextUpper ? Character.toUpperCase(c) : c;
            buffer.append(x);
            nextUpper = false;
        }
        return buffer.toString();
    }

    public String getJdbcType(String javaType) {
        String jdbcType = "VARCHAR";
        if ((javaType = javaType.toLowerCase()).indexOf("date") > 0) {
            jdbcType = "TIMESTAMP";
        } else if (javaType.indexOf("timestamp") > 0) {
            jdbcType = "TIMESTAMP";
        } else if (javaType.indexOf("int") > 0 || javaType.indexOf("long") > 0 || javaType.indexOf("short") > 0) {
            jdbcType = "INTEGER";
        } else if (javaType.indexOf("double") > 0) {
            jdbcType = "DOUBLE";
        } else if (javaType.indexOf("float") > 0) {
            jdbcType = "FLOAT";
        }
        return jdbcType;
    }
}

