/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.tool;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SubversionUtils {
    private String url;
    private String destinationDirectory;

    public SubversionUtils(String url, String destinationDirectory) {
        SubversionUtils.setupLibrary();
        this.url = url;
        this.destinationDirectory = destinationDirectory;
    }

    public void export() throws SVNException {
        SVNURL url = SVNURL.parseURIEncoded((String)this.url);
        String userName = "guest";
        String userPassword = "guest";
        File exportDir = new File(this.destinationDirectory);
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)url);
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)userName, (String)userPassword);
        repository.setAuthenticationManager(authManager);
        SVNNodeKind nodeKind = repository.checkPath("", -1L);
        if (nodeKind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"No entry at URL ''{0}''", (Object)url);
            throw new SVNException(err);
        }
        if (nodeKind == SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Entry at URL ''{0}'' is a file while directory was expected", (Object)url);
            throw new SVNException(err);
        }
        long latestRevision = repository.getLatestRevision();
        ExportReporterBaton reporterBaton = new ExportReporterBaton(latestRevision);
        ExportEditor exportEditor = new ExportEditor(exportDir);
        repository.update(latestRevision, null, true, (ISVNReporterBaton)reporterBaton, (ISVNEditor)exportEditor);
    }

    private static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    private static class ExportEditor
    implements ISVNEditor {
        private File myRootDirectory;
        private SVNDeltaProcessor myDeltaProcessor;

        public ExportEditor(File root) {
            this.myRootDirectory = root;
            this.myDeltaProcessor = new SVNDeltaProcessor();
        }

        public void targetRevision(long revision) throws SVNException {
        }

        public void openRoot(long revision) throws SVNException {
        }

        public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
            File newDir = new File(this.myRootDirectory, path);
            if (newDir.exists() || !newDir.mkdirs()) {
                // empty if block
            }
        }

        public void openDir(String path, long revision) throws SVNException {
        }

        public void changeDirProperty(String name, String value) throws SVNException {
        }

        public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
            File file = new File(this.myRootDirectory, path);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)"error: cannot create new  file ''{0}''", (Object)file);
                    throw new SVNException(err);
                }
            }
        }

        public void openFile(String path, long revision) throws SVNException {
        }

        public void changeFileProperty(String path, String name, String value) throws SVNException {
        }

        public void applyTextDelta(String path, String baseChecksum) throws SVNException {
            this.myDeltaProcessor.applyTextDelta(null, new File(this.myRootDirectory, path), false);
        }

        public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
            return this.myDeltaProcessor.textDeltaChunk(diffWindow);
        }

        public void textDeltaEnd(String path) throws SVNException {
            this.myDeltaProcessor.textDeltaEnd();
        }

        public void closeFile(String path, String textChecksum) throws SVNException {
        }

        public void closeDir() throws SVNException {
        }

        public void deleteEntry(String path, long revision) throws SVNException {
        }

        public void absentDir(String path) throws SVNException {
        }

        public void absentFile(String path) throws SVNException {
        }

        public SVNCommitInfo closeEdit() throws SVNException {
            return null;
        }

        public void abortEdit() throws SVNException {
        }
    }

    private static class ExportReporterBaton
    implements ISVNReporterBaton {
        private long exportRevision;

        public ExportReporterBaton(long revision) {
            this.exportRevision = revision;
        }

        public void report(ISVNReporter reporter) throws SVNException {
            try {
                reporter.setPath("", null, this.exportRevision, true);
                reporter.finishReport();
            }
            catch (SVNException svne) {
                reporter.abortReport();
                System.out.println("Report failed.");
            }
        }
    }
}

