/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon;

import java.io.File;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.arquillian.container.chameleon.ChameleonDeployableContainerConfiguration;
import org.arquillian.container.chameleon.Utils;
import org.arquillian.container.chameleon.spi.Profile;
import org.arquillian.container.chameleon.spi.Target;
import org.jboss.arquillian.container.impl.MapObject;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.resolver.api.Coordinate;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomlessResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChameleonDeployableContainer
implements DeployableContainer<ChameleonDeployableContainerConfiguration> {
    private static final String MAVEN_OUTPUT_DIRECTORY = "target";
    private static final String GRADLE_OUTPUT_DIRECTORY = "bin";
    private ClassLoader classloader;
    private DeployableContainer delegate;
    private Map<String, String> delegateConfiguration;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    @Inject
    private Instance<Injector> injectorInst;

    public Class<ChameleonDeployableContainerConfiguration> getConfigurationClass() {
        return ChameleonDeployableContainerConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public void setDelegateConfiguration(Map<String, String> delegateConfiguration) {
        this.delegateConfiguration = delegateConfiguration;
    }

    public void setup(ChameleonDeployableContainerConfiguration configuration) {
        Profile profile = configuration.getProfile();
        Target target = profile.getTarget();
        Target.Type type = target.getType();
        if (this.enableDefaultConfigurationProperties(profile)) {
            switch (profile.getTarget().getType()) {
                case Embedded: 
                case Managed: {
                    File serverHome = this.resolveDistributablePackage(configuration, profile, type);
                    this.setDefaultConfigurationProperties(profile, serverHome);
                    break;
                }
            }
        }
        this.resolveClasspathDependencies(profile);
    }

    private File resolveDistributablePackage(ChameleonDeployableContainerConfiguration configuration, Profile profile, Target.Type type) {
        MavenCoordinate distributableCoordinate = profile.getDistributableCoordinates();
        if (distributableCoordinate != null) {
            File targetDirectory = new File(new File(this.getOutputDirectory(configuration), "server"), distributableCoordinate.getArtifactId() + "_" + distributableCoordinate.getVersion());
            if (targetDirectory.exists()) {
                return this.getServerHome(targetDirectory);
            }
            targetDirectory.mkdirs();
            File uncompressDirectory = ((ExplodedExporter)((GenericArchive)((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(distributableCoordinate.toCanonicalForm())).withoutTransitivity()).asSingle(GenericArchive.class)).as(ExplodedExporter.class)).exportExploded(targetDirectory, ".");
            return this.getServerHome(uncompressDirectory);
        }
        return null;
    }

    private File getServerHome(File uncompressDirectory) {
        File[] currentDirectoryContent = uncompressDirectory.listFiles();
        if (currentDirectoryContent.length == 1 && currentDirectoryContent[0].isDirectory()) {
            return currentDirectoryContent[0];
        }
        return uncompressDirectory;
    }

    private boolean enableDefaultConfigurationProperties(Profile profile) {
        Map<String, String> configuration = profile.getDefaultConfigurationPropertyVariablesValue("DUMMY_VALUE");
        Set<Map.Entry<String, String>> entrySet = configuration.entrySet();
        for (Map.Entry<String, String> property : entrySet) {
            String propertyKey = property.getKey();
            if (!this.delegateConfiguration.containsKey(propertyKey)) continue;
            return false;
        }
        return true;
    }

    private void setDefaultConfigurationProperties(Profile profile, File serverHome) {
        Map<String, String> configuration = profile.getDefaultConfigurationPropertyVariablesValue(serverHome.getAbsolutePath());
        Set<Map.Entry<String, String>> entrySet = configuration.entrySet();
        for (Map.Entry<String, String> property : entrySet) {
            String propertyKey = property.getKey();
            if (!this.isSystemPropertyNotSet(propertyKey) || this.delegateConfiguration.containsKey(propertyKey)) continue;
            this.delegateConfiguration.put(propertyKey, property.getValue());
        }
    }

    private boolean isSystemPropertyNotSet(String systemProperty) {
        return System.getProperty(systemProperty) == null;
    }

    private String getOutputDirectory(ChameleonDeployableContainerConfiguration configuration) {
        if (Files.exists(Paths.get(GRADLE_OUTPUT_DIRECTORY, new String[0]), new LinkOption[0])) {
            return GRADLE_OUTPUT_DIRECTORY;
        }
        if (Files.exists(Paths.get(MAVEN_OUTPUT_DIRECTORY, new String[0]), new LinkOption[0])) {
            return MAVEN_OUTPUT_DIRECTORY;
        }
        return MAVEN_OUTPUT_DIRECTORY;
    }

    private void resolveClasspathDependencies(Profile profile) {
        String[] dependencies = profile.getDependencies();
        try {
            MavenDependency[] mavenDependencies = Utils.toMavenDependencies(dependencies, profile.getExclusions());
            File[] archives = ((MavenFormatStage)((MavenStrategyStage)((PomlessResolveStage)Maven.configureResolver().addDependencies((Coordinate[])mavenDependencies)).resolve()).withTransitivity()).asFile();
            this.classloader = new URLClassLoader(Utils.toURLs(archives), ChameleonDeployableContainer.class.getClassLoader());
            final Class<?> delegateClass = this.classloader.loadClass(profile.getDeloyableContainerClass());
            this.lifecycle(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ChameleonDeployableContainer.this.delegate = (DeployableContainer)delegateClass.newInstance();
                    ((Injector)ChameleonDeployableContainer.this.injectorInst.get()).inject((Object)ChameleonDeployableContainer.this.delegate);
                    ContainerConfiguration delegateConfig = (ContainerConfiguration)ChameleonDeployableContainer.this.delegate.getConfigurationClass().newInstance();
                    MapObject.populate((Object)delegateConfig, (Map)ChameleonDeployableContainer.this.delegateConfiguration);
                    delegateConfig.validate();
                    ChameleonDeployableContainer.this.delegate.setup(delegateConfig);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup chameleon container", e);
        }
    }

    public void start() throws LifecycleException {
        this.lifecycle(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ChameleonDeployableContainer.this.delegate.start();
                return null;
            }
        });
    }

    public void stop() throws LifecycleException {
        this.lifecycle(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ChameleonDeployableContainer.this.delegate.stop();
                return null;
            }
        });
    }

    public ProtocolMetaData deploy(final Archive<?> archive) throws DeploymentException {
        return this.deployment(new Callable<ProtocolMetaData>(){

            @Override
            public ProtocolMetaData call() throws Exception {
                return ChameleonDeployableContainer.this.delegate.deploy(archive);
            }
        });
    }

    public void undeploy(final Archive<?> archive) throws DeploymentException {
        this.deployment(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ChameleonDeployableContainer.this.delegate.undeploy(archive);
                return null;
            }
        });
    }

    public void deploy(final Descriptor descriptor) throws DeploymentException {
        this.deployment(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ChameleonDeployableContainer.this.delegate.deploy(descriptor);
                return null;
            }
        });
    }

    public void undeploy(final Descriptor descriptor) throws DeploymentException {
        this.deployment(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ChameleonDeployableContainer.this.delegate.undeploy(descriptor);
                return null;
            }
        });
    }

    private <T> T deployment(Callable<T> callable) throws DeploymentException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            T t = callable.call();
            return t;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Could not proxy call", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    private <T> T lifecycle(Callable<T> callable) throws LifecycleException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            T t = callable.call();
            return t;
        }
        catch (LifecycleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LifecycleException("Could not proxy call", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }
}

