/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.spi;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.container.chameleon.spi.Target;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile {
    private Target target;
    private String[] dependencies;
    private String[] exclusions;

    public Profile(Target target, String[] dependencies, String[] exclusions) {
        this.target = target;
        this.dependencies = dependencies;
        this.exclusions = exclusions;
    }

    public Target getTarget() {
        return this.target;
    }

    public String[] getDependencies() {
        return this.dependencies;
    }

    public String[] getExclusions() {
        return this.exclusions;
    }

    public String getDeloyableContainerClass() {
        return "org.jboss.as.arquillian.container." + this.target.getType().name().toLowerCase() + "." + this.target.getType().name() + "DeployableContainer";
    }

    public static Profile from(Target target) {
        String[] exclusions = new String[]{"org.jboss.arquillian.test:*", "org.jboss.arquillian.testenricher:*", "org.jboss.arquillian.container:*", "org.jboss.arquillian.core:*", "org.jboss.arquillian.config:*", "org.jboss.arquillian.protocol:*", "org.jboss.shrinkwrap.api:*", "org.jboss.shrinkwrap:*", "org.jboss.shrinkwrap.descriptors:*", "org.jboss.shrinkwrap.resolver:*", "*:wildfly-arquillian-testenricher-msc", "*:wildfly-arquillian-protocol-jmx", "*:jboss-as-arquillian-testenricher-msc", "*:jboss-as-arquillian-protocol-jmx"};
        return new Profile(target, Profile.getDependencies(target), exclusions);
    }

    public Map<String, String> getDefaultConfigurationPropertyVariablesValue(String installationDirectory) {
        HashMap<String, String> propertiesSet = new HashMap<String, String>();
        switch (this.target.getServer()) {
            case WILDFLY: {
                propertiesSet.putAll(this.getWildflyNotSetSystemProperties(installationDirectory));
                break;
            }
            case JBOSS_AS: {
                propertiesSet.putAll(this.getWildflyNotSetSystemProperties(installationDirectory));
                break;
            }
        }
        return propertiesSet;
    }

    private Map<String, String> getWildflyNotSetSystemProperties(String installationDirectory) {
        HashMap<String, String> propertiesSet = new HashMap<String, String>();
        propertiesSet.put("jbossHome", installationDirectory);
        propertiesSet.put("modulePath", Paths.get(installationDirectory, "modules").toString());
        return propertiesSet;
    }

    public MavenCoordinate getDistributableCoordinates() {
        switch (this.target.getServer()) {
            case WILDFLY: {
                String dep = Profile.getWildflyDistributableCoordinates(this.target.getVersion());
                MavenCoordinate mavenCoordinates = this.toMavenCoordinate(dep);
                return mavenCoordinates;
            }
            case JBOSS_AS: {
                String dep = Profile.getJBossASDistributableCoordinates(this.target.getVersion());
                MavenCoordinate mavenCoordinates = this.toMavenCoordinate(dep);
                return mavenCoordinates;
            }
        }
        throw new ConfigurationException("Unknown target: " + this.target);
    }

    private MavenCoordinate toMavenCoordinate(String dep) {
        return MavenCoordinates.createCoordinate((String)dep);
    }

    private static String getWildflyDistributableCoordinates(String version) {
        return "org.wildfly:wildfly-dist:zip:" + version;
    }

    private static String getJBossASDistributableCoordinates(String version) {
        return "org.jboss.as:jboss-as-dist:zip:" + version;
    }

    public static String[] getDependencies(Target target) {
        if (target.getServer() == Target.Server.WILDFLY && target.getVersion().startsWith("8.")) {
            return Profile.getDependenciesWildFly8(target.getVersion(), target.getType());
        }
        if (target.getServer() == Target.Server.WILDFLY && target.getVersion().startsWith("9.")) {
            return Profile.getDependenciesWildFly9("1.0.0.Alpha5", target.getType());
        }
        if (target.getServer() == Target.Server.JBOSS_AS) {
            return Profile.getDependenciesJBossAS(target.getVersion(), target.getType());
        }
        if (target.getServer() == Target.Server.JBOSS_EAP && target.getVersion().startsWith("6.0")) {
            return Profile.getDependenciesJBossAS("7.1.2.Final", target.getType());
        }
        if (target.getServer() == Target.Server.JBOSS_EAP && target.getVersion().startsWith("6.")) {
            return Profile.getDependenciesJBossAS("7.2.0.Final", target.getType());
        }
        throw new ConfigurationException("Unknown target: " + target);
    }

    private static String[] getDependenciesJBossAS(String version, Target.Type type) {
        return new String[]{"org.jboss.as:jboss-as-arquillian-container-" + type.name().toLowerCase() + ":" + version};
    }

    private static String[] getDependenciesWildFly8(String version, Target.Type type) {
        return new String[]{"org.wildfly:wildfly-arquillian-container-" + type.name().toLowerCase() + ":" + version};
    }

    private static String[] getDependenciesWildFly9(String version, Target.Type type) {
        return new String[]{"org.wildfly.arquillian:wildfly-arquillian-container-" + type.name().toLowerCase() + ":" + version};
    }
}

