/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.spi;

import org.jboss.arquillian.container.spi.ConfigurationException;

public class Target {
    private Server server;
    private String version;
    private Type type;

    public Type getType() {
        return this.type;
    }

    public Server getServer() {
        return this.server;
    }

    public String getVersion() {
        return this.version;
    }

    public static Target from(String source) {
        Target target = new Target();
        String[] sections = source.split(":");
        if (sections.length != 3) {
            throw new ConfigurationException("Wrong target format [" + source + "] server:version:type");
        }
        for (Server server : Server.values()) {
            if (!sections[0].toLowerCase().contains(server.name().toLowerCase().replaceAll("_", " "))) continue;
            target.server = server;
            break;
        }
        target.version = sections[1];
        for (Enum enum_ : Type.values()) {
            if (!sections[2].toLowerCase().contains(enum_.name().toLowerCase())) continue;
            target.type = enum_;
            break;
        }
        return target;
    }

    public String toString() {
        return (Object)((Object)this.server) + ":" + this.version + ":" + (Object)((Object)this.type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Remote,
        Managed,
        Embedded;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Server {
        WILDFLY,
        JBOSS_AS,
        JBOSS_EAP;

    }
}

